/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ListMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    private final HashMap<K, V> backingMap;
    private ListMapEntry<K, V>[] entries;

    public ListMap() {
        this.entries = new ListMapEntry[4];
        this.backingMap = new HashMap(4);
    }

    public ListMap(int initialCapacity) {
        this.entries = new ListMapEntry[initialCapacity];
        this.backingMap = new HashMap(initialCapacity);
    }

    public ListMap(Map<? extends K, ? extends V> map2) {
        this.entries = new ListMapEntry[map2.size()];
        this.backingMap = new HashMap(map2.size());
        this.putAll(map2);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    public Map.Entry<K, V> getEntry(int index2) {
        return this.entries[index2];
    }

    public V getValue(int index2) {
        return (V)((ListMapEntry)this.entries[index2]).value;
    }

    public K getKey(int index2) {
        return (K)((ListMapEntry)this.entries[index2]).key;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean keyEq(Object keyA, Object keyB) {
        return keyA.hashCode() == keyB.hashCode() ? keyA == keyB || keyA.equals(keyB) : false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.backingMap.containsKey(key)) {
            int size2 = this.size();
            for (int i = 0; i < size2; ++i) {
                ListMapEntry<K, V> entry = this.entries[i];
                if (!ListMap.keyEq(((ListMapEntry)entry).key, key)) continue;
                ((ListMapEntry)entry).value = value;
                break;
            }
        } else {
            int size3 = this.size();
            if (size3 == this.entries.length) {
                ListMapEntry<K, V>[] tmpEntries = this.entries;
                this.entries = new ListMapEntry[size3 * 2];
                System.arraycopy(tmpEntries, 0, this.entries, 0, size3);
            }
            this.entries[size3] = new ListMapEntry<K, V>(key, value);
        }
        return this.backingMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V element = this.backingMap.remove(key);
        if (element != null) {
            int i;
            int size2 = this.size() + 1;
            int removedIndex = -1;
            for (i = 0; i < size2; ++i) {
                ListMapEntry<K, V> entry = this.entries[i];
                if (!ListMap.keyEq(((ListMapEntry)entry).key, key)) continue;
                removedIndex = i;
                break;
            }
            assert (removedIndex >= 0);
            --size2;
            for (i = removedIndex; i < size2; ++i) {
                this.entries[i] = this.entries[i + 1];
            }
        }
        return element;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public ListMap<K, V> clone() {
        ListMap<K, V> clone2 = new ListMap<K, V>(this.size());
        clone2.putAll(this);
        return clone2;
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    private static final class ListMapEntry<K, V>
    implements Map.Entry<K, V>,
    Cloneable {
        private final K key;
        private V value;

        public ListMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        public ListMapEntry<K, V> clone() {
            return new ListMapEntry<K, V>(this.key, this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListMapEntry other = (ListMapEntry)obj;
            if (!(this.key == other.key || this.key != null && this.key.equals(other.key))) {
                return false;
            }
            return this.value == other.value || this.value != null && this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return (this.key != null ? this.key.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
        }
    }
}

