/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.util.BufferAllocator;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.StampedLock;
import java.util.logging.Logger;
import org.lwjgl.system.MemoryUtil;

public class LWJGLBufferAllocator
implements BufferAllocator {
    private static final Logger LOGGER = Logger.getLogger(LWJGLBufferAllocator.class.getName());
    public static final String PROPERTY_CONCURRENT_BUFFER_ALLOCATOR = "com.jme3.lwjgl3.ConcurrentBufferAllocator";
    private static final ReferenceQueue<Buffer> DUMMY_QUEUE = new ReferenceQueue();
    private static final Thread CLEAN_THREAD = new Thread(LWJGLBufferAllocator::freeByteBuffers);
    private static final Map<Long, Deallocator> DEALLOCATORS = new ConcurrentHashMap<Long, Deallocator>();

    static void freeByteBuffers() {
        try {
            while (true) {
                Deallocator deallocator = (Deallocator)DUMMY_QUEUE.remove();
                deallocator.free();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void destroyDirectBuffer(Buffer buffer) {
        long address = this.getAddress(buffer);
        if (address == -1L) {
            LOGGER.warning("Not found address of the " + buffer);
            return;
        }
        Deallocator deallocator = DEALLOCATORS.remove(address);
        if (deallocator == null) {
            LOGGER.warning("Not found a deallocator for address " + address);
            return;
        }
        deallocator.setAddress(null);
        MemoryUtil.memFree(buffer);
    }

    long getAddress(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return MemoryUtil.memAddress((ByteBuffer)buffer, 0);
        }
        if (buffer instanceof ShortBuffer) {
            return MemoryUtil.memAddress((ShortBuffer)buffer, 0);
        }
        if (buffer instanceof CharBuffer) {
            return MemoryUtil.memAddress((CharBuffer)buffer, 0);
        }
        if (buffer instanceof IntBuffer) {
            return MemoryUtil.memAddress((IntBuffer)buffer, 0);
        }
        if (buffer instanceof FloatBuffer) {
            return MemoryUtil.memAddress((FloatBuffer)buffer, 0);
        }
        if (buffer instanceof LongBuffer) {
            return MemoryUtil.memAddress((LongBuffer)buffer, 0);
        }
        if (buffer instanceof DoubleBuffer) {
            return MemoryUtil.memAddress((DoubleBuffer)buffer, 0);
        }
        return -1L;
    }

    @Override
    public ByteBuffer allocate(int size2) {
        Long address = MemoryUtil.nmemAlloc(size2);
        ByteBuffer byteBuffer = MemoryUtil.memByteBuffer(address, size2);
        DEALLOCATORS.put(address, this.createDeallocator(address, byteBuffer));
        return byteBuffer;
    }

    Deallocator createDeallocator(Long address, ByteBuffer byteBuffer) {
        return new Deallocator(byteBuffer, DUMMY_QUEUE, address);
    }

    static {
        CLEAN_THREAD.setDaemon(true);
        CLEAN_THREAD.setName("LWJGL Deallocator");
        CLEAN_THREAD.start();
    }

    static class Deallocator
    extends PhantomReference<ByteBuffer> {
        volatile Long address;

        Deallocator(ByteBuffer referent, ReferenceQueue<? super ByteBuffer> queue, Long address) {
            super(referent, queue);
            this.address = address;
        }

        void setAddress(Long address) {
            this.address = address;
        }

        void free() {
            if (this.address == null) {
                return;
            }
            this.freeMemory();
            DEALLOCATORS.remove(this.address);
        }

        void freeMemory() {
            MemoryUtil.nmemFree(this.address);
        }
    }

    static class ConcurrentDeallocator
    extends Deallocator {
        final StampedLock stampedLock;

        ConcurrentDeallocator(ByteBuffer referent, ReferenceQueue<? super ByteBuffer> queue, Long address, StampedLock stampedLock) {
            super(referent, queue, address);
            this.stampedLock = stampedLock;
        }

        @Override
        protected void freeMemory() {
            long stamp = this.stampedLock.writeLock();
            try {
                super.freeMemory();
            }
            finally {
                this.stampedLock.unlockWrite(stamp);
            }
        }
    }

    public static class ConcurrentLWJGLBufferAllocator
    extends LWJGLBufferAllocator {
        private final StampedLock stampedLock = new StampedLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroyDirectBuffer(Buffer buffer) {
            long stamp = this.stampedLock.writeLock();
            try {
                super.destroyDirectBuffer(buffer);
            }
            finally {
                this.stampedLock.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer allocate(int size2) {
            long stamp = this.stampedLock.writeLock();
            try {
                ByteBuffer byteBuffer = super.allocate(size2);
                return byteBuffer;
            }
            finally {
                this.stampedLock.unlockWrite(stamp);
            }
        }

        @Override
        Deallocator createDeallocator(Long address, ByteBuffer byteBuffer) {
            return new ConcurrentDeallocator(byteBuffer, DUMMY_QUEUE, address, this.stampedLock);
        }
    }
}

