/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.util.BufferAllocator;
import com.jme3.util.BufferAllocatorFactory;
import com.jme3.util.TempVars;
import java.io.UnsupportedEncodingException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.ConcurrentHashMap;

public final class BufferUtils {
    private static final BufferAllocator allocator = BufferAllocatorFactory.create();
    private static boolean trackDirectMemory = false;
    private static final ReferenceQueue<Buffer> removeCollected = new ReferenceQueue();
    private static final ConcurrentHashMap<BufferInfo, BufferInfo> trackedBuffers = new ConcurrentHashMap();
    static ClearReferences cleanupthread;

    private BufferUtils() {
    }

    public static void setTrackDirectMemoryEnabled(boolean enabled) {
        trackDirectMemory = enabled;
    }

    public static Buffer clone(Buffer buf) {
        if (buf instanceof FloatBuffer) {
            return BufferUtils.clone((FloatBuffer)buf);
        }
        if (buf instanceof ShortBuffer) {
            return BufferUtils.clone((ShortBuffer)buf);
        }
        if (buf instanceof ByteBuffer) {
            return BufferUtils.clone((ByteBuffer)buf);
        }
        if (buf instanceof IntBuffer) {
            return BufferUtils.clone((IntBuffer)buf);
        }
        if (buf instanceof DoubleBuffer) {
            return BufferUtils.clone((DoubleBuffer)buf);
        }
        throw new UnsupportedOperationException();
    }

    private static void onBufferAllocated(Buffer buffer) {
        if (trackDirectMemory) {
            if (cleanupthread == null) {
                cleanupthread = new ClearReferences();
                cleanupthread.start();
            }
            if (buffer instanceof ByteBuffer) {
                BufferInfo info2 = new BufferInfo(ByteBuffer.class, buffer.capacity(), buffer, removeCollected);
                trackedBuffers.put(info2, info2);
            } else if (buffer instanceof FloatBuffer) {
                BufferInfo info3 = new BufferInfo(FloatBuffer.class, buffer.capacity() * 4, buffer, removeCollected);
                trackedBuffers.put(info3, info3);
            } else if (buffer instanceof IntBuffer) {
                BufferInfo info4 = new BufferInfo(IntBuffer.class, buffer.capacity() * 4, buffer, removeCollected);
                trackedBuffers.put(info4, info4);
            } else if (buffer instanceof ShortBuffer) {
                BufferInfo info5 = new BufferInfo(ShortBuffer.class, buffer.capacity() * 2, buffer, removeCollected);
                trackedBuffers.put(info5, info5);
            } else if (buffer instanceof DoubleBuffer) {
                BufferInfo info6 = new BufferInfo(DoubleBuffer.class, buffer.capacity() * 8, buffer, removeCollected);
                trackedBuffers.put(info6, info6);
            }
        }
    }

    public static FloatBuffer createFloatBuffer(Vector3f ... data2) {
        if (data2 == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(3 * data2.length);
        for (Vector3f element : data2) {
            if (element != null) {
                buff.put(element.x).put(element.y).put(element.z);
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(Quaternion ... data2) {
        if (data2 == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(4 * data2.length);
        for (Quaternion element : data2) {
            if (element != null) {
                buff.put(element.getX()).put(element.getY()).put(element.getZ()).put(element.getW());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(Vector4f ... data2) {
        if (data2 == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(4 * data2.length);
        for (int x2 = 0; x2 < data2.length; ++x2) {
            if (data2[x2] != null) {
                buff.put(data2[x2].getX()).put(data2[x2].getY()).put(data2[x2].getZ()).put(data2[x2].getW());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(ColorRGBA ... data2) {
        if (data2 == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(4 * data2.length);
        for (int x2 = 0; x2 < data2.length; ++x2) {
            if (data2[x2] != null) {
                buff.put(data2[x2].getRed()).put(data2[x2].getGreen()).put(data2[x2].getBlue()).put(data2[x2].getAlpha());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(float ... data2) {
        if (data2 == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(data2.length);
        buff.clear();
        buff.put(data2);
        buff.flip();
        return buff;
    }

    public static FloatBuffer createVector3Buffer(int vertices) {
        FloatBuffer vBuff = BufferUtils.createFloatBuffer(3 * vertices);
        return vBuff;
    }

    public static FloatBuffer createVector3Buffer(FloatBuffer buf, int vertices) {
        if (buf != null && buf.limit() == 3 * vertices) {
            buf.rewind();
            return buf;
        }
        return BufferUtils.createFloatBuffer(3 * vertices);
    }

    public static void setInBuffer(ColorRGBA color2, FloatBuffer buf, int index2) {
        buf.position(index2 * 4);
        buf.put(color2.r);
        buf.put(color2.g);
        buf.put(color2.b);
        buf.put(color2.a);
    }

    public static void setInBuffer(Quaternion quat, FloatBuffer buf, int index2) {
        buf.position(index2 * 4);
        buf.put(quat.getX());
        buf.put(quat.getY());
        buf.put(quat.getZ());
        buf.put(quat.getW());
    }

    public static void setInBuffer(Vector4f vec, FloatBuffer buf, int index2) {
        buf.position(index2 * 4);
        buf.put(vec.getX());
        buf.put(vec.getY());
        buf.put(vec.getZ());
        buf.put(vec.getW());
    }

    public static void setInBuffer(Vector3f vector2, FloatBuffer buf, int index2) {
        if (buf == null) {
            return;
        }
        if (vector2 == null) {
            buf.put(index2 * 3, 0.0f);
            buf.put(index2 * 3 + 1, 0.0f);
            buf.put(index2 * 3 + 2, 0.0f);
        } else {
            buf.put(index2 * 3, vector2.x);
            buf.put(index2 * 3 + 1, vector2.y);
            buf.put(index2 * 3 + 2, vector2.z);
        }
    }

    public static void populateFromBuffer(Vector3f vector2, FloatBuffer buf, int index2) {
        vector2.x = buf.get(index2 * 3);
        vector2.y = buf.get(index2 * 3 + 1);
        vector2.z = buf.get(index2 * 3 + 2);
    }

    public static void populateFromBuffer(Vector4f vector2, FloatBuffer buf, int index2) {
        vector2.x = buf.get(index2 * 4);
        vector2.y = buf.get(index2 * 4 + 1);
        vector2.z = buf.get(index2 * 4 + 2);
        vector2.w = buf.get(index2 * 4 + 3);
    }

    public static Vector3f[] getVector3Array(FloatBuffer buff) {
        buff.clear();
        Vector3f[] verts = new Vector3f[buff.limit() / 3];
        for (int x2 = 0; x2 < verts.length; ++x2) {
            Vector3f v;
            verts[x2] = v = new Vector3f(buff.get(), buff.get(), buff.get());
        }
        return verts;
    }

    public static void copyInternalVector3(FloatBuffer buf, int fromPos, int toPos) {
        BufferUtils.copyInternal(buf, fromPos * 3, toPos * 3, 3);
    }

    public static void normalizeVector3(FloatBuffer buf, int index2) {
        TempVars vars = TempVars.get();
        Vector3f tempVec3 = vars.vect1;
        BufferUtils.populateFromBuffer(tempVec3, buf, index2);
        tempVec3.normalizeLocal();
        BufferUtils.setInBuffer(tempVec3, buf, index2);
        vars.release();
    }

    public static void addInBuffer(Vector3f toAdd, FloatBuffer buf, int index2) {
        TempVars vars = TempVars.get();
        Vector3f tempVec3 = vars.vect1;
        BufferUtils.populateFromBuffer(tempVec3, buf, index2);
        tempVec3.addLocal(toAdd);
        BufferUtils.setInBuffer(tempVec3, buf, index2);
        vars.release();
    }

    public static void multInBuffer(Vector3f toMult, FloatBuffer buf, int index2) {
        TempVars vars = TempVars.get();
        Vector3f tempVec3 = vars.vect1;
        BufferUtils.populateFromBuffer(tempVec3, buf, index2);
        tempVec3.multLocal(toMult);
        BufferUtils.setInBuffer(tempVec3, buf, index2);
        vars.release();
    }

    public static boolean equals(Vector3f check, FloatBuffer buf, int index2) {
        TempVars vars = TempVars.get();
        Vector3f tempVec3 = vars.vect1;
        BufferUtils.populateFromBuffer(tempVec3, buf, index2);
        boolean eq = tempVec3.equals(check);
        vars.release();
        return eq;
    }

    public static FloatBuffer createFloatBuffer(Vector2f ... data2) {
        if (data2 == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(2 * data2.length);
        for (Vector2f element : data2) {
            if (element != null) {
                buff.put(element.x).put(element.y);
                continue;
            }
            buff.put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createVector2Buffer(int vertices) {
        FloatBuffer vBuff = BufferUtils.createFloatBuffer(2 * vertices);
        return vBuff;
    }

    public static FloatBuffer createVector2Buffer(FloatBuffer buf, int vertices) {
        if (buf != null && buf.limit() == 2 * vertices) {
            buf.rewind();
            return buf;
        }
        return BufferUtils.createFloatBuffer(2 * vertices);
    }

    public static void setInBuffer(Vector2f vector2, FloatBuffer buf, int index2) {
        buf.put(index2 * 2, vector2.x);
        buf.put(index2 * 2 + 1, vector2.y);
    }

    public static void populateFromBuffer(Vector2f vector2, FloatBuffer buf, int index2) {
        vector2.x = buf.get(index2 * 2);
        vector2.y = buf.get(index2 * 2 + 1);
    }

    public static Vector2f[] getVector2Array(FloatBuffer buff) {
        buff.clear();
        Vector2f[] verts = new Vector2f[buff.limit() / 2];
        for (int x2 = 0; x2 < verts.length; ++x2) {
            Vector2f v;
            verts[x2] = v = new Vector2f(buff.get(), buff.get());
        }
        return verts;
    }

    public static void copyInternalVector2(FloatBuffer buf, int fromPos, int toPos) {
        BufferUtils.copyInternal(buf, fromPos * 2, toPos * 2, 2);
    }

    public static void normalizeVector2(FloatBuffer buf, int index2) {
        TempVars vars = TempVars.get();
        Vector2f tempVec2 = vars.vect2d;
        BufferUtils.populateFromBuffer(tempVec2, buf, index2);
        tempVec2.normalizeLocal();
        BufferUtils.setInBuffer(tempVec2, buf, index2);
        vars.release();
    }

    public static void addInBuffer(Vector2f toAdd, FloatBuffer buf, int index2) {
        TempVars vars = TempVars.get();
        Vector2f tempVec2 = vars.vect2d;
        BufferUtils.populateFromBuffer(tempVec2, buf, index2);
        tempVec2.addLocal(toAdd);
        BufferUtils.setInBuffer(tempVec2, buf, index2);
        vars.release();
    }

    public static void multInBuffer(Vector2f toMult, FloatBuffer buf, int index2) {
        TempVars vars = TempVars.get();
        Vector2f tempVec2 = vars.vect2d;
        BufferUtils.populateFromBuffer(tempVec2, buf, index2);
        tempVec2.multLocal(toMult);
        BufferUtils.setInBuffer(tempVec2, buf, index2);
        vars.release();
    }

    public static boolean equals(Vector2f check, FloatBuffer buf, int index2) {
        TempVars vars = TempVars.get();
        Vector2f tempVec2 = vars.vect2d;
        BufferUtils.populateFromBuffer(tempVec2, buf, index2);
        boolean eq = tempVec2.equals(check);
        vars.release();
        return eq;
    }

    public static IntBuffer createIntBuffer(int ... data2) {
        if (data2 == null) {
            return null;
        }
        IntBuffer buff = BufferUtils.createIntBuffer(data2.length);
        buff.clear();
        buff.put(data2);
        buff.flip();
        return buff;
    }

    public static int[] getIntArray(IntBuffer buff) {
        if (buff == null) {
            return null;
        }
        buff.clear();
        int[] inds = new int[buff.limit()];
        for (int x2 = 0; x2 < inds.length; ++x2) {
            inds[x2] = buff.get();
        }
        return inds;
    }

    public static float[] getFloatArray(FloatBuffer buff) {
        if (buff == null) {
            return null;
        }
        buff.clear();
        float[] inds = new float[buff.limit()];
        for (int x2 = 0; x2 < inds.length; ++x2) {
            inds[x2] = buff.get();
        }
        return inds;
    }

    public static DoubleBuffer createDoubleBuffer(int size2) {
        DoubleBuffer buf = allocator.allocate(8 * size2).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static DoubleBuffer createDoubleBuffer(DoubleBuffer buf, int size2) {
        if (buf != null && buf.limit() == size2) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createDoubleBuffer(size2);
        return buf;
    }

    public static DoubleBuffer clone(DoubleBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        DoubleBuffer copy2 = BufferUtils.isDirect(buf) ? BufferUtils.createDoubleBuffer(buf.limit()) : DoubleBuffer.allocate(buf.limit());
        copy2.put(buf);
        return copy2;
    }

    public static FloatBuffer createFloatBuffer(int size2) {
        FloatBuffer buf = allocator.allocate(4 * size2).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static void copyInternal(FloatBuffer buf, int fromPos, int toPos, int length) {
        float[] data2 = new float[length];
        buf.position(fromPos);
        buf.get(data2);
        buf.position(toPos);
        buf.put(data2);
    }

    public static FloatBuffer clone(FloatBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        FloatBuffer copy2 = BufferUtils.isDirect(buf) ? BufferUtils.createFloatBuffer(buf.limit()) : FloatBuffer.allocate(buf.limit());
        copy2.put(buf);
        return copy2;
    }

    public static IntBuffer createIntBuffer(int size2) {
        IntBuffer buf = allocator.allocate(4 * size2).order(ByteOrder.nativeOrder()).asIntBuffer();
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static IntBuffer createIntBuffer(IntBuffer buf, int size2) {
        if (buf != null && buf.limit() == size2) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createIntBuffer(size2);
        return buf;
    }

    public static IntBuffer clone(IntBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        IntBuffer copy2 = BufferUtils.isDirect(buf) ? BufferUtils.createIntBuffer(buf.limit()) : IntBuffer.allocate(buf.limit());
        copy2.put(buf);
        return copy2;
    }

    public static ByteBuffer createByteBuffer(int size2) {
        ByteBuffer buf = allocator.allocate(size2).order(ByteOrder.nativeOrder());
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static ByteBuffer createByteBuffer(ByteBuffer buf, int size2) {
        if (buf != null && buf.limit() == size2) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createByteBuffer(size2);
        return buf;
    }

    public static ByteBuffer createByteBuffer(byte ... data2) {
        ByteBuffer bb = BufferUtils.createByteBuffer(data2.length);
        bb.put(data2);
        bb.flip();
        return bb;
    }

    public static ByteBuffer createByteBuffer(String data2) {
        try {
            byte[] bytes = data2.getBytes("UTF-8");
            ByteBuffer bb = BufferUtils.createByteBuffer(bytes.length);
            bb.put(bytes);
            bb.flip();
            return bb;
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public static ByteBuffer clone(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        ByteBuffer copy2 = BufferUtils.isDirect(buf) ? BufferUtils.createByteBuffer(buf.limit()) : ByteBuffer.allocate(buf.limit());
        copy2.put(buf);
        return copy2;
    }

    public static ShortBuffer createShortBuffer(int size2) {
        ShortBuffer buf = allocator.allocate(2 * size2).order(ByteOrder.nativeOrder()).asShortBuffer();
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static ShortBuffer createShortBuffer(ShortBuffer buf, int size2) {
        if (buf != null && buf.limit() == size2) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createShortBuffer(size2);
        return buf;
    }

    public static ShortBuffer createShortBuffer(short ... data2) {
        if (data2 == null) {
            return null;
        }
        ShortBuffer buff = BufferUtils.createShortBuffer(data2.length);
        buff.clear();
        buff.put(data2);
        buff.flip();
        return buff;
    }

    public static ShortBuffer clone(ShortBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        ShortBuffer copy2 = BufferUtils.isDirect(buf) ? BufferUtils.createShortBuffer(buf.limit()) : ShortBuffer.allocate(buf.limit());
        copy2.put(buf);
        return copy2;
    }

    public static FloatBuffer ensureLargeEnough(FloatBuffer buffer, int required) {
        if (buffer != null) {
            buffer.limit(buffer.capacity());
        }
        if (buffer == null || buffer.remaining() < required) {
            int position = buffer != null ? buffer.position() : 0;
            FloatBuffer newVerts = BufferUtils.createFloatBuffer(position + required);
            if (buffer != null) {
                buffer.flip();
                newVerts.put(buffer);
                newVerts.position(position);
            }
            buffer = newVerts;
        }
        return buffer;
    }

    public static IntBuffer ensureLargeEnough(IntBuffer buffer, int required) {
        if (buffer != null) {
            buffer.limit(buffer.capacity());
        }
        if (buffer == null || buffer.remaining() < required) {
            int position = buffer != null ? buffer.position() : 0;
            IntBuffer newVerts = BufferUtils.createIntBuffer(position + required);
            if (buffer != null) {
                buffer.flip();
                newVerts.put(buffer);
                newVerts.position(position);
            }
            buffer = newVerts;
        }
        return buffer;
    }

    public static ShortBuffer ensureLargeEnough(ShortBuffer buffer, int required) {
        if (buffer != null) {
            buffer.limit(buffer.capacity());
        }
        if (buffer == null || buffer.remaining() < required) {
            int position = buffer != null ? buffer.position() : 0;
            ShortBuffer newVerts = BufferUtils.createShortBuffer(position + required);
            if (buffer != null) {
                buffer.flip();
                newVerts.put(buffer);
                newVerts.position(position);
            }
            buffer = newVerts;
        }
        return buffer;
    }

    public static ByteBuffer ensureLargeEnough(ByteBuffer buffer, int required) {
        if (buffer != null) {
            buffer.limit(buffer.capacity());
        }
        if (buffer == null || buffer.remaining() < required) {
            int position = buffer != null ? buffer.position() : 0;
            ByteBuffer newVerts = BufferUtils.createByteBuffer(position + required);
            if (buffer != null) {
                buffer.flip();
                newVerts.put(buffer);
                newVerts.position(position);
            }
            buffer = newVerts;
        }
        return buffer;
    }

    public static void printCurrentDirectMemory(StringBuilder store) {
        boolean printStout;
        long totalHeld = 0L;
        long heapMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        boolean bl = printStout = store == null;
        if (store == null) {
            store = new StringBuilder();
        }
        if (trackDirectMemory) {
            int fBufs = 0;
            int bBufs = 0;
            int iBufs = 0;
            int sBufs = 0;
            int dBufs = 0;
            int fBufsM = 0;
            int bBufsM = 0;
            int iBufsM = 0;
            int sBufsM = 0;
            int dBufsM = 0;
            for (BufferInfo b : trackedBuffers.values()) {
                if (b.type == ByteBuffer.class) {
                    totalHeld += (long)b.size;
                    bBufsM += b.size;
                    ++bBufs;
                    continue;
                }
                if (b.type == FloatBuffer.class) {
                    totalHeld += (long)b.size;
                    fBufsM += b.size;
                    ++fBufs;
                    continue;
                }
                if (b.type == IntBuffer.class) {
                    totalHeld += (long)b.size;
                    iBufsM += b.size;
                    ++iBufs;
                    continue;
                }
                if (b.type == ShortBuffer.class) {
                    totalHeld += (long)b.size;
                    sBufsM += b.size;
                    ++sBufs;
                    continue;
                }
                if (b.type != DoubleBuffer.class) continue;
                totalHeld += (long)b.size;
                dBufsM += b.size;
                ++dBufs;
            }
            store.append("Existing buffers: ").append(trackedBuffers.size()).append("\n");
            store.append("(b: ").append(bBufs).append("  f: ").append(fBufs).append("  i: ").append(iBufs).append("  s: ").append(sBufs).append("  d: ").append(dBufs).append(")").append("\n");
            store.append("Total   heap memory held: ").append(heapMem / 1024L).append("kb\n");
            store.append("Total direct memory held: ").append(totalHeld / 1024L).append("kb\n");
            store.append("(b: ").append(bBufsM / 1024).append("kb  f: ").append(fBufsM / 1024).append("kb  i: ").append(iBufsM / 1024).append("kb  s: ").append(sBufsM / 1024).append("kb  d: ").append(dBufsM / 1024).append("kb)").append("\n");
        } else {
            store.append("Total   heap memory held: ").append(heapMem / 1024L).append("kb\n");
            store.append("Only heap memory available, if you want to monitor direct memory use BufferUtils.setTrackDirectMemoryEnabled(true) during initialization.").append("\n");
        }
        if (printStout) {
            System.out.println(store.toString());
        }
    }

    public static void destroyDirectBuffer(Buffer toBeDestroyed) {
        if (!BufferUtils.isDirect(toBeDestroyed)) {
            return;
        }
        allocator.destroyDirectBuffer(toBeDestroyed);
    }

    private static boolean isDirect(Buffer buf) {
        return buf.isDirect();
    }

    private static class ClearReferences
    extends Thread {
        ClearReferences() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Reference toclean = removeCollected.remove();
                    trackedBuffers.remove(toclean);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private static class BufferInfo
    extends PhantomReference<Buffer> {
        private Class type;
        private int size;

        public BufferInfo(Class type2, int size2, Buffer referent, ReferenceQueue<? super Buffer> q) {
            super(referent, q);
            this.type = type2;
            this.size = size2;
        }
    }
}

