/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;

public final class AreaUtils {
    private AreaUtils() {
    }

    public static float calcScreenArea(BoundingVolume bound, float distance, float screenWidth) {
        if (bound.getType() == BoundingVolume.Type.Sphere) {
            return AreaUtils.calcScreenArea((BoundingSphere)bound, distance, screenWidth);
        }
        if (bound.getType() == BoundingVolume.Type.AABB) {
            return AreaUtils.calcScreenArea((BoundingBox)bound, distance, screenWidth);
        }
        return 0.0f;
    }

    private static float calcScreenArea(BoundingSphere bound, float distance, float screenWidth) {
        float radius = bound.getRadius() * screenWidth / (distance * 2.0f);
        return radius * radius * (float)Math.PI;
    }

    private static float calcScreenArea(BoundingBox bound, float distance, float screenWidth) {
        float radiusSquare = bound.getXExtent() * bound.getXExtent() + bound.getYExtent() * bound.getYExtent() + bound.getZExtent() * bound.getZExtent();
        return radiusSquare * screenWidth * screenWidth / (distance * distance * 4.0f) * (float)Math.PI;
    }
}

