/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins.ktx;

import com.jme3.renderer.Caps;
import com.jme3.renderer.opengl.GLImageFormat;
import com.jme3.renderer.opengl.GLImageFormats;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.Texture3D;
import com.jme3.texture.TextureArray;
import com.jme3.texture.TextureCubeMap;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KTXWriter {
    private static final Logger log = Logger.getLogger(KTXWriter.class.getName());
    private final String filePath;
    private static final byte[] fileIdentifier = new byte[]{-85, 75, 84, 88, 32, 49, 49, -69, 13, 10, 26, 10};

    public KTXWriter(String path) {
        this.filePath = path;
    }

    public void write(Image image, String fileName) {
        this.write(image, Texture2D.class, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Image image, Class<? extends Texture> textureType, String fileName) {
        FileOutputStream outs = null;
        try {
            File file = new File(this.filePath + "/" + fileName);
            outs = new FileOutputStream(file);
            DataOutputStream out = new DataOutputStream(outs);
            out.write(fileIdentifier);
            out.writeInt(67305985);
            GLImageFormat format2 = this.getGlFormat(image.getFormat());
            out.writeInt(format2.dataType);
            out.writeInt(1);
            out.writeInt(format2.format);
            out.writeInt(format2.internalFormat);
            out.writeInt(format2.format);
            out.writeInt(image.getWidth());
            out.writeInt(image.getHeight());
            int pixelDepth = 1;
            int numberOfArrayElements = 1;
            int numberOfFaces = 1;
            if (image.getDepth() > 1 && textureType == Texture3D.class) {
                pixelDepth = image.getDepth();
            }
            if (image.getData().size() > 1) {
                if (textureType == TextureArray.class) {
                    numberOfArrayElements = image.getData().size();
                }
                if (textureType == TextureCubeMap.class) {
                    numberOfFaces = image.getData().size();
                }
            }
            out.writeInt(pixelDepth);
            out.writeInt(numberOfArrayElements);
            out.writeInt(numberOfFaces);
            int numberOfMipmapLevels = 1;
            if (image.hasMipmaps()) {
                numberOfMipmapLevels = image.getMipMapSizes().length;
            }
            out.writeInt(numberOfMipmapLevels);
            String keyValues = "KTXorientation\u0000S=r,T=u\u0000";
            int bytesOfKeyValueData = keyValues.length() + 4;
            int padding2 = 3 - (bytesOfKeyValueData + 3) % 4;
            out.writeInt(bytesOfKeyValueData += padding2);
            out.writeInt(bytesOfKeyValueData - 4 - padding2);
            out.writeBytes(keyValues);
            this.pad(padding2, out);
            int offset2 = 0;
            for (int mipLevel = 0; mipLevel < numberOfMipmapLevels; ++mipLevel) {
                int width2 = Math.max(1, image.getWidth() >> mipLevel);
                int height2 = Math.max(1, image.getHeight() >> mipLevel);
                int imageSize = image.hasMipmaps() ? image.getMipMapSizes()[mipLevel] : width2 * height2 * image.getFormat().getBitsPerPixel() / 8;
                out.writeInt(imageSize);
                for (int arrayElem = 0; arrayElem < numberOfArrayElements; ++arrayElem) {
                    for (int face = 0; face < numberOfFaces; ++face) {
                        int nbPixelWritten = 0;
                        for (int depth = 0; depth < pixelDepth; ++depth) {
                            ByteBuffer byteBuffer = image.getData(KTXWriter.getSlice(face, arrayElem));
                            log.log(Level.FINE, "position {0}", byteBuffer.position());
                            byteBuffer.position(offset2);
                            byte[] b = this.getByteBufferArray(byteBuffer, imageSize);
                            out.write(b);
                            nbPixelWritten = b.length;
                        }
                        if (numberOfFaces != 6 || numberOfArrayElements != 0) continue;
                        padding2 = 3 - (nbPixelWritten + 3) % 4;
                        this.pad(padding2, out);
                    }
                }
                log.log(Level.FINE, "skipping {0}", 3 - (imageSize + 3) % 4);
                padding2 = 3 - (imageSize + 3) % 4;
                this.pad(padding2, out);
                offset2 += imageSize;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(KTXWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(KTXWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (outs != null) {
                    outs.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(KTXWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void pad(int padding2, DataOutput out) throws IOException {
        for (int i = 0; i < padding2; ++i) {
            out.write(0);
        }
    }

    private byte[] getByteBufferArray(ByteBuffer byteBuffer, int size2) {
        byte[] b;
        if (byteBuffer.hasArray()) {
            b = byteBuffer.array();
        } else {
            b = new byte[size2];
            byteBuffer.get(b, 0, size2);
        }
        return b;
    }

    private GLImageFormat getGlFormat(Image.Format format2) {
        EnumSet<Caps> caps = EnumSet.allOf(Caps.class);
        GLImageFormat[][] formats = GLImageFormats.getFormatsForCaps(caps);
        return formats[0][format2.ordinal()];
    }

    private static int getSlice(int face, int arrayElem) {
        return Math.max(face, arrayElem);
    }
}

