/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins.ktx;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.renderer.Caps;
import com.jme3.renderer.opengl.GLImageFormat;
import com.jme3.renderer.opengl.GLImageFormats;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.plugins.ktx.PixelReader;
import com.jme3.texture.plugins.ktx.SrTdRiPixelReader;
import com.jme3.texture.plugins.ktx.SrTuRoPixelReader;
import com.jme3.util.BufferUtils;
import com.jme3.util.LittleEndien;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KTXLoader
implements AssetLoader {
    private static final Logger log = Logger.getLogger(KTXLoader.class.getName());
    private static final byte[] fileIdentifier = new byte[]{-85, 75, 84, 88, 32, 49, 49, -69, 13, 10, 26, 10};
    private boolean slicesInside = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info2) throws IOException {
        if (!(info2.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        try (InputStream in = null;){
            Image img;
            in = info2.openStream();
            Image image = img = this.load(in);
            return image;
        }
    }

    private Image load(InputStream stream) {
        byte[] fileId = new byte[12];
        InputStream in = new DataInputStream(stream);
        try {
            stream.read(fileId, 0, 12);
            if (!this.checkFileIdentifier(fileId)) {
                throw new IllegalArgumentException("Unrecognized ktx file identifier : " + new String(fileId) + " should be " + new String(fileIdentifier));
            }
            int endianness = in.readInt();
            if (endianness == 16909060) {
                in = new LittleEndien(stream);
            }
            int glType = in.readInt();
            int glTypeSize = in.readInt();
            int glFormat = in.readInt();
            int glInternalFormat = in.readInt();
            int glBaseInternalFormat = in.readInt();
            int pixelWidth = in.readInt();
            int pixelHeight = in.readInt();
            int pixelDepth = in.readInt();
            int numberOfArrayElements = in.readInt();
            int numberOfFaces = in.readInt();
            int numberOfMipmapLevels = in.readInt();
            int bytesOfKeyValueData = in.readInt();
            log.log(Level.FINE, "glType = {0}", glType);
            log.log(Level.FINE, "glTypeSize = {0}", glTypeSize);
            log.log(Level.FINE, "glFormat = {0}", glFormat);
            log.log(Level.FINE, "glInternalFormat = {0}", glInternalFormat);
            log.log(Level.FINE, "glBaseInternalFormat = {0}", glBaseInternalFormat);
            log.log(Level.FINE, "pixelWidth = {0}", pixelWidth);
            log.log(Level.FINE, "pixelHeight = {0}", pixelHeight);
            log.log(Level.FINE, "pixelDepth = {0}", pixelDepth);
            log.log(Level.FINE, "numberOfArrayElements = {0}", numberOfArrayElements);
            log.log(Level.FINE, "numberOfFaces = {0}", numberOfFaces);
            log.log(Level.FINE, "numberOfMipmapLevels = {0}", numberOfMipmapLevels);
            log.log(Level.FINE, "bytesOfKeyValueData = {0}", bytesOfKeyValueData);
            if (numberOfFaces > 1 && pixelDepth > 1 || numberOfFaces > 1 && numberOfArrayElements > 1 || pixelDepth > 1 && numberOfArrayElements > 1) {
                throw new UnsupportedOperationException("jME doesn't support cube maps of 3D textures or arrays of 3D texture or arrays of cube map of 3d textures");
            }
            PixelReader pixelReader = this.parseMetaData(bytesOfKeyValueData, (DataInput)((Object)in));
            if (pixelReader == null) {
                pixelReader = new SrTuRoPixelReader();
            }
            pixelDepth = Math.max(1, pixelDepth);
            numberOfArrayElements = Math.max(1, numberOfArrayElements);
            numberOfFaces = Math.max(1, numberOfFaces);
            numberOfMipmapLevels = Math.max(1, numberOfMipmapLevels);
            int nbSlices = Math.max(numberOfFaces, numberOfArrayElements);
            Image.Format imgFormat = this.getImageFormat(glFormat, glInternalFormat, glType);
            log.log(Level.FINE, "img format {0}", imgFormat.toString());
            int bytePerPixel = imgFormat.getBitsPerPixel() / 8;
            int byteBuffersSize = this.computeBuffersSize(numberOfMipmapLevels, pixelWidth, pixelHeight, bytePerPixel, pixelDepth);
            log.log(Level.FINE, "data size {0}", byteBuffersSize);
            int[] mipMapSizes = new int[numberOfMipmapLevels];
            Image image = this.createImage(nbSlices, byteBuffersSize, imgFormat, pixelWidth, pixelHeight, pixelDepth);
            byte[] pixelData = new byte[bytePerPixel];
            int offset2 = 0;
            for (int mipLevel = 0; mipLevel < numberOfMipmapLevels; ++mipLevel) {
                int imageSize;
                int fileImageSize = in.readInt();
                int width2 = Math.max(1, pixelWidth >> mipLevel);
                int height2 = Math.max(1, pixelHeight >> mipLevel);
                mipMapSizes[mipLevel] = imageSize = width2 * height2 * bytePerPixel;
                log.log(Level.FINE, "current mip size {0}", imageSize);
                if (fileImageSize != imageSize) {
                    log.log(Level.WARNING, "Mip map size is wrong in the file for mip level {0} size is {1} should be {2}", new Object[]{mipLevel, fileImageSize, imageSize});
                }
                for (int arrayElem = 0; arrayElem < numberOfArrayElements; ++arrayElem) {
                    for (int face = 0; face < numberOfFaces; ++face) {
                        int nbPixelRead = 0;
                        for (int depth = 0; depth < pixelDepth; ++depth) {
                            ByteBuffer byteBuffer = image.getData(KTXLoader.getSlice(face, arrayElem));
                            log.log(Level.FINE, "position {0}", byteBuffer.position());
                            byteBuffer.position(offset2);
                            nbPixelRead = pixelReader.readPixels(width2, height2, pixelData, byteBuffer, (DataInput)((Object)in));
                        }
                        if (numberOfFaces != 6 || numberOfArrayElements != 0) continue;
                        in.skipBytes(3 - (nbPixelRead + 3) % 4);
                    }
                }
                log.log(Level.FINE, "skipping {0}", 3 - (imageSize + 3) % 4);
                in.skipBytes(3 - (imageSize + 3) % 4);
                offset2 += imageSize;
            }
            if (numberOfMipmapLevels > 1) {
                image.setMipMapSizes(mipMapSizes);
            }
            if (pixelDepth > 1 && this.slicesInside) {
                Collections.reverse(image.getData());
            }
            return image;
        }
        catch (IOException ex) {
            Logger.getLogger(KTXLoader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static int getSlice(int face, int arrayElem) {
        return Math.max(face, arrayElem);
    }

    private int computeBuffersSize(int numberOfMipmapLevels, int pixelWidth, int pixelHeight, int bytePerPixel, int pixelDepth) {
        int byteBuffersSize = 0;
        for (int mipLevel = 0; mipLevel < numberOfMipmapLevels; ++mipLevel) {
            int width2 = Math.max(1, pixelWidth >> mipLevel);
            int height2 = Math.max(1, pixelHeight >> mipLevel);
            byteBuffersSize += width2 * height2 * bytePerPixel;
            log.log(Level.FINE, "mip level size : {0} : {1}", new Object[]{mipLevel, width2 * height2 * bytePerPixel});
        }
        return byteBuffersSize * pixelDepth;
    }

    private Image createImage(int nbSlices, int byteBuffersSize, Image.Format imgFormat, int pixelWidth, int pixelHeight, int depth) {
        ArrayList<ByteBuffer> imageData = new ArrayList<ByteBuffer>(nbSlices);
        for (int i = 0; i < nbSlices; ++i) {
            imageData.add(BufferUtils.createByteBuffer(byteBuffersSize));
        }
        Image image = new Image(imgFormat, pixelWidth, pixelHeight, depth, imageData, ColorSpace.sRGB);
        return image;
    }

    private PixelReader parseMetaData(int bytesOfKeyValueData, DataInput in) throws IOException {
        int padding2;
        int keyAndValueByteSize;
        PixelReader pixelReader = null;
        for (int i = 0; i < bytesOfKeyValueData; i += 4 + keyAndValueByteSize + padding2) {
            keyAndValueByteSize = in.readInt();
            byte[] keyValue = new byte[keyAndValueByteSize];
            in.readFully(keyValue);
            String[] kv = new String(keyValue).split("\u0000");
            for (int j = 0; j < kv.length; j += 2) {
                System.err.println("key : " + kv[j]);
                System.err.println("value : " + kv[j + 1]);
                if (!kv[j].equalsIgnoreCase("KTXorientation")) continue;
                pixelReader = kv[j + 1].startsWith("S=r,T=d") ? new SrTdRiPixelReader() : new SrTuRoPixelReader();
                if (!kv[j + 1].contains("R=i")) continue;
                this.slicesInside = true;
            }
            padding2 = 3 - (keyAndValueByteSize + 3) % 4;
            if (padding2 <= 0) continue;
            in.skipBytes(padding2);
        }
        return pixelReader;
    }

    private boolean checkFileIdentifier(byte[] b) {
        boolean check = true;
        for (int i = 0; i < 12; ++i) {
            if (b[i] == fileIdentifier[i]) continue;
            check = false;
        }
        return check;
    }

    private Image.Format getImageFormat(int glFormat, int glInternalFormat, int glType) {
        GLImageFormat[][] formats;
        EnumSet<Caps> caps = EnumSet.allOf(Caps.class);
        for (GLImageFormat[] format2 : formats = GLImageFormats.getFormatsForCaps(caps)) {
            for (int j = 0; j < format2.length; ++j) {
                GLImageFormat glImgFormat = format2[j];
                if (glImgFormat == null || glImgFormat.format != glFormat || glImgFormat.dataType != glType || glFormat != glInternalFormat && glImgFormat.internalFormat != glInternalFormat) continue;
                return Image.Format.values()[j];
            }
        }
        return null;
    }
}

