/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class TGALoader
implements AssetLoader {
    public static final int TYPE_NO_IMAGE = 0;
    public static final int TYPE_COLORMAPPED = 1;
    public static final int TYPE_TRUECOLOR = 2;
    public static final int TYPE_BLACKANDWHITE = 3;
    public static final int TYPE_COLORMAPPED_RLE = 9;
    public static final int TYPE_TRUECOLOR_RLE = 10;
    public static final int TYPE_BLACKANDWHITE_RLE = 11;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info2) throws IOException {
        if (!(info2.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        boolean flip = ((TextureKey)info2.getKey()).isFlipY();
        try (InputStream in = null;){
            Image img;
            in = info2.openStream();
            Image image = img = TGALoader.load(in, flip);
            return image;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Image load(InputStream in, boolean flip) throws IOException {
        int i;
        Image.Format format2;
        byte blue;
        byte green;
        byte red;
        int dl;
        boolean flipH = false;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
        int idLength = dis.readUnsignedByte();
        int colorMapType = dis.readUnsignedByte();
        int imageType = dis.readUnsignedByte();
        dis.readShort();
        int cMapLength = TGALoader.flipEndian(dis.readShort());
        int cMapDepth = dis.readUnsignedByte();
        dis.readShort();
        dis.readShort();
        int width2 = TGALoader.flipEndian(dis.readShort());
        int height2 = TGALoader.flipEndian(dis.readShort());
        int pixelDepth = dis.readUnsignedByte();
        int imageDescriptor = dis.readUnsignedByte();
        if ((imageDescriptor & 0x20) != 0) {
            boolean bl = flip = !flip;
        }
        if ((imageDescriptor & 0x10) != 0) {
            boolean bl = flipH = !flipH;
        }
        if (idLength > 0) {
            dis.skip(idLength);
        }
        ColorMapEntry[] cMapEntries = null;
        if (colorMapType != 0) {
            int bytesInColorMap = cMapDepth * cMapLength >> 3;
            int bitsPerColor = Math.min(cMapDepth / 3, 8);
            byte[] cMapData = new byte[bytesInColorMap];
            dis.read(cMapData);
            if (imageType == 1 || imageType == 9) {
                cMapEntries = new ColorMapEntry[cMapLength];
                int alphaSize = cMapDepth - 3 * bitsPerColor;
                float scalar = 255.0f / (FastMath.pow(2.0f, bitsPerColor) - 1.0f);
                float alphaScalar = 255.0f / (FastMath.pow(2.0f, alphaSize) - 1.0f);
                for (int i2 = 0; i2 < cMapLength; ++i2) {
                    ColorMapEntry entry = new ColorMapEntry();
                    int offset2 = cMapDepth * i2;
                    entry.red = (byte)((float)TGALoader.getBitsAsByte(cMapData, offset2, bitsPerColor) * scalar);
                    entry.green = (byte)((float)TGALoader.getBitsAsByte(cMapData, offset2 + bitsPerColor, bitsPerColor) * scalar);
                    entry.blue = (byte)((float)TGALoader.getBitsAsByte(cMapData, offset2 + 2 * bitsPerColor, bitsPerColor) * scalar);
                    entry.alpha = alphaSize <= 0 ? (byte)-1 : (byte)((float)TGALoader.getBitsAsByte(cMapData, offset2 + 3 * bitsPerColor, alphaSize) * alphaScalar);
                    cMapEntries[i2] = entry;
                }
            }
        }
        byte[] rawData = null;
        if (pixelDepth == 32) {
            rawData = new byte[width2 * height2 * 4];
            dl = 4;
        } else {
            rawData = new byte[width2 * height2 * 3];
            dl = 3;
        }
        int rawDataIndex = 0;
        if (imageType == 2) {
            red = 0;
            green = 0;
            blue = 0;
            int alpha2 = 0;
            if (pixelDepth == 16) {
                byte[] data2 = new byte[2];
                float scalar = 8.225806f;
                for (int i3 = 0; i3 <= height2 - 1; ++i3) {
                    if (!flip) {
                        rawDataIndex = (height2 - 1 - i3) * width2 * dl;
                    }
                    for (int j = 0; j < width2; ++j) {
                        data2[1] = dis.readByte();
                        data2[0] = dis.readByte();
                        rawData[rawDataIndex++] = (byte)((float)TGALoader.getBitsAsByte(data2, 1, 5) * scalar);
                        rawData[rawDataIndex++] = (byte)((float)TGALoader.getBitsAsByte(data2, 6, 5) * scalar);
                        rawData[rawDataIndex++] = (byte)((float)TGALoader.getBitsAsByte(data2, 11, 5) * scalar);
                        if (dl != 4) continue;
                        alpha2 = TGALoader.getBitsAsByte(data2, 0, 1);
                        if (alpha2 == 1) {
                            alpha2 = -1;
                        }
                        rawData[rawDataIndex++] = alpha2;
                    }
                }
                format2 = dl == 4 ? Image.Format.RGBA8 : Image.Format.RGB8;
            } else if (pixelDepth == 24) {
                for (int y2 = 0; y2 < height2; ++y2) {
                    rawDataIndex = !flip ? (height2 - 1 - y2) * width2 * dl : y2 * width2 * dl;
                    dis.readFully(rawData, rawDataIndex, width2 * dl);
                }
                format2 = Image.Format.BGR8;
            } else {
                if (pixelDepth != 32) throw new IOException("Unsupported TGA true color depth: " + pixelDepth);
                for (i = 0; i <= height2 - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height2 - 1 - i) * width2 * dl;
                    }
                    for (int j = 0; j < width2; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha2 = dis.readByte();
                        rawData[rawDataIndex++] = red;
                        rawData[rawDataIndex++] = green;
                        rawData[rawDataIndex++] = blue;
                        rawData[rawDataIndex++] = alpha2;
                    }
                }
                format2 = Image.Format.RGBA8;
            }
        } else if (imageType == 10) {
            red = 0;
            green = 0;
            blue = 0;
            byte alpha3 = 0;
            if (pixelDepth == 32) {
                for (i = 0; i <= height2 - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height2 - 1 - i) * width2 * dl;
                    }
                    for (int j = 0; j < width2; ++j) {
                        int count2 = dis.readByte();
                        if ((count2 & 0x80) != 0) {
                            j += (count2 &= 0x7F);
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            alpha3 = dis.readByte();
                            while (count2-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                                rawData[rawDataIndex++] = alpha3;
                            }
                            continue;
                        }
                        j += count2;
                        while (count2-- >= 0) {
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            alpha3 = dis.readByte();
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                            rawData[rawDataIndex++] = alpha3;
                        }
                    }
                }
                format2 = Image.Format.RGBA8;
            } else if (pixelDepth == 24) {
                for (i = 0; i <= height2 - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height2 - 1 - i) * width2 * dl;
                    }
                    for (int j = 0; j < width2; ++j) {
                        int count3 = dis.readByte();
                        if ((count3 & 0x80) != 0) {
                            j += (count3 &= 0x7F);
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            while (count3-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                            }
                            continue;
                        }
                        j += count3;
                        while (count3-- >= 0) {
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                        }
                    }
                }
                format2 = Image.Format.RGB8;
            } else {
                if (pixelDepth != 16) throw new IOException("Unsupported TGA true color depth: " + pixelDepth);
                byte[] data3 = new byte[2];
                float scalar = 8.225806f;
                for (int i4 = 0; i4 <= height2 - 1; ++i4) {
                    if (!flip) {
                        rawDataIndex = (height2 - 1 - i4) * width2 * dl;
                    }
                    for (int j = 0; j < width2; ++j) {
                        int count4 = dis.readByte();
                        if ((count4 & 0x80) != 0) {
                            j += (count4 &= 0x7F);
                            data3[1] = dis.readByte();
                            data3[0] = dis.readByte();
                            blue = (byte)((float)TGALoader.getBitsAsByte(data3, 1, 5) * scalar);
                            green = (byte)((float)TGALoader.getBitsAsByte(data3, 6, 5) * scalar);
                            red = (byte)((float)TGALoader.getBitsAsByte(data3, 11, 5) * scalar);
                            while (count4-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                            }
                            continue;
                        }
                        j += count4;
                        while (count4-- >= 0) {
                            data3[1] = dis.readByte();
                            data3[0] = dis.readByte();
                            blue = (byte)((float)TGALoader.getBitsAsByte(data3, 1, 5) * scalar);
                            green = (byte)((float)TGALoader.getBitsAsByte(data3, 6, 5) * scalar);
                            red = (byte)((float)TGALoader.getBitsAsByte(data3, 11, 5) * scalar);
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                        }
                    }
                }
                format2 = Image.Format.RGB8;
            }
        } else {
            int j;
            int i5;
            if (imageType != 1) throw new IOException("Monochrome and RLE colormapped images are not supported");
            int bytesPerIndex = pixelDepth / 8;
            if (bytesPerIndex == 1) {
                for (i5 = 0; i5 <= height2 - 1; ++i5) {
                    if (!flip) {
                        rawDataIndex = (height2 - 1 - i5) * width2 * dl;
                    }
                    for (j = 0; j < width2; ++j) {
                        int index2 = dis.readUnsignedByte();
                        if (index2 >= cMapEntries.length || index2 < 0) {
                            throw new IOException("TGA: Invalid color map entry referenced: " + index2);
                        }
                        ColorMapEntry entry = cMapEntries[index2];
                        rawData[rawDataIndex++] = entry.blue;
                        rawData[rawDataIndex++] = entry.green;
                        rawData[rawDataIndex++] = entry.red;
                        if (dl != 4) continue;
                        rawData[rawDataIndex++] = entry.alpha;
                    }
                }
            } else {
                if (bytesPerIndex != 2) throw new IOException("TGA: unknown colormap indexing size used: " + bytesPerIndex);
                for (i5 = 0; i5 <= height2 - 1; ++i5) {
                    if (!flip) {
                        rawDataIndex = (height2 - 1 - i5) * width2 * dl;
                    }
                    for (j = 0; j < width2; ++j) {
                        short index3 = TGALoader.flipEndian(dis.readShort());
                        if (index3 >= cMapEntries.length || index3 < 0) {
                            throw new IOException("TGA: Invalid color map entry referenced: " + index3);
                        }
                        ColorMapEntry entry = cMapEntries[index3];
                        rawData[rawDataIndex++] = entry.blue;
                        rawData[rawDataIndex++] = entry.green;
                        rawData[rawDataIndex++] = entry.red;
                        if (dl != 4) continue;
                        rawData[rawDataIndex++] = entry.alpha;
                    }
                }
            }
            format2 = dl == 4 ? Image.Format.RGBA8 : Image.Format.RGB8;
        }
        in.close();
        ByteBuffer scratch = BufferUtils.createByteBuffer(rawData.length);
        scratch.clear();
        scratch.put(rawData);
        scratch.rewind();
        Image textureImage = new Image();
        textureImage.setFormat(format2);
        textureImage.setWidth(width2);
        textureImage.setHeight(height2);
        textureImage.setData(scratch);
        return textureImage;
    }

    private static byte getBitsAsByte(byte[] data2, int offset2, int length) {
        int offsetBytes = offset2 / 8;
        int indexBits = offset2 % 8;
        int rVal = 0;
        int i = length;
        while (--i >= 0) {
            int test;
            byte b = data2[offsetBytes];
            int n = test = indexBits == 7 ? 1 : 2 << 6 - indexBits;
            if ((b & test) != 0) {
                rVal = i == 0 ? ++rVal : (rVal += 2 << i - 1);
            }
            if (++indexBits != 8) continue;
            indexBits = 0;
            ++offsetBytes;
        }
        return (byte)rVal;
    }

    private static short flipEndian(short signedShort) {
        int input = signedShort & 0xFFFF;
        return (short)(input << 8 | (input & 0xFF00) >>> 8);
    }

    static class ColorMapEntry {
        byte red;
        byte green;
        byte blue;
        byte alpha;

        ColorMapEntry() {
        }

        public String toString() {
            return "entry: " + this.red + "," + this.green + "," + this.blue + "," + this.alpha;
        }
    }
}

