/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;

public class PFMLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(PFMLoader.class.getName());

    private String readString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i;
        while ((i = is.read()) != 10 && i != -1) {
            sb.append((char)i);
        }
        return sb.toString();
    }

    private void flipScanline(byte[] scanline) {
        for (int i = 0; i < scanline.length; i += 4) {
            byte tmp = scanline[i + 3];
            scanline[i + 3] = scanline[i + 0];
            scanline[i + 0] = tmp;
            tmp = scanline[i + 2];
            scanline[i + 2] = scanline[i + 1];
            scanline[i + 1] = tmp;
        }
    }

    private Image load(InputStream in, boolean needYFlip) throws IOException {
        Image.Format format2 = null;
        String fmtStr = this.readString(in);
        if (fmtStr.equals("PF")) {
            format2 = Image.Format.RGB32F;
        } else if (fmtStr.equals("Pf")) {
            format2 = Image.Format.Luminance32F;
        } else {
            throw new IOException("File is not PFM format");
        }
        String sizeStr = this.readString(in);
        int spaceIdx = sizeStr.indexOf(" ");
        if (spaceIdx <= 0 || spaceIdx >= sizeStr.length() - 1) {
            throw new IOException("Invalid size syntax in PFM file");
        }
        int width2 = Integer.parseInt(sizeStr.substring(0, spaceIdx));
        int height2 = Integer.parseInt(sizeStr.substring(spaceIdx + 1));
        if (width2 <= 0 || height2 <= 0) {
            throw new IOException("Invalid size specified in PFM file");
        }
        String scaleStr = this.readString(in);
        float scale2 = Float.parseFloat(scaleStr);
        ByteOrder order = scale2 < 0.0f ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        boolean needEndianFlip = order != ByteOrder.nativeOrder();
        System.gc();
        int bytesPerPixel = format2.getBitsPerPixel() / 8;
        int scanLineBytes = bytesPerPixel * width2;
        ByteBuffer imageData = BufferUtils.createByteBuffer(width2 * height2 * bytesPerPixel);
        byte[] scanline = new byte[width2 * bytesPerPixel];
        for (int y2 = height2 - 1; y2 >= 0; --y2) {
            if (!needYFlip) {
                imageData.position(scanLineBytes * y2);
            }
            int read = 0;
            int off = 0;
            do {
                read = in.read(scanline, off, scanline.length - off);
                off += read;
            } while (read > 0);
            if (needEndianFlip) {
                this.flipScanline(scanline);
            }
            imageData.put(scanline);
        }
        imageData.rewind();
        return new Image(format2, width2, height2, imageData, null, ColorSpace.Linear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info2) throws IOException {
        if (!(info2.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        try (InputStream in = null;){
            in = info2.openStream();
            Image image = this.load(in, ((TextureKey)info2.getKey()).isFlipY());
            return image;
        }
    }
}

