/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HDRLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(HDRLoader.class.getName());
    private boolean writeRGBE = false;
    private ByteBuffer rleTempBuffer;
    private ByteBuffer dataStore;
    private final float[] tempF = new float[3];

    public HDRLoader(boolean writeRGBE) {
        this.writeRGBE = writeRGBE;
    }

    public HDRLoader() {
    }

    public static void convertFloatToRGBE(byte[] rgbe, float red, float green, float blue) {
        double max = red;
        if ((double)green > max) {
            max = green;
        }
        if ((double)blue > max) {
            max = blue;
        }
        if (max < 1.0E-32) {
            rgbe[3] = 0;
            rgbe[2] = 0;
            rgbe[1] = 0;
            rgbe[0] = 0;
        } else {
            double exp = Math.ceil(Math.log10(max) / Math.log10(2.0));
            double divider = Math.pow(2.0, exp);
            rgbe[0] = (byte)((double)red / divider * 255.0);
            rgbe[1] = (byte)((double)green / divider * 255.0);
            rgbe[2] = (byte)((double)blue / divider * 255.0);
            rgbe[3] = (byte)(exp + 128.0);
        }
    }

    public static void convertRGBEtoFloat(byte[] rgbe, float[] rgbf) {
        int R = rgbe[0] & 0xFF;
        int G = rgbe[1] & 0xFF;
        int B = rgbe[2] & 0xFF;
        int E = rgbe[3] & 0xFF;
        float e = (float)Math.pow(2.0, E - 136);
        rgbf[0] = (float)R * e;
        rgbf[1] = (float)G * e;
        rgbf[2] = (float)B * e;
    }

    public static void convertRGBEtoFloat2(byte[] rgbe, float[] rgbf) {
        int R = rgbe[0] & 0xFF;
        int G = rgbe[1] & 0xFF;
        int B = rgbe[2] & 0xFF;
        int E = rgbe[3] & 0xFF;
        float e = (float)Math.pow(2.0, E - 128);
        rgbf[0] = (float)R / 256.0f * e;
        rgbf[1] = (float)G / 256.0f * e;
        rgbf[2] = (float)B / 256.0f * e;
    }

    public static void convertRGBEtoFloat3(byte[] rgbe, float[] rgbf) {
        int R = rgbe[0] & 0xFF;
        int G = rgbe[1] & 0xFF;
        int B = rgbe[2] & 0xFF;
        int E = rgbe[3] & 0xFF;
        float e = (float)Math.pow(2.0, E - 136);
        rgbf[0] = (float)R * e;
        rgbf[1] = (float)G * e;
        rgbf[2] = (float)B * e;
    }

    private void writeRGBE(byte[] rgbe) {
        if (this.writeRGBE) {
            this.dataStore.put(rgbe);
        } else {
            HDRLoader.convertRGBEtoFloat(rgbe, this.tempF);
            this.dataStore.putShort(FastMath.convertFloatToHalf(this.tempF[0])).putShort(FastMath.convertFloatToHalf(this.tempF[1])).putShort(FastMath.convertFloatToHalf(this.tempF[2]));
        }
    }

    private String readString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        int i;
        while ((i = is.read()) != 10 && i != -1) {
            sb.append((char)i);
        }
        return sb.toString();
    }

    private boolean decodeScanlineRLE(InputStream in, int width2) throws IOException {
        if (this.rleTempBuffer == null) {
            this.rleTempBuffer = BufferUtils.createByteBuffer(width2 * 4);
        } else {
            this.rleTempBuffer.clear();
            if (this.rleTempBuffer.remaining() < width2 * 4) {
                this.rleTempBuffer = BufferUtils.createByteBuffer(width2 * 4);
            }
        }
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < width2) {
                int val;
                int code = in.read();
                if (code > 128) {
                    code -= 128;
                    val = in.read();
                    while (code-- != 0) {
                        this.rleTempBuffer.put(j++ * 4 + i, (byte)val);
                    }
                    continue;
                }
                while (code-- != 0) {
                    val = in.read();
                    this.rleTempBuffer.put(j++ * 4 + i, (byte)val);
                }
            }
        }
        this.rleTempBuffer.rewind();
        byte[] rgbe = new byte[4];
        for (int i = 0; i < width2; ++i) {
            this.rleTempBuffer.get(rgbe);
            this.writeRGBE(rgbe);
        }
        return true;
    }

    private boolean decodeScanlineUncompressed(InputStream in, int width2) throws IOException {
        byte[] rgbe = new byte[4];
        for (int i = 0; i < width2; i += 3) {
            if (in.read(rgbe) < 1) {
                return false;
            }
            this.writeRGBE(rgbe);
        }
        return true;
    }

    private void decodeScanline(InputStream in, int width2) throws IOException {
        if (width2 < 8 || width2 > Short.MAX_VALUE) {
            this.decodeScanlineUncompressed(in, width2);
        }
        byte[] data2 = new byte[4];
        in.read(data2);
        if (data2[0] != 2 || data2[1] != 2 || (data2[2] & 0x80) != 0) {
            this.decodeScanlineUncompressed(in, width2 - 1);
        } else {
            int readWidth = (data2[2] & 0xFF) << 8 | data2[3] & 0xFF;
            if (readWidth != width2) {
                throw new IOException("Illegal scanline width in HDR file: " + width2 + " != " + readWidth);
            }
            this.decodeScanlineRLE(in, width2);
        }
    }

    public Image load(InputStream in, boolean flipY) throws IOException {
        String[] resData;
        float gamma = -1.0f;
        float exposure = -1.0f;
        int width2 = -1;
        int height2 = -1;
        boolean verifiedFormat = false;
        while (true) {
            String ln = this.readString(in);
            if ((ln = ln.trim()).startsWith("#") || ln.equals("")) {
                if (!ln.equals("#?RADIANCE") && !ln.equals("#?RGBE")) continue;
                verifiedFormat = true;
                continue;
            }
            if (ln.startsWith("+") || ln.startsWith("-")) {
                resData = ln.split("\\s");
                if (resData.length != 4) {
                    throw new IOException("Invalid resolution string in HDR file");
                }
                if (!resData[0].equals("-Y") || !resData[2].equals("+X")) {
                    logger.warning("Flipping/Rotating attributes ignored!");
                }
                break;
            }
            int index2 = ln.indexOf("=");
            if (index2 < 1) {
                logger.log(Level.FINE, "Ignored string: {0}", ln);
                continue;
            }
            String var = ln.substring(0, index2).trim().toLowerCase();
            String value = ln.substring(index2 + 1).trim().toLowerCase();
            if (var.equals("format")) {
                if (value.equals("32-bit_rle_rgbe") || value.equals("32-bit_rle_xyze")) continue;
                throw new IOException("Unsupported format in HDR picture");
            }
            if (var.equals("exposure")) {
                exposure = Float.parseFloat(value);
                continue;
            }
            if (var.equals("gamma")) {
                gamma = Float.parseFloat(value);
                continue;
            }
            logger.log(Level.WARNING, "HDR Command ignored: {0}", ln);
        }
        width2 = Integer.parseInt(resData[3]);
        height2 = Integer.parseInt(resData[1]);
        assert (width2 != -1 && height2 != -1);
        if (!verifiedFormat) {
            logger.warning("Unsure if specified image is Radiance HDR");
        }
        System.gc();
        Image.Format pixelFormat = this.writeRGBE ? Image.Format.RGBA8 : Image.Format.RGB16F;
        this.dataStore = BufferUtils.createByteBuffer(width2 * height2 * pixelFormat.getBitsPerPixel());
        int bytesPerPixel = pixelFormat.getBitsPerPixel() / 8;
        int scanLineBytes = bytesPerPixel * width2;
        for (int y2 = height2 - 1; y2 >= 0; --y2) {
            if (flipY) {
                this.dataStore.position(scanLineBytes * y2);
            }
            this.decodeScanline(in, width2);
        }
        in.close();
        this.dataStore.rewind();
        return new Image(pixelFormat, width2, height2, this.dataStore, ColorSpace.Linear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(AssetInfo info2) throws IOException {
        if (!(info2.getKey() instanceof TextureKey)) {
            throw new IllegalArgumentException("Texture assets must be loaded using a TextureKey");
        }
        boolean flip = ((TextureKey)info2.getKey()).isFlipY();
        try (InputStream in = null;){
            Image img;
            in = info2.openStream();
            Image image = img = this.load(in, flip);
            return image;
        }
    }
}

