/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DXTFlipper {
    private static final ByteBuffer bb = ByteBuffer.allocate(8);

    private DXTFlipper() {
    }

    private static long readCode5(long data2, int x2, int y2) {
        long shift = (4 * y2 + x2) * 3;
        long mask = 7L;
        long code = data2 & (mask <<= (int)shift);
        return code >>= (int)shift;
    }

    private static long writeCode5(long data2, int x2, int y2, long code) {
        long shift = (4 * y2 + x2) * 3;
        long mask = 7L;
        code = (code & mask) << (int)shift;
        mask <<= (int)shift;
        data2 &= (mask ^= 0xFFFFFFFFFFFFFFFFL);
        return data2 |= code;
    }

    private static void flipDXT5Block(byte[] block2, int h) {
        long l;
        if (h == 1) {
            return;
        }
        byte c0 = block2[0];
        byte c1 = block2[1];
        bb.clear();
        bb.put(block2, 2, 6).flip();
        bb.clear();
        long n = l = bb.getLong();
        if (h == 2) {
            n = DXTFlipper.writeCode5(n, 0, 0, DXTFlipper.readCode5(l, 0, 1));
            n = DXTFlipper.writeCode5(n, 1, 0, DXTFlipper.readCode5(l, 1, 1));
            n = DXTFlipper.writeCode5(n, 2, 0, DXTFlipper.readCode5(l, 2, 1));
            n = DXTFlipper.writeCode5(n, 3, 0, DXTFlipper.readCode5(l, 3, 1));
            n = DXTFlipper.writeCode5(n, 0, 1, DXTFlipper.readCode5(l, 0, 0));
            n = DXTFlipper.writeCode5(n, 1, 1, DXTFlipper.readCode5(l, 1, 0));
            n = DXTFlipper.writeCode5(n, 2, 1, DXTFlipper.readCode5(l, 2, 0));
            n = DXTFlipper.writeCode5(n, 3, 1, DXTFlipper.readCode5(l, 3, 0));
        } else {
            n = DXTFlipper.writeCode5(n, 0, 0, DXTFlipper.readCode5(l, 0, 3));
            n = DXTFlipper.writeCode5(n, 1, 0, DXTFlipper.readCode5(l, 1, 3));
            n = DXTFlipper.writeCode5(n, 2, 0, DXTFlipper.readCode5(l, 2, 3));
            n = DXTFlipper.writeCode5(n, 3, 0, DXTFlipper.readCode5(l, 3, 3));
            n = DXTFlipper.writeCode5(n, 0, 1, DXTFlipper.readCode5(l, 0, 2));
            n = DXTFlipper.writeCode5(n, 1, 1, DXTFlipper.readCode5(l, 1, 2));
            n = DXTFlipper.writeCode5(n, 2, 1, DXTFlipper.readCode5(l, 2, 2));
            n = DXTFlipper.writeCode5(n, 3, 1, DXTFlipper.readCode5(l, 3, 2));
            n = DXTFlipper.writeCode5(n, 0, 2, DXTFlipper.readCode5(l, 0, 1));
            n = DXTFlipper.writeCode5(n, 1, 2, DXTFlipper.readCode5(l, 1, 1));
            n = DXTFlipper.writeCode5(n, 2, 2, DXTFlipper.readCode5(l, 2, 1));
            n = DXTFlipper.writeCode5(n, 3, 2, DXTFlipper.readCode5(l, 3, 1));
            n = DXTFlipper.writeCode5(n, 0, 3, DXTFlipper.readCode5(l, 0, 0));
            n = DXTFlipper.writeCode5(n, 1, 3, DXTFlipper.readCode5(l, 1, 0));
            n = DXTFlipper.writeCode5(n, 2, 3, DXTFlipper.readCode5(l, 2, 0));
            n = DXTFlipper.writeCode5(n, 3, 3, DXTFlipper.readCode5(l, 3, 0));
        }
        bb.clear();
        bb.putLong(n);
        bb.clear();
        bb.get(block2, 2, 6).flip();
        assert (c0 == block2[0] && c1 == block2[1]);
    }

    private static void flipDXT3Block(byte[] block2, int h) {
        if (h == 1) {
            return;
        }
        byte tmp0 = block2[0];
        byte tmp1 = block2[1];
        if (h == 2) {
            block2[0] = block2[2];
            block2[1] = block2[3];
            block2[2] = tmp0;
            block2[3] = tmp1;
        } else {
            block2[0] = block2[6];
            block2[1] = block2[7];
            block2[6] = tmp0;
            block2[7] = tmp1;
            tmp0 = block2[2];
            tmp1 = block2[3];
            block2[2] = block2[4];
            block2[3] = block2[5];
            block2[4] = tmp0;
            block2[5] = tmp1;
        }
    }

    private static void flipDXT1orDXTA3Block(byte[] block2, int h) {
        switch (h) {
            case 1: {
                return;
            }
            case 2: {
                byte tmp = block2[5];
                block2[5] = block2[4];
                block2[4] = tmp;
                return;
            }
        }
        byte tmp = block2[7];
        block2[7] = block2[4];
        block2[4] = tmp;
        tmp = block2[6];
        block2[6] = block2[5];
        block2[5] = tmp;
    }

    public static ByteBuffer flipDXT(ByteBuffer img, int w, int h, Image.Format format2) {
        int type2;
        int originalLimit = img.limit();
        int blocksX = (int)FastMath.ceil((float)w / 4.0f);
        int blocksY = (int)FastMath.ceil((float)h / 4.0f);
        switch (format2) {
            case DXT1: 
            case DXT1A: {
                type2 = 1;
                break;
            }
            case DXT3: {
                type2 = 2;
                break;
            }
            case DXT5: {
                type2 = 3;
                break;
            }
            case RGTC2: 
            case SIGNED_RGTC2: {
                type2 = 4;
                break;
            }
            case RGTC1: 
            case SIGNED_RGTC1: {
                type2 = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException("No flip support for texture format " + (Object)((Object)format2));
            }
        }
        int bpb = type2 == 1 || type2 == 5 ? 8 : 16;
        ByteBuffer retImg = BufferUtils.createByteBuffer(blocksX * blocksY * bpb);
        if (h == 1) {
            retImg.put(img);
            retImg.rewind();
        } else if (h == 2) {
            byte[] colorBlock = new byte[8];
            byte[] alphaBlock = type2 != 1 && type2 != 5 ? new byte[8] : null;
            for (int x2 = 0; x2 < blocksX; ++x2) {
                int blockByteOffset = x2 * bpb;
                img.position(blockByteOffset);
                img.limit(blockByteOffset + bpb);
                if (alphaBlock != null) {
                    img.get(alphaBlock);
                    switch (type2) {
                        case 2: {
                            DXTFlipper.flipDXT3Block(alphaBlock, h);
                            break;
                        }
                        case 3: 
                        case 4: {
                            DXTFlipper.flipDXT5Block(alphaBlock, h);
                        }
                    }
                    retImg.put(alphaBlock);
                }
                img.get(colorBlock);
                if (type2 == 4 || type2 == 5) {
                    DXTFlipper.flipDXT5Block(colorBlock, h);
                } else {
                    DXTFlipper.flipDXT1orDXTA3Block(colorBlock, h);
                }
                retImg.put(colorBlock);
            }
            retImg.rewind();
        } else if (h >= 4) {
            byte[] colorBlock = new byte[8];
            byte[] alphaBlock = type2 != 1 && type2 != 5 ? new byte[8] : null;
            for (int y2 = 0; y2 < blocksY; ++y2) {
                for (int x3 = 0; x3 < blocksX; ++x3) {
                    int blockIdx = y2 * blocksX + x3;
                    int blockByteOffset = blockIdx * bpb;
                    img.position(blockByteOffset);
                    img.limit(blockByteOffset + bpb);
                    blockIdx = (blocksY - y2 - 1) * blocksX + x3;
                    blockByteOffset = blockIdx * bpb;
                    retImg.position(blockByteOffset);
                    retImg.limit(blockByteOffset + bpb);
                    if (alphaBlock != null) {
                        img.get(alphaBlock);
                        switch (type2) {
                            case 2: {
                                DXTFlipper.flipDXT3Block(alphaBlock, h);
                                break;
                            }
                            case 3: 
                            case 4: {
                                DXTFlipper.flipDXT5Block(alphaBlock, h);
                            }
                        }
                        retImg.put(alphaBlock);
                    }
                    img.get(colorBlock);
                    if (type2 == 4 || type2 == 5) {
                        DXTFlipper.flipDXT5Block(colorBlock, h);
                    } else {
                        DXTFlipper.flipDXT1orDXTA3Block(colorBlock, h);
                    }
                    retImg.put(colorBlock);
                }
            }
            retImg.limit(retImg.capacity());
            retImg.position(0);
        } else {
            return null;
        }
        img.limit(originalLimit);
        return retImg;
    }

    static {
        bb.order(ByteOrder.LITTLE_ENDIAN);
    }
}

