/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.TextureKey;
import com.jme3.texture.Image;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class AWTLoader
implements AssetLoader {
    public static final ColorModel AWT_RGBA4444 = new DirectColorModel(16, 61440, 3840, 240, 15);
    public static final ColorModel AWT_RGBA5551 = new ComponentColorModel(java.awt.color.ColorSpace.getInstance(1000), new int[]{5, 5, 5, 1}, true, false, 2, 0);

    private Object extractImageData(BufferedImage img) {
        DataBuffer buf = img.getRaster().getDataBuffer();
        switch (buf.getDataType()) {
            case 0: {
                DataBufferByte byteBuf = (DataBufferByte)buf;
                return byteBuf.getData();
            }
            case 1: {
                DataBufferUShort shortBuf = (DataBufferUShort)buf;
                return shortBuf.getData();
            }
        }
        return null;
    }

    private void flipImage(byte[] img, int width2, int height2, int bpp) {
        int scSz = width2 * bpp / 8;
        byte[] sln = new byte[scSz];
        int y2 = 0;
        for (int y1 = 0; y1 < height2 / 2; ++y1) {
            y2 = height2 - y1 - 1;
            System.arraycopy(img, y1 * scSz, sln, 0, scSz);
            System.arraycopy(img, y2 * scSz, img, y1 * scSz, scSz);
            System.arraycopy(sln, 0, img, y2 * scSz, scSz);
        }
    }

    private void flipImage(short[] img, int width2, int height2, int bpp) {
        int scSz = width2 * bpp / 8;
        short[] sln = new short[scSz /= 2];
        int y2 = 0;
        for (int y1 = 0; y1 < height2 / 2; ++y1) {
            y2 = height2 - y1 - 1;
            System.arraycopy(img, y1 * scSz, sln, 0, scSz);
            System.arraycopy(img, y2 * scSz, img, y1 * scSz, scSz);
            System.arraycopy(sln, 0, img, y2 * scSz, scSz);
        }
    }

    public Image load(BufferedImage img, boolean flipY) {
        int width2 = img.getWidth();
        int height2 = img.getHeight();
        switch (img.getType()) {
            case 6: {
                byte[] dataBuf1 = (byte[])this.extractImageData(img);
                if (flipY) {
                    this.flipImage(dataBuf1, width2, height2, 32);
                }
                ByteBuffer data1 = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight() * 4);
                data1.put(dataBuf1);
                return new Image(Image.Format.ABGR8, width2, height2, data1, null, ColorSpace.sRGB);
            }
            case 5: {
                byte[] dataBuf2 = (byte[])this.extractImageData(img);
                if (flipY) {
                    this.flipImage(dataBuf2, width2, height2, 24);
                }
                ByteBuffer data2 = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight() * 3);
                data2.put(dataBuf2);
                return new Image(Image.Format.BGR8, width2, height2, data2, null, ColorSpace.sRGB);
            }
            case 10: {
                byte[] dataBuf3 = (byte[])this.extractImageData(img);
                if (flipY) {
                    this.flipImage(dataBuf3, width2, height2, 8);
                }
                ByteBuffer data3 = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight());
                data3.put(dataBuf3);
                return new Image(Image.Format.Luminance8, width2, height2, data3, null, ColorSpace.sRGB);
            }
        }
        if (img.getTransparency() == 1) {
            ByteBuffer data2 = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight() * 3);
            for (int y2 = 0; y2 < height2; ++y2) {
                for (int x2 = 0; x2 < width2; ++x2) {
                    int ny = y2;
                    if (flipY) {
                        ny = height2 - y2 - 1;
                    }
                    int rgb = img.getRGB(x2, ny);
                    byte r = (byte)((rgb & 0xFF0000) >> 16);
                    byte g = (byte)((rgb & 0xFF00) >> 8);
                    byte b = (byte)(rgb & 0xFF);
                    data2.put(r).put(g).put(b);
                }
            }
            data2.flip();
            return new Image(Image.Format.RGB8, width2, height2, data2, null, ColorSpace.sRGB);
        }
        ByteBuffer data3 = BufferUtils.createByteBuffer(img.getWidth() * img.getHeight() * 4);
        for (int y3 = 0; y3 < height2; ++y3) {
            for (int x3 = 0; x3 < width2; ++x3) {
                int ny = y3;
                if (flipY) {
                    ny = height2 - y3 - 1;
                }
                int rgb = img.getRGB(x3, ny);
                byte a = (byte)((rgb & 0xFF000000) >> 24);
                byte r = (byte)((rgb & 0xFF0000) >> 16);
                byte g = (byte)((rgb & 0xFF00) >> 8);
                byte b = (byte)(rgb & 0xFF);
                data3.put(r).put(g).put(b).put(a);
            }
        }
        data3.flip();
        return new Image(Image.Format.RGBA8, width2, height2, data3, null, ColorSpace.sRGB);
    }

    public Image load(InputStream in, boolean flipY) throws IOException {
        ImageIO.setUseCache(false);
        BufferedImage img = ImageIO.read(in);
        if (img == null) {
            return null;
        }
        return this.load(img, flipY);
    }

    @Override
    public Object load(AssetInfo info2) throws IOException {
        if (ImageIO.getImageReadersBySuffix(info2.getKey().getExtension()) != null) {
            boolean flip = ((TextureKey)info2.getKey()).isFlipY();
            try (InputStream in = info2.openStream();){
                Image image;
                try (BufferedInputStream bin = new BufferedInputStream(in);){
                    Image img = this.load(bin, flip);
                    if (img == null) {
                        throw new AssetLoadException("The given image cannot be loaded " + info2.getKey());
                    }
                    image = img;
                }
                return image;
            }
        }
        throw new AssetLoadException("The extension " + info2.getKey().getExtension() + " is not supported");
    }
}

