/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.image;

import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.texture.Image;
import com.jme3.texture.image.ByteAlignedImageCodec;
import com.jme3.texture.image.ByteOffsetImageCodec;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.image.ImageCodec;
import com.jme3.texture.image.ImageRaster;
import java.nio.ByteBuffer;

public class DefaultImageRaster
extends ImageRaster {
    private final int[] components = new int[4];
    private ByteBuffer buffer;
    private final Image image;
    private final ImageCodec codec;
    private final int width;
    private final int height;
    private final int offset;
    private final byte[] temp;
    private final boolean convertToLinear;
    private int slice;

    private void rangeCheck(int x2, int y2) {
        if (x2 < 0 || y2 < 0 || x2 >= this.width || y2 >= this.height) {
            throw new IllegalArgumentException("x and y must be inside the image dimensions:" + x2 + ", " + y2 + " in:" + this.width + ", " + this.height);
        }
    }

    public DefaultImageRaster(Image image, int slice, int mipMapLevel, boolean convertToLinear) {
        int availableMips;
        int[] mipMapSizes = image.getMipMapSizes();
        int n = availableMips = mipMapSizes != null ? mipMapSizes.length : 1;
        if (mipMapLevel >= availableMips) {
            throw new IllegalStateException("Cannot create image raster for mipmap level #" + mipMapLevel + ". Image only has " + availableMips + " mipmap levels.");
        }
        if (image.hasMipmaps()) {
            this.width = Math.max(1, image.getWidth() >> mipMapLevel);
            this.height = Math.max(1, image.getHeight() >> mipMapLevel);
            int mipOffset = 0;
            for (int i = 0; i < mipMapLevel; ++i) {
                mipOffset += mipMapSizes[i];
            }
            this.offset = mipOffset;
        } else {
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.offset = 0;
        }
        this.image = image;
        this.slice = slice;
        this.convertToLinear = convertToLinear && image.getColorSpace() == ColorSpace.sRGB;
        this.buffer = image.getData(slice);
        this.codec = ImageCodec.lookup(image.getFormat());
        this.temp = (byte[])(this.codec instanceof ByteAlignedImageCodec || this.codec instanceof ByteOffsetImageCodec ? new byte[this.codec.bpp] : null);
    }

    public void setSlice(int slice) {
        this.slice = slice;
        this.buffer = this.image.getData(slice);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setPixel(int x2, int y2, ColorRGBA color2) {
        this.rangeCheck(x2, y2);
        if (this.convertToLinear) {
            color2 = color2.getAsSrgb();
        }
        if (this.codec.isGray) {
            float gray = color2.r * 0.27f + color2.g * 0.67f + color2.b * 0.06f;
            color2 = new ColorRGBA(gray, gray, gray, color2.a);
        }
        switch (this.codec.type) {
            case 1: {
                this.components[0] = FastMath.convertFloatToHalf(color2.a);
                this.components[1] = FastMath.convertFloatToHalf(color2.r);
                this.components[2] = FastMath.convertFloatToHalf(color2.g);
                this.components[3] = FastMath.convertFloatToHalf(color2.b);
                break;
            }
            case 2: {
                this.components[0] = Float.floatToIntBits(color2.a);
                this.components[1] = Float.floatToIntBits(color2.r);
                this.components[2] = Float.floatToIntBits(color2.g);
                this.components[3] = Float.floatToIntBits(color2.b);
                break;
            }
            case 0: {
                this.components[0] = Math.min((int)(color2.a * (float)this.codec.maxAlpha + 0.5f), this.codec.maxAlpha);
                this.components[1] = Math.min((int)(color2.r * (float)this.codec.maxRed + 0.5f), this.codec.maxRed);
                this.components[2] = Math.min((int)(color2.g * (float)this.codec.maxGreen + 0.5f), this.codec.maxGreen);
                this.components[3] = Math.min((int)(color2.b * (float)this.codec.maxBlue + 0.5f), this.codec.maxBlue);
            }
        }
        this.codec.writeComponents(this.getBuffer(), x2, y2, this.width, this.offset, this.components, this.temp);
        this.image.setUpdateNeeded();
    }

    private ByteBuffer getBuffer() {
        if (this.buffer == null) {
            if (this.image.getDepth() > 1) {
                int skip = this.image.getWidth() * this.image.getHeight() * this.codec.bpp * this.slice;
                this.buffer = this.image.getData(0);
                this.buffer.position(skip);
                this.buffer = this.buffer.slice();
            } else {
                this.buffer = this.image.getData(this.slice);
            }
        }
        return this.buffer;
    }

    @Override
    public ColorRGBA getPixel(int x2, int y2, ColorRGBA store) {
        this.rangeCheck(x2, y2);
        this.codec.readComponents(this.getBuffer(), x2, y2, this.width, this.offset, this.components, this.temp);
        if (store == null) {
            store = new ColorRGBA();
        }
        switch (this.codec.type) {
            case 1: {
                store.set(FastMath.convertHalfToFloat((short)this.components[1]), FastMath.convertHalfToFloat((short)this.components[2]), FastMath.convertHalfToFloat((short)this.components[3]), FastMath.convertHalfToFloat((short)this.components[0]));
                break;
            }
            case 2: {
                store.set(Float.intBitsToFloat(this.components[1]), Float.intBitsToFloat(this.components[2]), Float.intBitsToFloat(this.components[3]), Float.intBitsToFloat(this.components[0]));
                break;
            }
            case 0: {
                store.set((float)this.components[1] / (float)this.codec.maxRed, (float)this.components[2] / (float)this.codec.maxGreen, (float)this.components[3] / (float)this.codec.maxBlue, (float)this.components[0] / (float)this.codec.maxAlpha);
            }
        }
        if (this.codec.isGray) {
            store.g = store.b = store.r;
        } else {
            if (this.codec.maxRed == 0) {
                store.r = 1.0f;
            }
            if (this.codec.maxGreen == 0) {
                store.g = 1.0f;
            }
            if (this.codec.maxBlue == 0) {
                store.b = 1.0f;
            }
            if (this.codec.maxAlpha == 0) {
                store.a = 1.0f;
            }
        }
        if (this.convertToLinear) {
            store.setAsSrgb(store.r, store.g, store.b, store.a);
        }
        return store;
    }
}

