/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureCubeMap
extends Texture {
    private Texture.WrapMode wrapS = Texture.WrapMode.EdgeClamp;
    private Texture.WrapMode wrapT = Texture.WrapMode.EdgeClamp;
    private Texture.WrapMode wrapR = Texture.WrapMode.EdgeClamp;

    public TextureCubeMap() {
    }

    public TextureCubeMap(Image img) {
        this.setImage(img);
    }

    public TextureCubeMap(int width2, int height2, Image.Format format2) {
        this(TextureCubeMap.createEmptyLayeredImage(width2, height2, 6, format2));
    }

    private static Image createEmptyLayeredImage(int width2, int height2, int layerCount, Image.Format format2) {
        ArrayList<ByteBuffer> layers = new ArrayList<ByteBuffer>();
        for (int i = 0; i < layerCount; ++i) {
            layers.add(null);
        }
        Image image = new Image(format2, width2, height2, 0, layers, ColorSpace.Linear);
        return image;
    }

    @Override
    public Texture createSimpleClone() {
        return this.createSimpleClone(new TextureCubeMap());
    }

    @Override
    public Texture createSimpleClone(Texture rVal) {
        rVal.setWrap(Texture.WrapAxis.S, this.wrapS);
        rVal.setWrap(Texture.WrapAxis.T, this.wrapT);
        rVal.setWrap(Texture.WrapAxis.R, this.wrapR);
        return super.createSimpleClone(rVal);
    }

    @Override
    public void setWrap(Texture.WrapAxis axis, Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        if (axis == null) {
            throw new IllegalArgumentException("axis can not be null.");
        }
        switch (axis) {
            case S: {
                this.wrapS = mode;
                break;
            }
            case T: {
                this.wrapT = mode;
                break;
            }
            case R: {
                this.wrapR = mode;
            }
        }
    }

    @Override
    public void setWrap(Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        this.wrapS = mode;
        this.wrapT = mode;
        this.wrapR = mode;
    }

    @Override
    public Texture.WrapMode getWrap(Texture.WrapAxis axis) {
        switch (axis) {
            case S: {
                return this.wrapS;
            }
            case T: {
                return this.wrapT;
            }
            case R: {
                return this.wrapR;
            }
        }
        throw new IllegalArgumentException("invalid WrapAxis: " + (Object)((Object)axis));
    }

    @Override
    public Texture.Type getType() {
        return Texture.Type.CubeMap;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TextureCubeMap)) {
            return false;
        }
        TextureCubeMap that = (TextureCubeMap)other;
        if (this.getWrap(Texture.WrapAxis.S) != that.getWrap(Texture.WrapAxis.S)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.T) != that.getWrap(Texture.WrapAxis.T)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.R) != that.getWrap(Texture.WrapAxis.R)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 53 * hash + (this.wrapS != null ? this.wrapS.hashCode() : 0);
        hash = 53 * hash + (this.wrapT != null ? this.wrapT.hashCode() : 0);
        hash = 53 * hash + (this.wrapR != null ? this.wrapR.hashCode() : 0);
        return hash;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.wrapS, "wrapS", Texture.WrapMode.EdgeClamp);
        capsule.write(this.wrapT, "wrapT", Texture.WrapMode.EdgeClamp);
        capsule.write(this.wrapR, "wrapR", Texture.WrapMode.EdgeClamp);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.wrapS = capsule.readEnum("wrapS", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
        this.wrapT = capsule.readEnum("wrapT", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
        this.wrapR = capsule.readEnum("wrapR", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
    }

    public static enum Face {
        PositiveX,
        NegativeX,
        PositiveY,
        NegativeY,
        PositiveZ,
        NegativeZ;

    }
}

