/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import java.io.IOException;

public class Texture2D
extends Texture {
    private Texture.WrapMode wrapS = Texture.WrapMode.EdgeClamp;
    private Texture.WrapMode wrapT = Texture.WrapMode.EdgeClamp;

    public Texture2D() {
    }

    public Texture2D(Image img) {
        this.setImage(img);
        if (img.getData(0) == null) {
            this.setMagFilter(Texture.MagFilter.Nearest);
            this.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        }
    }

    public Texture2D(int width2, int height2, Image.Format format2) {
        this(new Image(format2, width2, height2, null, ColorSpace.Linear));
    }

    public Texture2D(int width2, int height2, int numSamples, Image.Format format2) {
        this(new Image(format2, width2, height2, null, ColorSpace.Linear));
        this.getImage().setMultiSamples(numSamples);
    }

    @Override
    public Texture createSimpleClone() {
        Texture2D clone2 = new Texture2D();
        this.createSimpleClone(clone2);
        return clone2;
    }

    @Override
    public Texture createSimpleClone(Texture rVal) {
        rVal.setWrap(Texture.WrapAxis.S, this.wrapS);
        rVal.setWrap(Texture.WrapAxis.T, this.wrapT);
        return super.createSimpleClone(rVal);
    }

    @Override
    public void setWrap(Texture.WrapAxis axis, Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        if (axis == null) {
            throw new IllegalArgumentException("axis can not be null.");
        }
        switch (axis) {
            case S: {
                this.wrapS = mode;
                break;
            }
            case T: {
                this.wrapT = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not applicable for 2D textures");
            }
        }
    }

    @Override
    public void setWrap(Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        this.wrapS = mode;
        this.wrapT = mode;
    }

    @Override
    public Texture.WrapMode getWrap(Texture.WrapAxis axis) {
        switch (axis) {
            case S: {
                return this.wrapS;
            }
            case T: {
                return this.wrapT;
            }
        }
        throw new IllegalArgumentException("invalid WrapAxis: " + (Object)((Object)axis));
    }

    @Override
    public Texture.Type getType() {
        return Texture.Type.TwoDimensional;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Texture2D)) {
            return false;
        }
        Texture2D that = (Texture2D)other;
        if (this.getWrap(Texture.WrapAxis.S) != that.getWrap(Texture.WrapAxis.S)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.T) != that.getWrap(Texture.WrapAxis.T)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 79 * hash + (this.wrapS != null ? this.wrapS.hashCode() : 0);
        hash = 79 * hash + (this.wrapT != null ? this.wrapT.hashCode() : 0);
        return hash;
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.wrapS, "wrapS", Texture.WrapMode.EdgeClamp);
        capsule.write(this.wrapT, "wrapT", Texture.WrapMode.EdgeClamp);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.wrapS = capsule.readEnum("wrapS", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
        this.wrapT = capsule.readEnum("wrapT", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
    }
}

