/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.lwjgl.GlfwJoystickInput;
import com.jme3.input.lwjgl.GlfwKeyInput;
import com.jme3.input.lwjgl.GlfwMouseInput;
import com.jme3.math.Vector2f;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.NanoTimer;
import com.jme3.system.lwjgl.LwjglContext;
import com.jme3.system.lwjgl.Sync;
import com.jme3.system.lwjgl.WindowSizeListener;
import com.jme3.util.BufferUtils;
import com.jme3.util.SafeArrayList;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.system.Platform;

public abstract class LwjglWindow
extends LwjglContext
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LwjglWindow.class.getName());
    private static final EnumSet<JmeContext.Type> SUPPORTED_TYPES = EnumSet.of(JmeContext.Type.Display, JmeContext.Type.Canvas, JmeContext.Type.OffscreenSurface);
    private static final Map<String, Runnable> RENDER_CONFIGS = new HashMap<String, Runnable>();
    protected final AtomicBoolean needClose = new AtomicBoolean(false);
    protected final AtomicBoolean needRestart = new AtomicBoolean(false);
    private final JmeContext.Type type;
    private final SafeArrayList<WindowSizeListener> windowSizeListeners = new SafeArrayList<WindowSizeListener>(WindowSizeListener.class);
    private GLFWErrorCallback errorCallback;
    private GLFWWindowSizeCallback windowSizeCallback;
    private GLFWFramebufferSizeCallback framebufferSizeCallback;
    private GLFWWindowFocusCallback windowFocusCallback;
    private Thread mainThread;
    private long window = 0L;
    private int frameRateLimit = -1;
    protected boolean wasActive = false;
    protected boolean autoFlush = true;
    protected boolean allowSwapBuffers = false;
    private int[] width = new int[1];
    private int[] height = new int[1];
    private int oldFramebufferWidth;
    private int oldFramebufferHeight;
    private final Vector2f oldScale = new Vector2f(1.0f, 1.0f);

    public LwjglWindow(JmeContext.Type type2) {
        if (!SUPPORTED_TYPES.contains((Object)type2)) {
            throw new IllegalArgumentException("Unsupported type '" + type2.name() + "' provided");
        }
        this.type = type2;
    }

    public void registerWindowSizeListener(WindowSizeListener listener) {
        this.windowSizeListeners.add(listener);
    }

    public void removeWindowSizeListener(WindowSizeListener listener) {
        this.windowSizeListeners.remove(listener);
    }

    @Override
    public JmeContext.Type getType() {
        return this.type;
    }

    @Override
    public void setTitle(String title) {
        if (this.created.get() && this.window != 0L) {
            GLFW.glfwSetWindowTitle(this.window, title);
        }
    }

    @Override
    public void restart() {
        if (this.created.get()) {
            this.needRestart.set(true);
        } else {
            LOGGER.warning("Display is not created, cannot restart window.");
        }
    }

    protected void createContext(AppSettings settings) {
        this.errorCallback = new GLFWErrorCallback(){

            @Override
            public void invoke(int error, long description2) {
                String message = GLFWErrorCallback.getDescription(description2);
                LwjglWindow.this.listener.handleError(message, new Exception(message));
            }
        };
        GLFW.glfwSetErrorCallback(this.errorCallback);
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        String renderer = settings.getRenderer();
        GLFW.glfwWindowHint(139270, 1);
        GLFW.glfwWindowHint(139272, 204801);
        RENDER_CONFIGS.computeIfAbsent(renderer, s -> () -> {
            GLFW.glfwWindowHint(139270, 0);
            GLFW.glfwWindowHint(139272, 0);
            GLFW.glfwWindowHint(139266, 2);
            GLFW.glfwWindowHint(139267, 0);
        }).run();
        if (settings.getBoolean("RendererDebug")) {
            GLFW.glfwWindowHint(139271, 1);
        }
        if (settings.isGammaCorrection()) {
            GLFW.glfwWindowHint(135182, 1);
        }
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, settings.isResizable() ? 1 : 0);
        GLFW.glfwWindowHint(135173, settings.getDepthBits());
        GLFW.glfwWindowHint(135174, settings.getStencilBits());
        GLFW.glfwWindowHint(135181, settings.getSamples());
        GLFW.glfwWindowHint(135180, settings.useStereo3D() ? 1 : 0);
        GLFW.glfwWindowHint(135183, settings.getFrequency() <= 0 ? -1 : settings.getFrequency());
        GLFW.glfwWindowHint(143361, settings.isUseRetinaFrameBuffer() ? 1 : 0);
        if (settings.getBitsPerPixel() == 24) {
            GLFW.glfwWindowHint(135169, 8);
            GLFW.glfwWindowHint(135170, 8);
            GLFW.glfwWindowHint(135171, 8);
        } else if (settings.getBitsPerPixel() == 16) {
            GLFW.glfwWindowHint(135169, 5);
            GLFW.glfwWindowHint(135170, 6);
            GLFW.glfwWindowHint(135171, 5);
        }
        GLFW.glfwWindowHint(135172, settings.getAlphaBits());
        long monitor = 0L;
        if (settings.isFullscreen()) {
            monitor = GLFW.glfwGetPrimaryMonitor();
        }
        GLFWVidMode videoMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        int requestWidth = settings.getWindowWidth();
        int requestHeight = settings.getWindowHeight();
        if (requestWidth <= 0 || requestHeight <= 0) {
            requestWidth = videoMode.width();
            requestHeight = videoMode.height();
        }
        this.window = GLFW.glfwCreateWindow(requestWidth, requestHeight, settings.getTitle(), monitor, 0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        this.windowFocusCallback = new GLFWWindowFocusCallback(){

            @Override
            public void invoke(long window, boolean focus2) {
                if (LwjglWindow.this.wasActive != focus2) {
                    if (!LwjglWindow.this.wasActive) {
                        LwjglWindow.this.listener.gainFocus();
                        LwjglWindow.this.timer.reset();
                    } else {
                        LwjglWindow.this.listener.loseFocus();
                    }
                    LwjglWindow.this.wasActive = !LwjglWindow.this.wasActive;
                }
            }
        };
        GLFW.glfwSetWindowFocusCallback(this.window, this.windowFocusCallback);
        if (!settings.isFullscreen()) {
            if (settings.getCenterWindow()) {
                GLFW.glfwSetWindowPos(this.window, (videoMode.width() - requestWidth) / 2, (videoMode.height() - requestHeight) / 2);
            } else {
                GLFW.glfwSetWindowPos(this.window, settings.getWindowXPosition(), settings.getWindowYPosition());
            }
        }
        GLFW.glfwMakeContextCurrent(this.window);
        if (settings.isVSync()) {
            GLFW.glfwSwapInterval(1);
        } else {
            GLFW.glfwSwapInterval(0);
        }
        this.setWindowIcon(settings);
        this.showWindow();
        for (int i = 0; i < 4; ++i) {
            GLFW.glfwPollEvents();
        }
        this.windowSizeCallback = new GLFWWindowSizeCallback(){

            @Override
            public void invoke(long window, int width2, int height2) {
                LwjglWindow.this.updateSizes();
            }
        };
        GLFW.glfwSetWindowSizeCallback(this.window, this.windowSizeCallback);
        this.framebufferSizeCallback = new GLFWFramebufferSizeCallback(){

            @Override
            public void invoke(long window, int width2, int height2) {
                LwjglWindow.this.updateSizes();
            }
        };
        GLFW.glfwSetFramebufferSizeCallback(this.window, this.framebufferSizeCallback);
        this.allowSwapBuffers = settings.isSwapBuffers();
        if (settings.isOpenCLSupport()) {
            this.initOpenCL(this.window);
        }
        this.updateSizes();
    }

    private void updateSizes() {
        int windowHeight;
        GLFW.glfwGetWindowSize(this.window, this.width, this.height);
        int windowWidth = this.width[0] < 1 ? 1 : this.width[0];
        int n = windowHeight = this.height[0] < 1 ? 1 : this.height[0];
        if (this.settings.getWindowWidth() != windowWidth || this.settings.getWindowHeight() != windowHeight) {
            this.settings.setWindowSize(windowWidth, windowHeight);
            for (WindowSizeListener wsListener : this.windowSizeListeners.getArray()) {
                wsListener.onWindowSizeChanged(windowWidth, windowHeight);
            }
        }
        GLFW.glfwGetFramebufferSize(this.window, this.width, this.height);
        int framebufferWidth = this.width[0];
        int framebufferHeight = this.height[0];
        if (framebufferWidth != this.oldFramebufferWidth || framebufferHeight != this.oldFramebufferHeight) {
            this.settings.setResolution(framebufferWidth, framebufferHeight);
            this.listener.reshape(framebufferWidth, framebufferHeight);
            this.oldFramebufferWidth = framebufferWidth;
            this.oldFramebufferHeight = framebufferHeight;
        }
        float xScale = framebufferWidth / windowWidth;
        float yScale = framebufferHeight / windowHeight;
        if (this.oldScale.x != xScale || this.oldScale.y != yScale) {
            this.listener.rescale(xScale, yScale);
            this.oldScale.set(xScale, yScale);
        }
    }

    protected void showWindow() {
        GLFW.glfwShowWindow(this.window);
    }

    protected void setWindowIcon(AppSettings settings) {
        Object[] icons = settings.getIcons();
        if (icons == null) {
            return;
        }
        GLFWImage[] images = this.imagesToGLFWImages(icons);
        try (GLFWImage.Buffer iconSet = GLFWImage.malloc(images.length);){
            for (int i = images.length - 1; i >= 0; --i) {
                GLFWImage image = images[i];
                iconSet.put(i, image);
            }
            GLFW.glfwSetWindowIcon(this.window, iconSet);
        }
    }

    private GLFWImage[] imagesToGLFWImages(Object[] images) {
        GLFWImage[] out = new GLFWImage[images.length];
        for (int i = 0; i < images.length; ++i) {
            BufferedImage image = (BufferedImage)images[i];
            out[i] = this.imageToGLFWImage(image);
        }
        return out;
    }

    private GLFWImage imageToGLFWImage(BufferedImage image) {
        if (image.getType() != 3) {
            BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
            Graphics2D graphics = convertedImage.createGraphics();
            int targetWidth = image.getWidth();
            int targetHeight = image.getHeight();
            graphics.drawImage(image, 0, 0, targetWidth, targetHeight, null);
            graphics.dispose();
            image = convertedImage;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer(image.getWidth() * image.getHeight() * 4);
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int colorSpace = image.getRGB(j, i);
                buffer.put((byte)(colorSpace << 8 >> 24));
                buffer.put((byte)(colorSpace << 16 >> 24));
                buffer.put((byte)(colorSpace << 24 >> 24));
                buffer.put((byte)(colorSpace >> 24));
            }
        }
        buffer.flip();
        GLFWImage result2 = GLFWImage.create();
        result2.set(image.getWidth(), image.getHeight(), buffer);
        return result2;
    }

    protected void destroyContext() {
        try {
            if (this.renderer != null) {
                this.renderer.cleanup();
            }
            if (this.errorCallback != null) {
                GLFW.glfwSetErrorCallback(null);
                this.errorCallback.close();
                this.errorCallback = null;
            }
            if (this.windowSizeCallback != null) {
                this.windowSizeCallback.close();
                this.windowSizeCallback = null;
            }
            if (this.framebufferSizeCallback != null) {
                this.framebufferSizeCallback.close();
                this.framebufferSizeCallback = null;
            }
            if (this.windowFocusCallback != null) {
                this.windowFocusCallback.close();
                this.windowFocusCallback = null;
            }
            if (this.window != 0L) {
                GLFW.glfwDestroyWindow(this.window);
                this.window = 0L;
            }
        }
        catch (Exception ex) {
            this.listener.handleError("Failed to destroy context", ex);
        }
    }

    @Override
    public void create(boolean waitFor) {
        if (this.created.get()) {
            LOGGER.warning("create() called when display is already created!");
            return;
        }
        if (Platform.get() == Platform.MACOSX) {
            this.mainThread = Thread.currentThread();
            this.mainThread.setName("jME3 Main");
            if (waitFor) {
                LOGGER.warning("create(true) is not supported for macOS!");
            }
            this.run();
        } else {
            this.mainThread = new Thread((Runnable)this, "jME3 Main");
            this.mainThread.start();
            if (waitFor) {
                this.waitFor(true);
            }
        }
    }

    protected boolean initInThread() {
        try {
            if (!JmeSystem.isLowPermissions()) {
                Thread.currentThread().setUncaughtExceptionHandler((thread2, thrown) -> {
                    this.listener.handleError("Uncaught exception thrown in " + thread2.toString(), thrown);
                    if (this.needClose.get()) {
                        this.deinitInThread();
                    }
                });
            }
            this.timer = new NanoTimer();
            this.createContext(this.settings);
            this.printContextInitInfo();
            this.created.set(true);
            super.internalCreate();
        }
        catch (Exception ex) {
            try {
                if (this.window != 0L) {
                    GLFW.glfwDestroyWindow(this.window);
                    this.window = 0L;
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.WARNING, null, ex2);
            }
            this.listener.handleError("Failed to create display", ex);
            return false;
        }
        this.listener.initialize();
        this.updateSizes();
        return true;
    }

    protected void runLoop() {
        if (this.needRestart.getAndSet(false)) {
            this.restartContext();
        }
        if (!this.created.get()) {
            throw new IllegalStateException();
        }
        this.listener.update();
        if (this.renderable.get()) {
            try {
                if (this.allowSwapBuffers && this.autoFlush) {
                    GLFW.glfwSwapBuffers(this.window);
                }
            }
            catch (Throwable ex) {
                this.listener.handleError("Error while swapping buffers", ex);
            }
        }
        if (this.renderer != null) {
            this.renderer.postFrame();
        }
        if (this.autoFlush) {
            if (this.frameRateLimit != this.getSettings().getFrameRate()) {
                this.setFrameRateLimit(this.getSettings().getFrameRate());
            }
        } else if (this.frameRateLimit != 20) {
            this.setFrameRateLimit(20);
        }
        Sync.sync(this.frameRateLimit);
        GLFW.glfwPollEvents();
    }

    private void restartContext() {
        try {
            this.destroyContext();
            this.createContext(this.settings);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to set display settings!", ex);
        }
        this.reinitContext();
        if (this.keyInput != null && this.keyInput.isInitialized()) {
            this.keyInput.resetContext();
        }
        if (this.mouseInput != null && this.mouseInput.isInitialized()) {
            this.mouseInput.resetContext();
        }
        LOGGER.fine("Display restarted.");
    }

    private void setFrameRateLimit(int frameRateLimit) {
        this.frameRateLimit = frameRateLimit;
    }

    protected void deinitInThread() {
        this.listener.destroy();
        this.destroyContext();
        super.internalDestroy();
        GLFW.glfwTerminate();
        LOGGER.fine("Display destroyed.");
    }

    @Override
    public void run() {
        if (this.listener == null) {
            throw new IllegalStateException("SystemListener is not set on context!Must set with JmeContext.setSystemListener().");
        }
        LOGGER.log(Level.FINE, "Using LWJGL {0}", Version.getVersion());
        if (!this.initInThread()) {
            LOGGER.log(Level.SEVERE, "Display initialization failed. Cannot continue.");
            return;
        }
        while (true) {
            this.runLoop();
            if (this.needClose.get()) break;
            if (!GLFW.glfwWindowShouldClose(this.window)) continue;
            this.listener.requestClose(false);
        }
        this.deinitInThread();
    }

    @Override
    public JoyInput getJoyInput() {
        if (this.joyInput == null) {
            this.joyInput = new GlfwJoystickInput();
        }
        return this.joyInput;
    }

    @Override
    public MouseInput getMouseInput() {
        if (this.mouseInput == null) {
            this.mouseInput = new GlfwMouseInput(this);
        }
        return this.mouseInput;
    }

    @Override
    public KeyInput getKeyInput() {
        if (this.keyInput == null) {
            this.keyInput = new GlfwKeyInput(this);
        }
        return this.keyInput;
    }

    @Override
    public TouchInput getTouchInput() {
        return null;
    }

    @Override
    public void setAutoFlushFrames(boolean enabled) {
        this.autoFlush = enabled;
    }

    @Override
    public void destroy(boolean waitFor) {
        this.needClose.set(true);
        if (this.mainThread == Thread.currentThread()) {
            return;
        }
        if (waitFor) {
            this.waitFor(false);
        }
    }

    public long getWindowHandle() {
        return this.window;
    }

    public Vector2f getWindowContentScale(Vector2f store) {
        if (store == null) {
            store = new Vector2f();
        }
        GLFW.glfwGetFramebufferSize(this.window, this.width, this.height);
        store.set(this.width[0], this.height[0]);
        GLFW.glfwGetWindowSize(this.window, this.width, this.height);
        store.x /= (float)this.width[0];
        store.y /= (float)this.height[0];
        return store;
    }

    @Override
    public int getFramebufferHeight() {
        GLFW.glfwGetFramebufferSize(this.window, this.width, this.height);
        int result2 = this.height[0];
        return result2;
    }

    @Override
    public int getFramebufferWidth() {
        GLFW.glfwGetFramebufferSize(this.window, this.width, this.height);
        int result2 = this.width[0];
        return result2;
    }

    @Override
    public int getWindowXPosition() {
        GLFW.glfwGetWindowPos(this.window, this.width, this.height);
        int result2 = this.width[0];
        return result2;
    }

    @Override
    public int getWindowYPosition() {
        GLFW.glfwGetWindowPos(this.window, this.width, this.height);
        int result2 = this.height[0];
        return result2;
    }

    static {
        RENDER_CONFIGS.put("LWJGL-OpenGL30", () -> {
            GLFW.glfwWindowHint(139272, 0);
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 0);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL31", () -> {
            GLFW.glfwWindowHint(139272, 0);
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 1);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL3", () -> {
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 2);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL33", () -> {
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 3);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL4", () -> {
            GLFW.glfwWindowHint(139266, 4);
            GLFW.glfwWindowHint(139267, 0);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL41", () -> {
            GLFW.glfwWindowHint(139266, 4);
            GLFW.glfwWindowHint(139267, 1);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL42", () -> {
            GLFW.glfwWindowHint(139266, 4);
            GLFW.glfwWindowHint(139267, 2);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL43", () -> {
            GLFW.glfwWindowHint(139266, 4);
            GLFW.glfwWindowHint(139267, 3);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL44", () -> {
            GLFW.glfwWindowHint(139266, 4);
            GLFW.glfwWindowHint(139267, 4);
        });
        RENDER_CONFIGS.put("LWJGL-OpenGL45", () -> {
            GLFW.glfwWindowHint(139266, 4);
            GLFW.glfwWindowHint(139267, 5);
        });
    }
}

