/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.awt;

import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.awt.AwtKeyInput;
import com.jme3.input.awt.AwtMouseInput;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import com.jme3.system.awt.AwtPanel;
import com.jme3.system.awt.PaintMode;
import java.util.ArrayList;
import java.util.logging.Logger;

public class AwtPanelsContext
implements JmeContext {
    private static final Logger logger = Logger.getLogger(AwtPanelsContext.class.getName());
    protected JmeContext actualContext;
    protected AppSettings settings = new AppSettings(true);
    protected SystemListener listener;
    protected ArrayList<AwtPanel> panels = new ArrayList();
    protected AwtPanel inputSource;
    protected AwtMouseInput mouseInput = new AwtMouseInput();
    protected AwtKeyInput keyInput = new AwtKeyInput();
    protected boolean lastThrottleState = false;

    public void setInputSource(AwtPanel panel) {
        if (!this.panels.contains(panel)) {
            throw new IllegalArgumentException();
        }
        this.inputSource = panel;
        this.mouseInput.setInputSource(panel);
        this.keyInput.setInputSource(panel);
    }

    @Override
    public JmeContext.Type getType() {
        return JmeContext.Type.OffscreenSurface;
    }

    @Override
    public SystemListener getSystemListener() {
        return this.listener;
    }

    @Override
    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    @Override
    public AppSettings getSettings() {
        return this.settings;
    }

    @Override
    public Renderer getRenderer() {
        return this.actualContext.getRenderer();
    }

    @Override
    public MouseInput getMouseInput() {
        return this.mouseInput;
    }

    @Override
    public KeyInput getKeyInput() {
        return this.keyInput;
    }

    @Override
    public JoyInput getJoyInput() {
        return null;
    }

    @Override
    public TouchInput getTouchInput() {
        return null;
    }

    @Override
    public Timer getTimer() {
        return this.actualContext.getTimer();
    }

    @Override
    public boolean isCreated() {
        return this.actualContext != null && this.actualContext.isCreated();
    }

    @Override
    public boolean isRenderable() {
        return this.actualContext != null && this.actualContext.isRenderable();
    }

    @Override
    public Context getOpenCLContext() {
        return this.actualContext.getOpenCLContext();
    }

    public AwtPanel createPanel(PaintMode paintMode) {
        AwtPanel panel = new AwtPanel(paintMode);
        this.panels.add(panel);
        return panel;
    }

    public AwtPanel createPanel(PaintMode paintMode, boolean srgb) {
        AwtPanel panel = new AwtPanel(paintMode, srgb);
        this.panels.add(panel);
        return panel;
    }

    private void initInThread() {
        this.listener.initialize();
    }

    private void updateInThread() {
        boolean needThrottle = true;
        for (AwtPanel panel : this.panels) {
            if (!panel.isActiveDrawing()) continue;
            needThrottle = false;
            break;
        }
        if (this.lastThrottleState != needThrottle) {
            this.lastThrottleState = needThrottle;
            if (this.lastThrottleState) {
                System.out.println("OGL: Throttling update loop.");
            } else {
                System.out.println("OGL: Ceased throttling update loop.");
            }
        }
        if (needThrottle) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.listener.update();
        for (AwtPanel panel : this.panels) {
            panel.onFrameEnd();
        }
    }

    private void destroyInThread() {
        this.listener.destroy();
    }

    @Override
    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        this.settings.setRenderer("LWJGL-OpenGL2");
        if (this.actualContext != null) {
            this.actualContext.setSettings(settings);
        }
    }

    @Override
    public void create(boolean waitFor) {
        if (this.actualContext != null) {
            throw new IllegalStateException("Already created");
        }
        this.actualContext = JmeSystem.newContext(this.settings, JmeContext.Type.OffscreenSurface);
        this.actualContext.setSystemListener(new AwtPanelsListener());
        this.actualContext.create(waitFor);
    }

    @Override
    public void destroy(boolean waitFor) {
        if (this.actualContext == null) {
            throw new IllegalStateException("Not created");
        }
        this.actualContext.destroy(waitFor);
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setAutoFlushFrames(boolean enabled) {
    }

    @Override
    public void restart() {
    }

    @Override
    public int getFramebufferHeight() {
        return this.inputSource.getHeight();
    }

    @Override
    public int getFramebufferWidth() {
        return this.inputSource.getWidth();
    }

    @Override
    public int getWindowXPosition() {
        return this.inputSource.getX();
    }

    @Override
    public int getWindowYPosition() {
        return this.inputSource.getY();
    }

    private class AwtPanelsListener
    implements SystemListener {
        private AwtPanelsListener() {
        }

        @Override
        public void initialize() {
            AwtPanelsContext.this.initInThread();
        }

        @Override
        public void reshape(int width2, int height2) {
            logger.severe("reshape is not supported.");
        }

        @Override
        public void rescale(float x2, float y2) {
            logger.severe("rescale is not supported.");
        }

        @Override
        public void update() {
            AwtPanelsContext.this.updateInThread();
        }

        @Override
        public void requestClose(boolean esc) {
            throw new IllegalStateException();
        }

        @Override
        public void gainFocus() {
            throw new IllegalStateException();
        }

        @Override
        public void loseFocus() {
            throw new IllegalStateException();
        }

        @Override
        public void handleError(String errorMsg, Throwable t) {
            AwtPanelsContext.this.listener.handleError(errorMsg, t);
        }

        @Override
        public void destroy() {
            AwtPanelsContext.this.destroyInThread();
        }
    }
}

