/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.awt;

import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.awt.PaintMode;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import com.jme3.util.Screenshots;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ImageCapabilities;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AwtPanel
extends Canvas
implements SceneProcessor {
    private boolean attachAsMain = false;
    private BufferedImage img;
    private FrameBuffer fb;
    private boolean srgb = false;
    private ByteBuffer byteBuf;
    private IntBuffer intBuf;
    private RenderManager rm;
    private PaintMode paintMode;
    private ArrayList<ViewPort> viewPorts = new ArrayList();
    private BufferStrategy strategy;
    private AffineTransformOp transformOp;
    private AtomicBoolean hasNativePeer = new AtomicBoolean(false);
    private AtomicBoolean showing = new AtomicBoolean(false);
    private AtomicBoolean repaintRequest = new AtomicBoolean(false);
    private int newWidth = 1;
    private int newHeight = 1;
    private AtomicBoolean reshapeNeeded = new AtomicBoolean(false);
    private final Object lock = new Object();

    public AwtPanel(PaintMode paintMode) {
        this(paintMode, false);
    }

    public AwtPanel(PaintMode paintMode, boolean srgb) {
        this.paintMode = paintMode;
        this.srgb = srgb;
        if (paintMode == PaintMode.Accelerated) {
            this.setIgnoreRepaint(true);
        }
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void componentResized(ComponentEvent e) {
                Object object = AwtPanel.this.lock;
                synchronized (object) {
                    int newWidth2 = Math.max(AwtPanel.this.getWidth(), 1);
                    int newHeight2 = Math.max(AwtPanel.this.getHeight(), 1);
                    if (AwtPanel.this.newWidth != newWidth2 || AwtPanel.this.newHeight != newHeight2) {
                        AwtPanel.this.newWidth = newWidth2;
                        AwtPanel.this.newHeight = newHeight2;
                        AwtPanel.this.reshapeNeeded.set(true);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        Object object = this.lock;
        synchronized (object) {
            this.hasNativePeer.set(true);
        }
        this.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        Object object = this.lock;
        synchronized (object) {
            this.hasNativePeer.set(false);
        }
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object object = this.lock;
        synchronized (object) {
            g2d.drawImage(this.img, this.transformOp, 0, 0);
        }
    }

    public boolean checkVisibilityState() {
        if (!this.hasNativePeer.get()) {
            if (this.strategy != null) {
                this.strategy = null;
            }
            return false;
        }
        boolean currentShowing = this.isShowing();
        this.showing.set(currentShowing);
        return currentShowing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintInThread() {
        this.byteBuf.clear();
        this.rm.getRenderer().readFrameBuffer(this.fb, this.byteBuf);
        Object object = this.lock;
        synchronized (object) {
            Screenshots.convertScreenShot2(this.intBuf, this.img);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawFrameInThread() {
        this.byteBuf.clear();
        this.rm.getRenderer().readFrameBuffer(this.fb, this.byteBuf);
        Screenshots.convertScreenShot2(this.intBuf, this.img);
        Object object = this.lock;
        synchronized (object) {
            if (this.strategy == null) {
                try {
                    this.createBufferStrategy(1, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.UNDEFINED));
                }
                catch (AWTException ex) {
                    ex.printStackTrace();
                }
                this.strategy = this.getBufferStrategy();
            }
            do {
                Graphics2D g2d;
                if ((g2d = (Graphics2D)this.strategy.getDrawGraphics()) == null) {
                    Logger.getLogger(AwtPanel.class.getName()).log(Level.WARNING, "OGL: DrawGraphics was null.");
                    return;
                }
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g2d.drawImage(this.img, this.transformOp, 0, 0);
                g2d.dispose();
                this.strategy.show();
            } while (this.strategy.contentsRestored() || this.strategy.contentsLost());
        }
    }

    public boolean isActiveDrawing() {
        return this.paintMode != PaintMode.OnRequest && this.showing.get();
    }

    public void attachTo(boolean overrideMainFramebuffer, ViewPort ... vps) {
        if (this.viewPorts.size() > 0) {
            for (ViewPort vp : this.viewPorts) {
                vp.setOutputFrameBuffer(null);
            }
            this.viewPorts.get(this.viewPorts.size() - 1).removeProcessor(this);
        }
        this.viewPorts.addAll(Arrays.asList(vps));
        this.viewPorts.get(this.viewPorts.size() - 1).addProcessor(this);
        this.attachAsMain = overrideMainFramebuffer;
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        if (this.rm == null) {
            this.rm = rm;
            this.reshapeInThread(1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshapeInThread(int width2, int height2) {
        this.byteBuf = BufferUtils.ensureLargeEnough(this.byteBuf, width2 * height2 * 4);
        this.intBuf = this.byteBuf.asIntBuffer();
        if (this.fb != null) {
            this.fb.dispose();
            this.fb = null;
        }
        this.fb = new FrameBuffer(width2, height2, 1);
        this.fb.setDepthBuffer(Image.Format.Depth);
        this.fb.setColorBuffer(Image.Format.RGB8);
        this.fb.setSrgb(this.srgb);
        if (this.attachAsMain) {
            this.rm.getRenderer().setMainFrameBufferOverride(this.fb);
        }
        Object object = this.lock;
        synchronized (object) {
            this.img = new BufferedImage(width2, height2, 4);
        }
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -this.img.getHeight());
        this.transformOp = new AffineTransformOp(tx, 1);
        for (ViewPort vp : this.viewPorts) {
            if (!this.attachAsMain) {
                vp.setOutputFrameBuffer(this.fb);
            }
            vp.getCamera().resize(width2, height2, true);
            for (SceneProcessor sp : vp.getProcessors()) {
                sp.reshape(vp, width2, height2);
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.fb != null;
    }

    @Override
    public void preFrame(float tpf) {
    }

    @Override
    public void postQueue(RenderQueue rq) {
    }

    @Override
    public void invalidate() {
        this.repaintRequest.set(true);
    }

    void onFrameEnd() {
        if (this.reshapeNeeded.getAndSet(false)) {
            this.reshapeInThread(this.newWidth, this.newHeight);
        } else {
            if (!this.checkVisibilityState()) {
                return;
            }
            switch (this.paintMode) {
                case Accelerated: {
                    this.drawFrameInThread();
                    break;
                }
                case Repaint: {
                    this.repaintInThread();
                    break;
                }
                case OnRequest: {
                    if (!this.repaintRequest.getAndSet(false)) break;
                    this.repaintInThread();
                }
            }
        }
    }

    @Override
    public void postFrame(FrameBuffer out) {
        if (!this.attachAsMain && out != this.fb) {
            throw new IllegalStateException("Why did you change the output framebuffer?");
        }
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void setProfiler(AppProfiler profiler) {
    }
}

