/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.SoftTextDialogInput;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystemDelegate;
import com.jme3.system.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmeSystem {
    private static final Logger logger = Logger.getLogger(JmeSystem.class.getName());
    private static JmeSystemDelegate systemDelegate;

    private JmeSystem() {
    }

    public static void setSystemDelegate(JmeSystemDelegate systemDelegate) {
        JmeSystem.systemDelegate = systemDelegate;
    }

    public static synchronized File getStorageFolder() {
        return JmeSystem.getStorageFolder(StorageFolderType.External);
    }

    public static synchronized File getStorageFolder(StorageFolderType type2) {
        JmeSystem.checkDelegate();
        return systemDelegate.getStorageFolder(type2);
    }

    public static String getFullName() {
        JmeSystem.checkDelegate();
        return systemDelegate.getFullName();
    }

    public static InputStream getResourceAsStream(String name) {
        JmeSystem.checkDelegate();
        return systemDelegate.getResourceAsStream(name);
    }

    public static URL getResource(String name) {
        JmeSystem.checkDelegate();
        return systemDelegate.getResource(name);
    }

    public static boolean trackDirectMemory() {
        JmeSystem.checkDelegate();
        return systemDelegate.trackDirectMemory();
    }

    public static void setLowPermissions(boolean lowPerm) {
        JmeSystem.checkDelegate();
        systemDelegate.setLowPermissions(lowPerm);
    }

    public static boolean isLowPermissions() {
        JmeSystem.checkDelegate();
        return systemDelegate.isLowPermissions();
    }

    public static void setSoftTextDialogInput(SoftTextDialogInput input) {
        JmeSystem.checkDelegate();
        systemDelegate.setSoftTextDialogInput(input);
    }

    public static void showSoftKeyboard(boolean show2) {
        JmeSystem.checkDelegate();
        systemDelegate.showSoftKeyboard(show2);
    }

    public static SoftTextDialogInput getSoftTextDialogInput() {
        JmeSystem.checkDelegate();
        return systemDelegate.getSoftTextDialogInput();
    }

    public static void writeImageFile(OutputStream outStream, String format2, ByteBuffer imageData, int width2, int height2) throws IOException {
        JmeSystem.checkDelegate();
        systemDelegate.writeImageFile(outStream, format2, imageData, width2, height2);
    }

    public static AssetManager newAssetManager(URL configFile) {
        JmeSystem.checkDelegate();
        return systemDelegate.newAssetManager(configFile);
    }

    public static AssetManager newAssetManager() {
        JmeSystem.checkDelegate();
        return systemDelegate.newAssetManager();
    }

    public static Platform getPlatform() {
        JmeSystem.checkDelegate();
        return systemDelegate.getPlatform();
    }

    public static JmeContext newContext(AppSettings settings, JmeContext.Type contextType) {
        JmeSystem.checkDelegate();
        return systemDelegate.newContext(settings, contextType);
    }

    public static AudioRenderer newAudioRenderer(AppSettings settings) {
        JmeSystem.checkDelegate();
        return systemDelegate.newAudioRenderer(settings);
    }

    public static URL getPlatformAssetConfigURL() {
        JmeSystem.checkDelegate();
        return systemDelegate.getPlatformAssetConfigURL();
    }

    @Deprecated
    public static void showErrorDialog(String message) {
        JmeSystem.handleErrorMessage(message);
    }

    public static void handleErrorMessage(String message) {
        JmeSystem.checkDelegate();
        systemDelegate.handleErrorMessage(message);
    }

    public static void setErrorMessageHandler(Consumer<String> handler) {
        JmeSystem.checkDelegate();
        systemDelegate.setErrorMessageHandler(handler);
    }

    public static void handleSettings(AppSettings sourceSettings, boolean loadFromRegistry) {
        JmeSystem.checkDelegate();
        systemDelegate.handleSettings(sourceSettings, loadFromRegistry);
    }

    public static void setSettingsHandler(BiFunction<AppSettings, Boolean, Boolean> handler) {
        JmeSystem.checkDelegate();
        systemDelegate.setSettingsHandler(handler);
    }

    @Deprecated
    public static boolean showSettingsDialog(AppSettings sourceSettings, boolean loadFromRegistry) {
        JmeSystem.checkDelegate();
        return systemDelegate.showSettingsDialog(sourceSettings, loadFromRegistry);
    }

    public static void initialize(AppSettings settings) {
        JmeSystem.checkDelegate();
        systemDelegate.initialize(settings);
    }

    private static JmeSystemDelegate tryLoadDelegate(String className) throws InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        try {
            return (JmeSystemDelegate)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    private static void checkDelegate() {
        if (systemDelegate == null) {
            try {
                systemDelegate = JmeSystem.tryLoadDelegate("com.jme3.system.JmeDesktopSystem");
                if (systemDelegate == null && (systemDelegate = JmeSystem.tryLoadDelegate("com.jme3.system.android.JmeAndroidSystem")) == null && (systemDelegate = JmeSystem.tryLoadDelegate("com.jme3.system.ios.JmeIosSystem")) == null) {
                    Logger.getLogger(JmeSystem.class.getName()).log(Level.SEVERE, "Failed to find a JmeSystem delegate!\nEnsure either desktop or android jME3 jar is in the classpath.");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                Logger.getLogger(JmeSystem.class.getName()).log(Level.SEVERE, "Failed to create JmeSystem delegate:\n{0}", ex);
            }
        }
    }

    public static enum StorageFolderType {
        Internal,
        External;

    }
}

