/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.system.NativeLibraryLoader;
import com.jme3.system.Platform;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtractNativeLibraries {
    public static void main(String[] args2) {
        if (args2.length == 1 && "getjarexcludes".equals(args2[0])) {
            File[] jarFiles = NativeLibraryLoader.getJarsWithNatives();
            for (int i = 0; i < jarFiles.length; ++i) {
                File jarFile = jarFiles[i];
                System.out.print("**/*" + jarFile.getName());
                if (i == jarFiles.length - 1) continue;
                System.out.print(",");
            }
            System.exit(0);
        }
        if (args2.length < 2) {
            System.err.println("Usage: ExtractNativeLibraries Platform ExtractionPath");
            System.err.println("Where 'Platform' is either Windows32, Windows64, Linux32, Linux64, MacOSX32 or MacOSX64");
            System.err.println("'ExtractionPath' is a folder to extract the binaries to.");
            System.err.println("You can also use ExtractNativeLibraries getjarexcludes to get a list of excludes for the jar files that contain binaries.");
            System.exit(1);
        }
        String path = args2[1].replace('/', File.separatorChar);
        File folder = new File(path);
        try {
            if ("Windows32".equals(args2[0])) {
                NativeLibraryLoader.extractNativeLibraries(Platform.Windows32, folder);
            } else if ("Windows64".equals(args2[0])) {
                NativeLibraryLoader.extractNativeLibraries(Platform.Windows64, folder);
            } else if ("Linux32".equals(args2[0])) {
                NativeLibraryLoader.extractNativeLibraries(Platform.Linux32, folder);
            } else if ("Linux64".equals(args2[0])) {
                NativeLibraryLoader.extractNativeLibraries(Platform.Linux64, folder);
            } else if ("MacOSX32".equals(args2[0])) {
                NativeLibraryLoader.extractNativeLibraries(Platform.MacOSX32, folder);
            } else if ("MacOSX64".equals(args2[0])) {
                NativeLibraryLoader.extractNativeLibraries(Platform.MacOSX64, folder);
            } else {
                System.err.println("Please specify a platform, Windows32, Windows64, Linux32, Linux64, MacOSX32 or MacOSX64");
                System.exit(3);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ExtractNativeLibraries.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

