/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.input.AWTKeyInput;
import com.jme3.input.AWTMouseInput;
import com.jme3.input.JoyInput;
import com.jme3.input.TouchInput;
import com.jme3.opencl.Context;
import com.jme3.renderer.Renderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;

public class AWTContext
implements JmeContext {
    protected final AppSettings settings;
    protected final AWTKeyInput keyInput = new AWTKeyInput(this);
    protected final AWTMouseInput mouseInput = new AWTMouseInput(this);
    private volatile int width = 1;
    private volatile int height = 1;
    protected JmeContext backgroundContext;

    public AWTContext() {
        this.settings = this.createSettings();
        this.backgroundContext = this.createBackgroundContext();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height2) {
        this.height = height2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width2) {
        this.width = width2;
    }

    protected AppSettings createSettings() {
        AppSettings settings = new AppSettings(true);
        settings.setRenderer("LWJGL-OpenGL3");
        return settings;
    }

    protected JmeContext createBackgroundContext() {
        return JmeSystem.newContext(this.settings, JmeContext.Type.OffscreenSurface);
    }

    @Override
    public JmeContext.Type getType() {
        return JmeContext.Type.OffscreenSurface;
    }

    @Override
    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
        this.settings.setRenderer("LWJGL-OpenGL3");
        this.backgroundContext.setSettings(settings);
    }

    @Override
    public SystemListener getSystemListener() {
        return this.backgroundContext.getSystemListener();
    }

    @Override
    public void setSystemListener(SystemListener listener) {
        this.backgroundContext.setSystemListener(listener);
    }

    @Override
    public AppSettings getSettings() {
        return this.settings;
    }

    @Override
    public Renderer getRenderer() {
        return this.backgroundContext.getRenderer();
    }

    @Override
    public Context getOpenCLContext() {
        return null;
    }

    @Override
    public AWTMouseInput getMouseInput() {
        return this.mouseInput;
    }

    @Override
    public AWTKeyInput getKeyInput() {
        return this.keyInput;
    }

    @Override
    public JoyInput getJoyInput() {
        return null;
    }

    @Override
    public TouchInput getTouchInput() {
        return null;
    }

    @Override
    public Timer getTimer() {
        return this.backgroundContext.getTimer();
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public boolean isCreated() {
        return this.backgroundContext != null && this.backgroundContext.isCreated();
    }

    @Override
    public boolean isRenderable() {
        return this.backgroundContext != null && this.backgroundContext.isRenderable();
    }

    @Override
    public void setAutoFlushFrames(boolean enabled) {
    }

    @Override
    public void create(boolean waitFor) {
        String render2 = System.getProperty("awt.background.render", "LWJGL-OpenGL33");
        this.backgroundContext.getSettings().setRenderer(render2);
        this.backgroundContext.create(waitFor);
    }

    @Override
    public void restart() {
    }

    @Override
    public void destroy(boolean waitFor) {
        if (this.backgroundContext == null) {
            throw new IllegalStateException("Not created");
        }
        this.backgroundContext.destroy(waitFor);
    }

    @Override
    public int getFramebufferHeight() {
        return this.height;
    }

    @Override
    public int getFramebufferWidth() {
        return this.width;
    }

    @Override
    public int getWindowXPosition() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public int getWindowYPosition() {
        throw new UnsupportedOperationException("not implemented yet");
    }
}

