/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ShaderDependencyNode {
    private String extensions;
    private String shaderSource;
    private String shaderName;
    private final List<ShaderDependencyNode> dependencies = new ArrayList<ShaderDependencyNode>();
    private final List<Integer> dependencyInjectIndices = new ArrayList<Integer>();
    private final List<ShaderDependencyNode> dependOnMe = new ArrayList<ShaderDependencyNode>();

    public ShaderDependencyNode(String shaderName) {
        this.shaderName = shaderName;
    }

    public String getSource() {
        return this.shaderSource;
    }

    public void setSource(String shaderSource) {
        this.shaderSource = shaderSource;
    }

    public String getName() {
        return this.shaderName;
    }

    public void setName(String shaderName) {
        this.shaderName = shaderName;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    public void addDependency(int index2, ShaderDependencyNode node2) {
        if (this.dependencies.contains(node2)) {
            return;
        }
        this.dependencies.add(node2);
        this.dependencyInjectIndices.add(index2);
        node2.dependOnMe.add(this);
    }

    public void removeDependency(ShaderDependencyNode node2) {
        int positionInList = this.dependencies.indexOf(node2);
        if (positionInList == -1) {
            throw new IllegalArgumentException("The given node " + node2.getName() + " is not in this node's (" + this.getName() + ") dependency list");
        }
        this.dependencies.remove(positionInList);
        this.dependencyInjectIndices.remove(positionInList);
    }

    public List<ShaderDependencyNode> getDependOnMe() {
        return Collections.unmodifiableList(this.dependOnMe);
    }

    public List<ShaderDependencyNode> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public List<Integer> getDependencyInjectIndices() {
        return Collections.unmodifiableList(this.dependencyInjectIndices);
    }
}

