/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.asset.AssetManager;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.material.TechniqueDef;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNode;
import com.jme3.shader.plugins.ShaderAssetKey;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ShaderGenerator {
    public static final String NAME_SPACE_GLOBAL = "Global";
    public static final String NAME_SPACE_VERTEX_ATTRIBUTE = "Attr";
    public static final String NAME_SPACE_MAT_PARAM = "MatParam";
    public static final String NAME_SPACE_WORLD_PARAM = "WorldParam";
    protected AssetManager assetManager;
    protected int indent;
    protected TechniqueDef techniqueDef = null;
    Pattern extensions = Pattern.compile("(#extension.*\\s+)");
    private final Map<String, String> imports = new LinkedHashMap<String, String>();

    protected ShaderGenerator(AssetManager assetManager2) {
        this.assetManager = assetManager2;
    }

    public void initialize(TechniqueDef techniqueDef) {
        this.techniqueDef = techniqueDef;
    }

    public Shader generateShader(String definesSourceCode) {
        if (this.techniqueDef == null) {
            throw new UnsupportedOperationException("The shaderGenerator was not properly initialized, call initialize(TechniqueDef) before any generation");
        }
        String techniqueName = this.techniqueDef.getName();
        ShaderGenerationInfo info2 = this.techniqueDef.getShaderGenerationInfo();
        Shader shader = new Shader();
        for (Shader.ShaderType type2 : Shader.ShaderType.values()) {
            String extension = type2.getExtension();
            String language = this.getLanguageAndVersion(type2);
            String shaderSourceCode = this.buildShader(this.techniqueDef.getShaderNodes(), info2, type2);
            if (shaderSourceCode == null) continue;
            String shaderSourceAssetName = techniqueName + "." + extension;
            shader.addSource(type2, shaderSourceAssetName, shaderSourceCode, definesSourceCode, language);
        }
        this.techniqueDef = null;
        return shader;
    }

    protected String buildShader(List<ShaderNode> shaderNodes, ShaderGenerationInfo info2, Shader.ShaderType type2) {
        if (type2 == Shader.ShaderType.TessellationControl || type2 == Shader.ShaderType.TessellationEvaluation || type2 == Shader.ShaderType.Geometry) {
            return null;
        }
        this.imports.clear();
        this.indent = 0;
        StringBuilder sourceDeclaration = new StringBuilder();
        StringBuilder source = new StringBuilder();
        this.generateUniforms(sourceDeclaration, info2, type2);
        if (type2 == Shader.ShaderType.Vertex) {
            this.generateAttributes(sourceDeclaration, info2);
        }
        this.generateVaryings(sourceDeclaration, info2, type2);
        this.generateStartOfMainSection(source, info2, type2);
        this.generateDeclarationAndMainBody(shaderNodes, sourceDeclaration, source, info2, type2);
        this.generateEndOfMainSection(source, info2, type2);
        int insertIndex = sourceDeclaration.length();
        for (String importSource : this.imports.values()) {
            sourceDeclaration.insert(insertIndex, importSource);
        }
        sourceDeclaration.append((CharSequence)source);
        return this.moveExtensionsUp(sourceDeclaration);
    }

    private String moveExtensionsUp(StringBuilder sourceDeclaration) {
        Matcher m = this.extensions.matcher(sourceDeclaration.toString());
        StringBuilder finalSource = new StringBuilder();
        while (m.find()) {
            finalSource.append(m.group());
        }
        finalSource.append(m.replaceAll(""));
        return finalSource.toString();
    }

    protected void generateDeclarationAndMainBody(List<ShaderNode> shaderNodes, StringBuilder sourceDeclaration, StringBuilder source, ShaderGenerationInfo info2, Shader.ShaderType type2) {
        for (ShaderNode shaderNode : shaderNodes) {
            if (info2.getUnusedNodes().contains(shaderNode.getName()) || shaderNode.getDefinition().getType() != type2) continue;
            int index2 = this.findShaderIndexFromVersion(shaderNode, type2);
            String shaderPath = shaderNode.getDefinition().getShadersPath().get(index2);
            Map sources = (Map)this.assetManager.loadAsset(new ShaderAssetKey(shaderPath, false));
            String loadedSource = (String)sources.get("[main]");
            for (String name : sources.keySet()) {
                if (name.equals("[main]")) continue;
                this.imports.put(name, (String)sources.get(name));
            }
            this.appendNodeDeclarationAndMain(loadedSource, sourceDeclaration, source, shaderNode, info2, shaderPath);
        }
    }

    protected void appendNodeDeclarationAndMain(String loadedSource, StringBuilder sourceDeclaration, StringBuilder source, ShaderNode shaderNode, ShaderGenerationInfo info2, String shaderPath) {
        if (loadedSource.length() > 1) {
            String[] sourceParts = (loadedSource = loadedSource.substring(0, loadedSource.lastIndexOf("}"))).split("\\s*void\\s*main\\s*\\(\\s*\\)\\s*\\{");
            if (sourceParts.length < 2) {
                throw new IllegalArgumentException("Syntax error in " + shaderPath + ". Cannot find 'void main(){' in \n" + loadedSource);
            }
            this.generateDeclarativeSection(sourceDeclaration, shaderNode, sourceParts[0], info2);
            this.generateNodeMainSection(source, shaderNode, sourceParts[1], info2);
        } else {
            this.generateNodeMainSection(source, shaderNode, loadedSource, info2);
        }
    }

    protected abstract String getLanguageAndVersion(Shader.ShaderType var1);

    protected abstract void generateUniforms(StringBuilder var1, ShaderGenerationInfo var2, Shader.ShaderType var3);

    protected abstract void generateAttributes(StringBuilder var1, ShaderGenerationInfo var2);

    protected abstract void generateVaryings(StringBuilder var1, ShaderGenerationInfo var2, Shader.ShaderType var3);

    protected abstract void generateDeclarativeSection(StringBuilder var1, ShaderNode var2, String var3, ShaderGenerationInfo var4);

    protected abstract void generateStartOfMainSection(StringBuilder var1, ShaderGenerationInfo var2, Shader.ShaderType var3);

    protected abstract void generateEndOfMainSection(StringBuilder var1, ShaderGenerationInfo var2, Shader.ShaderType var3);

    protected abstract void generateNodeMainSection(StringBuilder var1, ShaderNode var2, String var3, ShaderGenerationInfo var4);

    protected int findShaderIndexFromVersion(ShaderNode shaderNode, Shader.ShaderType type2) throws NumberFormatException {
        int index2 = 0;
        List<String> lang = shaderNode.getDefinition().getShadersLanguage();
        int genVersion = Integer.parseInt(this.getLanguageAndVersion(type2).substring(4));
        int curVersion = 0;
        for (int i = 0; i < lang.size(); ++i) {
            int version = Integer.parseInt(lang.get(i).substring(4));
            if (version <= curVersion || version > genVersion) continue;
            curVersion = version;
            index2 = i;
        }
        return index2;
    }
}

