/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.asset.AssetManager;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.shader.Glsl100ShaderGenerator;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderNodeVariable;

public class Glsl150ShaderGenerator
extends Glsl100ShaderGenerator {
    public Glsl150ShaderGenerator(AssetManager assetManager2) {
        super(assetManager2);
    }

    @Override
    protected String getLanguageAndVersion(Shader.ShaderType type2) {
        return "GLSL150";
    }

    @Override
    protected void declareAttribute(StringBuilder source, ShaderNodeVariable var) {
        this.declareVariable(source, var, false, "in");
    }

    @Override
    protected void declareVarying(StringBuilder source, ShaderNodeVariable var, boolean input) {
        this.declareVariable(source, var, true, input ? "in" : "out");
    }

    @Override
    protected void generateUniforms(StringBuilder source, ShaderGenerationInfo info2, Shader.ShaderType type2) {
        this.generateCompatibilityDefines(source, type2);
        super.generateUniforms(source, info2, type2);
    }

    private void generateCompatibilityDefines(StringBuilder source, Shader.ShaderType type2) {
        if (type2 == Shader.ShaderType.Fragment) {
            source.append("\n").append("#define texture1D texture\n").append("#define texture2D texture\n").append("#define texture3D texture\n").append("#define textureCube texture\n").append("#define texture2DLod textureLod\n").append("#define textureCubeLod textureLod\n");
        }
    }

    @Override
    protected void generateStartOfMainSection(StringBuilder source, ShaderGenerationInfo info2, Shader.ShaderType type2) {
        source.append("\n");
        if (type2 == Shader.ShaderType.Fragment) {
            for (ShaderNodeVariable global : info2.getFragmentGlobals()) {
                this.declareVariable(source, global, null, true, "out");
            }
        }
        source.append("\n");
        this.appendIndent(source);
        source.append("void main(){\n");
        this.indent();
        if (type2 == Shader.ShaderType.Vertex) {
            this.declareGlobalPosition(info2, source);
        } else if (type2 == Shader.ShaderType.Fragment) {
            for (ShaderNodeVariable global : info2.getFragmentGlobals()) {
                this.initVariable(source, global, "vec4(1.0)");
            }
        }
    }

    @Override
    protected void generateEndOfMainSection(StringBuilder source, ShaderGenerationInfo info2, Shader.ShaderType type2) {
        if (type2 == Shader.ShaderType.Vertex) {
            this.appendOutput(source, "gl_Position", info2.getVertexGlobal());
        }
        this.unIndent();
        this.appendIndent(source);
        source.append("}\n");
    }

    protected void initVariable(StringBuilder source, ShaderNodeVariable var, String initValue) {
        this.appendIndent(source);
        source.append(var.getNameSpace());
        source.append("_");
        source.append(var.getName());
        source.append(" = ");
        source.append(initValue);
        source.append(";\n");
    }
}

