/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.shader.VarType;
import java.util.Arrays;
import java.util.List;

public final class DefineList {
    public static final int MAX_DEFINES = 64;
    private long isSet;
    private final int[] values;

    public DefineList(int numValues) {
        if (numValues < 0 || numValues > 64) {
            throw new IllegalArgumentException("numValues must be between 0 and 64");
        }
        this.values = new int[numValues];
    }

    private DefineList(DefineList original) {
        this.isSet = original.isSet;
        this.values = new int[original.values.length];
        System.arraycopy(original.values, 0, this.values, 0, this.values.length);
    }

    private void rangeCheck(int id) {
        assert (0 <= id && id < this.values.length);
    }

    public boolean isSet(int id) {
        this.rangeCheck(id);
        return (this.isSet & 1L << id) != 0L;
    }

    public void unset(int id) {
        this.rangeCheck(id);
        this.isSet &= 1L << id ^ 0xFFFFFFFFFFFFFFFFL;
        this.values[id] = 0;
    }

    public void set(int id, int val) {
        this.rangeCheck(id);
        this.isSet |= 1L << id;
        this.values[id] = val;
    }

    public void set(int id, float val) {
        this.set(id, Float.floatToIntBits(val));
    }

    public void set(int id, boolean val) {
        if (val) {
            this.set(id, 1);
        } else {
            this.unset(id);
        }
    }

    public void set(int id, VarType type2, Object value) {
        if (value != null) {
            switch (type2) {
                case Int: {
                    this.set(id, (Integer)value);
                    break;
                }
                case Float: {
                    this.set(id, ((Float)value).floatValue());
                    break;
                }
                case Boolean: {
                    this.set(id, (Boolean)value);
                    break;
                }
                default: {
                    this.set(id, 1);
                    break;
                }
            }
        } else {
            this.unset(id);
        }
    }

    public void setAll(DefineList other) {
        for (int i = 0; i < other.values.length; ++i) {
            if (!other.isSet(i)) continue;
            this.set(i, other.getInt(i));
        }
    }

    public void clear() {
        this.isSet = 0L;
        Arrays.fill(this.values, 0);
    }

    public boolean getBoolean(int id) {
        return this.values[id] != 0;
    }

    public float getFloat(int id) {
        return Float.intBitsToFloat(this.values[id]);
    }

    public int getInt(int id) {
        return this.values[id];
    }

    public int hashCode() {
        return (int)(this.isSet >> 32 ^ this.isSet);
    }

    public boolean equals(Object other) {
        DefineList o = (DefineList)other;
        if (this.isSet == o.isSet) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == o.values[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public DefineList deepClone() {
        return new DefineList(this);
    }

    public void generateSource(StringBuilder sb, List<String> defineNames, List<VarType> defineTypes) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.isSet(i)) continue;
            sb.append("#define ").append(defineNames.get(i)).append(' ');
            if (defineTypes != null && defineTypes.get(i) == VarType.Float) {
                float val = Float.intBitsToFloat(this.values[i]);
                if (Float.isInfinite(val) || Float.isNaN(val)) {
                    throw new IllegalArgumentException("GLSL does not support NaN or Infinite float literals");
                }
                sb.append(val);
            } else {
                sb.append(this.values[i]);
            }
            sb.append('\n');
        }
    }

    public String generateSource(List<String> defineNames, List<VarType> defineTypes) {
        StringBuilder sb = new StringBuilder();
        this.generateSource(sb, defineNames, defineTypes);
        return sb.toString();
    }
}

