/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.io.IOException;

public class Quad
extends Mesh {
    private float width;
    private float height;

    protected Quad() {
    }

    public Quad(float width2, float height2) {
        this.updateGeometry(width2, height2);
    }

    public Quad(float width2, float height2, boolean flipCoords) {
        this.updateGeometry(width2, height2, flipCoords);
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public void updateGeometry(float width2, float height2) {
        this.updateGeometry(width2, height2, false);
    }

    public void updateGeometry(float width2, float height2, boolean flipCoords) {
        this.width = width2;
        this.height = height2;
        this.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, width2, 0.0f, 0.0f, width2, height2, 0.0f, 0.0f, height2, 0.0f});
        if (flipCoords) {
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
        } else {
            this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        }
        this.setBuffer(VertexBuffer.Type.Normal, 3, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
        if (height2 < 0.0f) {
            this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 2, 1, 0, 3, 2});
        } else {
            this.setBuffer(VertexBuffer.Type.Index, 3, new short[]{0, 1, 2, 0, 2, 3});
        }
        this.updateBound();
        this.setStatic();
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.width = capsule.readFloat("width", 0.0f);
        this.height = capsule.readFloat("height", 0.0f);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.width, "width", 0.0f);
        capsule.write(this.height, "height", 0.0f);
    }
}

