/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Line
extends Mesh {
    private Vector3f start = new Vector3f();
    private Vector3f end = new Vector3f();

    protected Line() {
    }

    public Line(Vector3f start2, Vector3f end2) {
        this.setMode(Mesh.Mode.Lines);
        this.updateGeometry(start2, end2);
    }

    protected void updateGeometry(Vector3f start2, Vector3f end2) {
        this.start.set(start2);
        this.end.set(end2);
        this.setBuffer(VertexBuffer.Type.Position, 3, new float[]{start2.x, start2.y, start2.z, end2.x, end2.y, end2.z});
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        this.setBuffer(VertexBuffer.Type.Normal, 3, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
        this.setBuffer(VertexBuffer.Type.Index, 2, new short[]{0, 1});
        this.updateBound();
    }

    public void updatePoints(Vector3f start2, Vector3f end2) {
        this.start.set(start2);
        this.end.set(end2);
        VertexBuffer posBuf = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fb = (FloatBuffer)posBuf.getData();
        fb.rewind();
        fb.put(start2.x).put(start2.y).put(start2.z);
        fb.put(end2.x).put(end2.y).put(end2.z);
        posBuf.updateData(fb);
        this.updateBound();
    }

    public Vector3f getEnd() {
        return this.end;
    }

    public Vector3f getStart() {
        return this.start;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.start, "startVertex", null);
        out.write(this.end, "endVertex", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule in = im.getCapsule(this);
        this.start = (Vector3f)in.readSavable("startVertex", this.start);
        this.end = (Vector3f)in.readSavable("endVertex", this.end);
    }
}

