/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;

public class Cylinder
extends Mesh {
    private int axisSamples;
    private int radialSamples;
    private float radius;
    private float radius2;
    private float height;
    private boolean closed;
    private boolean inverted;

    protected Cylinder() {
    }

    public Cylinder(int axisSamples, int radialSamples, float radius, float height2) {
        this(axisSamples, radialSamples, radius, height2, false);
    }

    public Cylinder(int axisSamples, int radialSamples, float radius, float height2, boolean closed) {
        this(axisSamples, radialSamples, radius, height2, closed, false);
    }

    public Cylinder(int axisSamples, int radialSamples, float radius, float height2, boolean closed, boolean inverted) {
        this(axisSamples, radialSamples, radius, radius, height2, closed, inverted);
    }

    public Cylinder(int axisSamples, int radialSamples, float radius, float radius2, float height2, boolean closed, boolean inverted) {
        this.updateGeometry(axisSamples, radialSamples, radius, radius2, height2, closed, inverted);
    }

    public int getAxisSamples() {
        return this.axisSamples;
    }

    public float getHeight() {
        return this.height;
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getRadius2() {
        return this.radius2;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void updateGeometry(int axisSamples, int radialSamples, float topRadius, float bottomRadius, float height2, boolean closed, boolean inverted) {
        if (axisSamples < 2 || radialSamples < 3 || topRadius <= 0.0f || bottomRadius <= 0.0f || height2 <= 0.0f) {
            throw new IllegalArgumentException("Cylinders must have at least 2 axis samples and 3 radial samples, and positive dimensions.");
        }
        this.axisSamples = axisSamples;
        this.radialSamples = radialSamples;
        this.radius = bottomRadius;
        this.radius2 = topRadius;
        this.height = height2;
        this.closed = closed;
        this.inverted = inverted;
        int verticesCount = axisSamples * (radialSamples + 1);
        int trianglesCount = axisSamples * radialSamples * 2;
        if (closed) {
            verticesCount += 2 + 2 * (radialSamples + 1);
            trianglesCount += 2 * radialSamples;
        }
        float[][] circlePoints = new float[radialSamples + 1][2];
        for (int circlePoint = 0; circlePoint < radialSamples; ++circlePoint) {
            float angle = (float)Math.PI * 2 / (float)radialSamples * (float)circlePoint;
            circlePoints[circlePoint][0] = FastMath.cos(angle);
            circlePoints[circlePoint][1] = FastMath.sin(angle);
        }
        circlePoints[radialSamples][0] = circlePoints[0][0];
        circlePoints[radialSamples][1] = circlePoints[0][1];
        Vector3f[] circleNormals = new Vector3f[radialSamples + 1];
        for (int circlePoint = 0; circlePoint < radialSamples + 1; ++circlePoint) {
            Vector3f normal = new Vector3f(height2 * circlePoints[circlePoint][0], height2 * circlePoints[circlePoint][1], bottomRadius - topRadius);
            circleNormals[circlePoint] = normal.normalizeLocal();
        }
        float[] vertices = new float[verticesCount * 3];
        float[] normals = new float[verticesCount * 3];
        float[] textureCoords = new float[verticesCount * 2];
        int currentIndex = 0;
        for (int axisSample = 0; axisSample < axisSamples; ++axisSample) {
            float currentHeight = -height2 / 2.0f + height2 * (float)axisSample / (float)(axisSamples - 1);
            float currentRadius = bottomRadius + (topRadius - bottomRadius) * (float)axisSample / (float)(axisSamples - 1);
            for (int circlePoint = 0; circlePoint < radialSamples + 1; ++circlePoint) {
                vertices[currentIndex * 3] = circlePoints[circlePoint][0] * currentRadius;
                vertices[currentIndex * 3 + 1] = circlePoints[circlePoint][1] * currentRadius;
                vertices[currentIndex * 3 + 2] = currentHeight;
                Vector3f currentNormal = circleNormals[circlePoint];
                normals[currentIndex * 3] = currentNormal.x;
                normals[currentIndex * 3 + 1] = currentNormal.y;
                normals[currentIndex * 3 + 2] = currentNormal.z;
                textureCoords[currentIndex * 2] = (float)circlePoint / (float)radialSamples;
                textureCoords[currentIndex * 2 + 1] = closed ? (bottomRadius + height2 / 2.0f + currentHeight) / (bottomRadius + height2 + topRadius) : height2 / 2.0f + currentHeight;
                ++currentIndex;
            }
        }
        if (closed) {
            int circlePoint;
            for (circlePoint = 0; circlePoint < radialSamples + 1; ++circlePoint) {
                vertices[currentIndex * 3] = circlePoints[circlePoint][0] * bottomRadius;
                vertices[currentIndex * 3 + 1] = circlePoints[circlePoint][1] * bottomRadius;
                vertices[currentIndex * 3 + 2] = -height2 / 2.0f;
                normals[currentIndex * 3] = 0.0f;
                normals[currentIndex * 3 + 1] = 0.0f;
                normals[currentIndex * 3 + 2] = -1.0f;
                textureCoords[currentIndex * 2] = (float)circlePoint / (float)radialSamples;
                textureCoords[currentIndex * 2 + 1] = bottomRadius / (bottomRadius + height2 + topRadius);
                ++currentIndex;
            }
            for (circlePoint = 0; circlePoint < radialSamples + 1; ++circlePoint) {
                vertices[currentIndex * 3] = circlePoints[circlePoint][0] * topRadius;
                vertices[currentIndex * 3 + 1] = circlePoints[circlePoint][1] * topRadius;
                vertices[currentIndex * 3 + 2] = height2 / 2.0f;
                normals[currentIndex * 3] = 0.0f;
                normals[currentIndex * 3 + 1] = 0.0f;
                normals[currentIndex * 3 + 2] = 1.0f;
                textureCoords[currentIndex * 2] = (float)circlePoint / (float)radialSamples;
                textureCoords[currentIndex * 2 + 1] = (bottomRadius + height2) / (bottomRadius + height2 + topRadius);
                ++currentIndex;
            }
            vertices[currentIndex * 3] = 0.0f;
            vertices[currentIndex * 3 + 1] = 0.0f;
            vertices[currentIndex * 3 + 2] = -height2 / 2.0f;
            normals[currentIndex * 3] = 0.0f;
            normals[currentIndex * 3 + 1] = 0.0f;
            normals[currentIndex * 3 + 2] = -1.0f;
            textureCoords[currentIndex * 2] = 0.5f;
            textureCoords[currentIndex * 2 + 1] = 0.0f;
            vertices[++currentIndex * 3] = 0.0f;
            vertices[currentIndex * 3 + 1] = 0.0f;
            vertices[currentIndex * 3 + 2] = height2 / 2.0f;
            normals[currentIndex * 3] = 0.0f;
            normals[currentIndex * 3 + 1] = 0.0f;
            normals[currentIndex * 3 + 2] = 1.0f;
            textureCoords[currentIndex * 2] = 0.5f;
            textureCoords[currentIndex * 2 + 1] = 1.0f;
        }
        short[] indices = new short[trianglesCount * 3];
        currentIndex = 0;
        for (int axisSample = 0; axisSample < axisSamples - 1; axisSample = (int)((short)(axisSample + 1))) {
            for (int circlePoint = 0; circlePoint < radialSamples; ++circlePoint) {
                indices[currentIndex++] = (short)(axisSample * (radialSamples + 1) + circlePoint);
                indices[currentIndex++] = (short)(axisSample * (radialSamples + 1) + circlePoint + 1);
                indices[currentIndex++] = (short)((axisSample + 1) * (radialSamples + 1) + circlePoint);
                indices[currentIndex++] = (short)((axisSample + 1) * (radialSamples + 1) + circlePoint);
                indices[currentIndex++] = (short)(axisSample * (radialSamples + 1) + circlePoint + 1);
                indices[currentIndex++] = (short)((axisSample + 1) * (radialSamples + 1) + circlePoint + 1);
            }
        }
        if (closed) {
            short bottomCapIndex = (short)(verticesCount - 2);
            short topCapIndex = (short)(verticesCount - 1);
            int bottomRowOffset = axisSamples * (radialSamples + 1);
            int topRowOffset = (axisSamples + 1) * (radialSamples + 1);
            for (int circlePoint = 0; circlePoint < radialSamples; ++circlePoint) {
                indices[currentIndex++] = (short)(bottomRowOffset + circlePoint + 1);
                indices[currentIndex++] = (short)(bottomRowOffset + circlePoint);
                indices[currentIndex++] = bottomCapIndex;
                indices[currentIndex++] = (short)(topRowOffset + circlePoint);
                indices[currentIndex++] = (short)(topRowOffset + circlePoint + 1);
                indices[currentIndex++] = topCapIndex;
            }
        }
        if (inverted) {
            int i;
            for (i = 0; i < indices.length / 2; ++i) {
                short temp = indices[i];
                indices[i] = indices[indices.length - 1 - i];
                indices[indices.length - 1 - i] = temp;
            }
            for (i = 0; i < normals.length; ++i) {
                normals[i] = -normals[i];
            }
        }
        this.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer(vertices));
        this.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer(normals));
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer(textureCoords));
        this.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createShortBuffer(indices));
        this.updateBound();
        this.setStatic();
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.axisSamples = capsule.readInt("axisSamples", 0);
        this.radialSamples = capsule.readInt("radialSamples", 0);
        this.radius = capsule.readFloat("radius", 0.0f);
        this.radius2 = capsule.readFloat("radius2", 0.0f);
        this.height = capsule.readFloat("height", 0.0f);
        this.closed = capsule.readBoolean("closed", false);
        this.inverted = capsule.readBoolean("inverted", false);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.axisSamples, "axisSamples", 0);
        capsule.write(this.radialSamples, "radialSamples", 0);
        capsule.write(this.radius, "radius", 0.0f);
        capsule.write(this.radius2, "radius2", 0.0f);
        capsule.write(this.height, "height", 0.0f);
        capsule.write(this.closed, "closed", false);
        capsule.write(this.inverted, "inverted", false);
    }
}

