/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.mesh;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.scene.mesh.VirtualIndexBuffer;
import java.nio.Buffer;

public class WrappedIndexBuffer
extends VirtualIndexBuffer {
    private final IndexBuffer ib;

    public WrappedIndexBuffer(Mesh mesh) {
        super(mesh.getVertexCount(), mesh.getMode());
        this.ib = mesh.getIndexBuffer();
        switch (this.meshMode) {
            case Points: {
                this.numIndices = mesh.getTriangleCount();
                break;
            }
            case Lines: 
            case LineLoop: 
            case LineStrip: {
                this.numIndices = mesh.getTriangleCount() * 2;
                break;
            }
            case Triangles: 
            case TriangleStrip: 
            case TriangleFan: {
                this.numIndices = mesh.getTriangleCount() * 3;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public int get(int i) {
        int superIdx = super.get(i);
        return this.ib.get(superIdx);
    }

    @Override
    public Buffer getBuffer() {
        return this.ib.getBuffer();
    }

    public static void convertToList(Mesh mesh) {
        IndexBuffer inBuf = mesh.getIndicesAsList();
        IndexBuffer outBuf = IndexBuffer.createIndexBuffer(mesh.getVertexCount(), inBuf.size());
        for (int i = 0; i < inBuf.size(); ++i) {
            outBuf.put(i, inBuf.get(i));
        }
        mesh.clearBuffer(VertexBuffer.Type.Index);
        switch (mesh.getMode()) {
            case LineLoop: 
            case LineStrip: {
                mesh.setMode(Mesh.Mode.Lines);
                break;
            }
            case TriangleStrip: 
            case TriangleFan: {
                mesh.setMode(Mesh.Mode.Triangles);
                break;
            }
        }
        mesh.setBuffer(VertexBuffer.Type.Index, 3, outBuf.getFormat(), outBuf.getBuffer());
    }
}

