/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.mesh;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.VertexBuffer;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.EnumMap;
import java.util.Map;

public class MorphTarget
implements Savable {
    private final EnumMap<VertexBuffer.Type, FloatBuffer> buffers = new EnumMap(VertexBuffer.Type.class);
    private String name = null;

    public MorphTarget() {
    }

    public MorphTarget(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setBuffer(VertexBuffer.Type type2, FloatBuffer buffer) {
        this.buffers.put(type2, buffer);
    }

    public FloatBuffer getBuffer(VertexBuffer.Type type2) {
        return this.buffers.get((Object)type2);
    }

    public EnumMap<VertexBuffer.Type, FloatBuffer> getBuffers() {
        return this.buffers;
    }

    public int getNumBuffers() {
        return this.buffers.size();
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        for (Map.Entry<VertexBuffer.Type, FloatBuffer> entry : this.buffers.entrySet()) {
            FloatBuffer roData = entry.getValue().asReadOnlyBuffer();
            oc.write(roData, entry.getKey().name(), null);
        }
        oc.write(this.name, "morphName", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        for (VertexBuffer.Type type2 : VertexBuffer.Type.values()) {
            FloatBuffer b = ic.readFloatBuffer(type2.name(), null);
            if (b == null) continue;
            this.setBuffer(type2, b);
        }
        this.name = ic.readString("morphName", null);
    }
}

