/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug.custom;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.nio.FloatBuffer;

public class ArmatureInterJointsWire
extends Mesh {
    private final Vector3f tmp = new Vector3f();

    public ArmatureInterJointsWire(Vector3f start2, Vector3f[] ends) {
        this.setMode(Mesh.Mode.Lines);
        this.updateGeometry(start2, ends);
    }

    protected ArmatureInterJointsWire() {
    }

    protected void updateGeometry(Vector3f start2, Vector3f[] ends) {
        int index2;
        float[] pos = new float[ends.length * 3 + 3];
        pos[0] = start2.x;
        pos[1] = start2.y;
        pos[2] = start2.z;
        for (int i = 0; i < ends.length; ++i) {
            index2 = i * 3 + 3;
            pos[index2] = ends[i].x;
            pos[index2 + 1] = ends[i].y;
            pos[index2 + 2] = ends[i].z;
        }
        this.setBuffer(VertexBuffer.Type.Position, 3, pos);
        float[] texCoord = new float[ends.length * 2 + 2];
        texCoord[0] = 0.0f;
        texCoord[1] = 0.0f;
        for (int i = 0; i < ends.length * 2; ++i) {
            texCoord[i + 2] = this.tmp.set(start2).subtractLocal(ends[i / 2]).length();
        }
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, texCoord);
        float[] normal = new float[ends.length * 3 + 3];
        for (int i = 0; i < ends.length * 3 + 3; i += 3) {
            normal[i] = start2.x;
            normal[i + 1] = start2.y;
            normal[i + 2] = start2.z;
        }
        this.setBuffer(VertexBuffer.Type.Normal, 3, normal);
        short[] id = new short[ends.length * 2];
        index2 = 1;
        for (int i = 0; i < ends.length * 2; i += 2) {
            id[i] = 0;
            id[i + 1] = (short)index2;
            ++index2;
        }
        this.setBuffer(VertexBuffer.Type.Index, 2, id);
        this.updateBound();
    }

    public void updatePoints(Vector3f start2, Vector3f[] ends) {
        VertexBuffer posBuf = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fb = (FloatBuffer)posBuf.getData();
        fb.rewind();
        fb.put(start2.x).put(start2.y).put(start2.z);
        for (int i = 0; i < ends.length; ++i) {
            fb.put(ends[i].x);
            fb.put(ends[i].y);
            fb.put(ends[i].z);
        }
        posBuf.updateData(fb);
        VertexBuffer normBuf = this.getBuffer(VertexBuffer.Type.Normal);
        fb = (FloatBuffer)normBuf.getData();
        fb.rewind();
        for (int i = 0; i < ends.length * 3 + 3; i += 3) {
            fb.put(start2.x);
            fb.put(start2.y);
            fb.put(start2.z);
        }
        normBuf.updateData(fb);
    }
}

