/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug.custom;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.collision.CollisionResults;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.light.DirectionalLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.custom.ArmatureDebugger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArmatureDebugAppState
extends BaseAppState {
    public static final float CLICK_MAX_DELAY = 0.2f;
    private Node debugNode = new Node("debugNode");
    private Map<Armature, ArmatureDebugger> armatures = new HashMap<Armature, ArmatureDebugger>();
    private Map<Armature, Joint> selectedBones = new HashMap<Armature, Joint>();
    private Application app;
    private boolean displayAllJoints = false;
    private float clickDelay = -1.0f;
    Vector3f tmp = new Vector3f();
    Vector3f tmp2 = new Vector3f();
    ViewPort vp;
    private final ActionListener actionListener = new ActionListener(){

        @Override
        public void onAction(String name, boolean isPressed, float tpf) {
            if (name.equals("shoot") && isPressed) {
                ArmatureDebugAppState.this.clickDelay = 0.0f;
            }
            if (name.equals("shoot") && !isPressed && ArmatureDebugAppState.this.clickDelay < 0.2f) {
                Vector2f click2d = ArmatureDebugAppState.this.app.getInputManager().getCursorPosition();
                CollisionResults results = new CollisionResults();
                Camera camera = ArmatureDebugAppState.this.app.getCamera();
                Vector3f click3d = camera.getWorldCoordinates(click2d, 0.0f, ArmatureDebugAppState.this.tmp);
                Vector3f dir = camera.getWorldCoordinates(click2d, 1.0f, ArmatureDebugAppState.this.tmp2).subtractLocal(click3d).normalizeLocal();
                Ray ray = new Ray(click3d, dir);
                ArmatureDebugAppState.this.debugNode.collideWith(ray, results);
                if (results.size() == 0) {
                    for (ArmatureDebugger ad : ArmatureDebugAppState.this.armatures.values()) {
                        ad.select(null);
                    }
                    return;
                }
                Geometry target = results.getClosestCollision().getGeometry();
                for (ArmatureDebugger ad : ArmatureDebugAppState.this.armatures.values()) {
                    Joint selectedjoint = ad.select(target);
                    if (selectedjoint == null) continue;
                    ArmatureDebugAppState.this.selectedBones.put(ad.getArmature(), selectedjoint);
                    System.err.println("-----------------------");
                    System.err.println("Selected Joint : " + selectedjoint.getName() + " in armature " + ad.getName());
                    System.err.println("Root Bone : " + (selectedjoint.getParent() == null));
                    System.err.println("-----------------------");
                    System.err.println("Local translation: " + selectedjoint.getLocalTranslation());
                    System.err.println("Local rotation: " + selectedjoint.getLocalRotation());
                    System.err.println("Local scale: " + selectedjoint.getLocalScale());
                    System.err.println("---");
                    System.err.println("Model translation: " + selectedjoint.getModelTransform().getTranslation());
                    System.err.println("Model rotation: " + selectedjoint.getModelTransform().getRotation());
                    System.err.println("Model scale: " + selectedjoint.getModelTransform().getScale());
                    System.err.println("---");
                    System.err.println("Bind inverse Transform: ");
                    System.err.println(selectedjoint.getInverseModelBindMatrix());
                    return;
                }
            }
            if (name.equals("toggleJoints") && isPressed) {
                ArmatureDebugAppState.this.displayAllJoints = !ArmatureDebugAppState.this.displayAllJoints;
                for (ArmatureDebugger ad : ArmatureDebugAppState.this.armatures.values()) {
                    ad.displayNonDeformingJoint(ArmatureDebugAppState.this.displayAllJoints);
                }
            }
        }
    };

    @Override
    protected void initialize(Application app) {
        this.vp = app.getRenderManager().createMainView("debug", app.getCamera());
        this.vp.attachScene(this.debugNode);
        this.vp.setClearDepth(true);
        this.app = app;
        for (ArmatureDebugger armatureDebugger : this.armatures.values()) {
            armatureDebugger.initialize(app.getAssetManager(), app.getCamera());
        }
        app.getInputManager().addListener(this.actionListener, "shoot", "toggleJoints");
        app.getInputManager().addMapping("shoot", new MouseButtonTrigger(0), new MouseButtonTrigger(1));
        app.getInputManager().addMapping("toggleJoints", new KeyTrigger(68));
        this.debugNode.addLight(new DirectionalLight(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal()));
        this.debugNode.addLight(new DirectionalLight(new Vector3f(1.0f, 1.0f, 1.0f).normalizeLocal(), new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f)));
        this.vp.setEnabled(false);
    }

    @Override
    protected void cleanup(Application app) {
    }

    @Override
    protected void onEnable() {
        this.vp.setEnabled(true);
    }

    @Override
    protected void onDisable() {
        this.vp.setEnabled(false);
    }

    @Override
    public void update(float tpf) {
        if (this.clickDelay > -1.0f) {
            this.clickDelay += tpf;
        }
        this.debugNode.updateLogicalState(tpf);
        this.debugNode.updateGeometricState();
    }

    public ArmatureDebugger addArmatureFrom(SkinningControl skinningControl) {
        Armature armature = skinningControl.getArmature();
        Spatial forSpatial = skinningControl.getSpatial();
        return this.addArmatureFrom(armature, forSpatial);
    }

    public ArmatureDebugger addArmatureFrom(Armature armature, Spatial forSpatial) {
        ArmatureDebugger ad = this.armatures.get(armature);
        if (ad != null) {
            return ad;
        }
        JointInfoVisitor visitor2 = new JointInfoVisitor(armature);
        forSpatial.depthFirstTraversal(visitor2);
        ad = new ArmatureDebugger(forSpatial.getName() + "_Armature", armature, visitor2.deformingJoints);
        ad.setLocalTransform(forSpatial.getWorldTransform());
        if (forSpatial instanceof Node) {
            ArrayList<Geometry> geoms = new ArrayList<Geometry>();
            this.findGeoms((Node)forSpatial, geoms);
            if (geoms.size() == 1) {
                ad.setLocalTransform(((Geometry)geoms.get(0)).getWorldTransform());
            }
        }
        this.armatures.put(armature, ad);
        this.debugNode.attachChild(ad);
        if (this.isInitialized()) {
            ad.initialize(this.app.getAssetManager(), this.app.getCamera());
        }
        return ad;
    }

    private void findGeoms(Node node2, List<Geometry> geoms) {
        for (Spatial spatial : node2.getChildren()) {
            if (spatial instanceof Geometry) {
                geoms.add((Geometry)spatial);
                continue;
            }
            if (!(spatial instanceof Node)) continue;
            this.findGeoms((Node)spatial, geoms);
        }
    }

    public Node getDebugNode() {
        return this.debugNode;
    }

    public void setDebugNode(Node debugNode) {
        this.debugNode = debugNode;
    }

    private class JointInfoVisitor
    extends SceneGraphVisitorAdapter {
        List<Joint> deformingJoints = new ArrayList<Joint>();
        Armature armature;

        public JointInfoVisitor(Armature armature) {
            this.armature = armature;
        }

        @Override
        public void visit(Geometry g) {
            for (Joint joint : this.armature.getJointList()) {
                if (!g.getMesh().isAnimatedByJoint(this.armature.getJointIndex(joint))) continue;
                this.deformingJoints.add(joint);
            }
        }
    }
}

