/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.material.Material;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Node
extends Spatial {
    private static final Logger logger = Logger.getLogger(Node.class.getName());
    protected SafeArrayList<Spatial> children = new SafeArrayList<Spatial>(Spatial.class);
    private SafeArrayList<Spatial> updateList = null;
    private boolean updateListValid = false;

    public Node() {
        this(null);
    }

    public Node(String name) {
        super(name);
        this.setRequiresUpdates(Node.class != this.getClass());
    }

    public int getQuantity() {
        return this.children.size();
    }

    @Override
    protected void setTransformRefresh() {
        super.setTransformRefresh();
        for (Spatial child2 : this.children.getArray()) {
            if ((child2.refreshFlags & 1) != 0) continue;
            child2.setTransformRefresh();
        }
    }

    @Override
    protected void setLightListRefresh() {
        super.setLightListRefresh();
        for (Spatial child2 : this.children.getArray()) {
            if ((child2.refreshFlags & 4) != 0) continue;
            child2.setLightListRefresh();
        }
    }

    @Override
    protected void setMatParamOverrideRefresh() {
        super.setMatParamOverrideRefresh();
        for (Spatial child2 : this.children.getArray()) {
            if ((child2.refreshFlags & 0x10) != 0) continue;
            child2.setMatParamOverrideRefresh();
        }
    }

    @Override
    protected void updateWorldBound() {
        super.updateWorldBound();
        BoundingVolume resultBound = null;
        for (Spatial child2 : this.children.getArray()) {
            assert ((child2.refreshFlags & 2) == 0);
            if (resultBound != null) {
                ((BoundingVolume)resultBound).mergeLocal(child2.getWorldBound());
                continue;
            }
            if (child2.getWorldBound() == null) continue;
            resultBound = child2.getWorldBound().clone(this.worldBound);
        }
        if (resultBound == null) {
            resultBound = new BoundingBox(this.getWorldTranslation(), 0.0f, 0.0f, 0.0f);
        }
        this.worldBound = resultBound;
    }

    @Override
    protected void setParent(Node parent2) {
        if (this.parent == null && parent2 != null) {
            this.updateList = null;
            this.updateListValid = false;
        }
        super.setParent(parent2);
    }

    private void addUpdateChildren(SafeArrayList<Spatial> results) {
        for (Spatial child2 : this.children.getArray()) {
            if (child2.requiresUpdates()) {
                results.add(child2);
            }
            if (!(child2 instanceof Node)) continue;
            ((Node)child2).addUpdateChildren(results);
        }
    }

    void invalidateUpdateList() {
        this.updateListValid = false;
        if (this.parent != null) {
            this.parent.invalidateUpdateList();
        }
    }

    private SafeArrayList<Spatial> getUpdateList() {
        if (this.updateListValid) {
            return this.updateList;
        }
        if (this.updateList == null) {
            this.updateList = new SafeArrayList<Spatial>(Spatial.class);
        } else {
            this.updateList.clear();
        }
        this.addUpdateChildren(this.updateList);
        this.updateListValid = true;
        return this.updateList;
    }

    @Override
    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.parent != null) {
            return;
        }
        for (Spatial s : this.getUpdateList().getArray()) {
            s.updateLogicalState(tpf);
        }
    }

    @Override
    public void updateGeometricState() {
        if (this.refreshFlags == 0) {
            return;
        }
        if ((this.refreshFlags & 4) != 0) {
            this.updateWorldLightList();
        }
        if ((this.refreshFlags & 1) != 0) {
            this.updateWorldTransforms();
        }
        if ((this.refreshFlags & 0x10) != 0) {
            this.updateMatParamOverrides();
        }
        this.refreshFlags &= 0xFFFFFFF7;
        if (!this.children.isEmpty()) {
            for (Spatial child2 : this.children.getArray()) {
                child2.updateGeometricState();
            }
        }
        if ((this.refreshFlags & 2) != 0) {
            this.updateWorldBound();
        }
        assert (this.refreshFlags == 0);
    }

    @Override
    public int getTriangleCount() {
        int count2 = 0;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                count2 += this.children.get(i).getTriangleCount();
            }
        }
        return count2;
    }

    @Override
    public int getVertexCount() {
        int count2 = 0;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                count2 += this.children.get(i).getVertexCount();
            }
        }
        return count2;
    }

    public int attachChild(Spatial child2) {
        return this.attachChildAt(child2, this.children.size());
    }

    public int attachChildAt(Spatial child2, int index2) {
        if (child2 == null) {
            throw new IllegalArgumentException("child cannot be null");
        }
        if (child2 == this) {
            throw new IllegalArgumentException("Cannot add child to itself");
        }
        if (child2.getParent() != this) {
            if (child2.getParent() != null) {
                child2.getParent().detachChild(child2);
            }
            child2.setParent(this);
            this.children.add(index2, child2);
            child2.setTransformRefresh();
            child2.setLightListRefresh();
            child2.setMatParamOverrideRefresh();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Child ({0}) attached to this node ({1})", new Object[]{child2.getName(), this.getName()});
            }
            this.invalidateUpdateList();
        }
        return this.children.size();
    }

    public int detachChild(Spatial child2) {
        if (child2 == null) {
            throw new IllegalArgumentException("child cannot be null");
        }
        if (child2.getParent() == this) {
            int index2 = this.children.indexOf(child2);
            if (index2 != -1) {
                this.detachChildAt(index2);
            }
            return index2;
        }
        return -1;
    }

    public int detachChildNamed(String childName) {
        if (childName == null) {
            throw new IllegalArgumentException("childName cannot be null");
        }
        int max = this.children.size();
        for (int x2 = 0; x2 < max; ++x2) {
            Spatial child2 = this.children.get(x2);
            if (!childName.equals(child2.getName())) continue;
            this.detachChildAt(x2);
            return x2;
        }
        return -1;
    }

    public Spatial detachChildAt(int index2) {
        Spatial child2 = this.children.remove(index2);
        if (child2 != null) {
            child2.setParent(null);
            logger.log(Level.FINE, "{0}: Child removed.", this);
            this.setBoundRefresh();
            child2.setTransformRefresh();
            child2.setLightListRefresh();
            child2.setMatParamOverrideRefresh();
            this.invalidateUpdateList();
        }
        return child2;
    }

    public void detachAllChildren() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.detachChildAt(i);
        }
        logger.log(Level.FINE, "{0}: All children removed.", this);
    }

    public int getChildIndex(Spatial sp) {
        return this.children.indexOf(sp);
    }

    public void swapChildren(int index1, int index2) {
        Spatial c2 = this.children.get(index2);
        Spatial c1 = this.children.remove(index1);
        this.children.add(index1, c2);
        this.children.remove(index2);
        this.children.add(index2, c1);
    }

    public Spatial getChild(int i) {
        return this.children.get(i);
    }

    public Spatial getChild(String name) {
        if (name == null) {
            return null;
        }
        for (Spatial child2 : this.children.getArray()) {
            Spatial out;
            if (name.equals(child2.getName())) {
                return child2;
            }
            if (!(child2 instanceof Node) || (out = ((Node)child2).getChild(name)) == null) continue;
            return out;
        }
        return null;
    }

    public boolean hasChild(Spatial spat) {
        if (this.children.contains(spat)) {
            return true;
        }
        for (Spatial child2 : this.children.getArray()) {
            if (!(child2 instanceof Node) || !((Node)child2).hasChild(spat)) continue;
            return true;
        }
        return false;
    }

    public List<Spatial> getChildren() {
        return this.children;
    }

    @Override
    public void setMaterial(Material mat) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).setMaterial(mat);
        }
    }

    @Override
    public void setLodLevel(int lod) {
        super.setLodLevel(lod);
        for (Spatial child2 : this.children.getArray()) {
            child2.setLodLevel(lod);
        }
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) {
        int total = 0;
        for (Spatial child2 : this.children.getArray()) {
            total += child2.collideWith(other, results);
        }
        return total;
    }

    public <T extends Spatial> List<T> descendantMatches(Class<T> spatialSubclass, String nameRegex) {
        ArrayList<Spatial> newList = new ArrayList<Spatial>();
        if (this.getQuantity() < 1) {
            return newList;
        }
        for (Spatial child2 : this.getChildren()) {
            if (child2.matches(spatialSubclass, nameRegex)) {
                newList.add(child2);
            }
            if (!(child2 instanceof Node)) continue;
            newList.addAll(((Node)child2).descendantMatches(spatialSubclass, nameRegex));
        }
        return newList;
    }

    public <T extends Spatial> List<T> descendantMatches(Class<T> spatialSubclass) {
        return this.descendantMatches(spatialSubclass, null);
    }

    public <T extends Spatial> List<T> descendantMatches(String nameRegex) {
        return this.descendantMatches(null, nameRegex);
    }

    @Override
    public Node clone(boolean cloneMaterials) {
        Node nodeClone = (Node)super.clone(cloneMaterials);
        nodeClone.updateList = null;
        nodeClone.updateListValid = false;
        return nodeClone;
    }

    @Override
    public Spatial deepClone() {
        Node nodeClone = (Node)super.deepClone();
        nodeClone.updateList = null;
        nodeClone.updateListValid = false;
        return nodeClone;
    }

    public Spatial oldDeepClone() {
        Node nodeClone = (Node)super.clone();
        nodeClone.children = new SafeArrayList<Spatial>(Spatial.class);
        for (Spatial child2 : this.children) {
            Spatial childClone = child2.deepClone();
            childClone.parent = nodeClone;
            nodeClone.children.add(childClone);
        }
        return nodeClone;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.children = cloner.clone(this.children);
        this.updateList = cloner.clone(this.updateList);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        e.getCapsule(this).writeSavableArrayList(new ArrayList<Spatial>(this.children), "children", null);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        this.children = new SafeArrayList<Spatial>(Spatial.class, importer.getCapsule(this).readSavableArrayList("children", null));
        if (this.children != null) {
            for (Spatial child2 : this.children.getArray()) {
                child2.parent = this;
            }
        }
        super.read(importer);
    }

    @Override
    public void setModelBound(BoundingVolume modelBound) {
        if (this.children != null) {
            for (Spatial child2 : this.children.getArray()) {
                child2.setModelBound(modelBound != null ? modelBound.clone(null) : null);
            }
        }
    }

    @Override
    public void updateModelBound() {
        if (this.children != null) {
            for (Spatial child2 : this.children.getArray()) {
                child2.updateModelBound();
            }
        }
    }

    @Override
    public void depthFirstTraversal(SceneGraphVisitor visitor2, Spatial.DFSMode mode) {
        if (mode == Spatial.DFSMode.POST_ORDER) {
            for (Spatial child2 : this.children.getArray()) {
                child2.depthFirstTraversal(visitor2, mode);
            }
            visitor2.visit(this);
        } else {
            visitor2.visit(this);
            for (Spatial child3 : this.children.getArray()) {
                child3.depthFirstTraversal(visitor2, mode);
            }
        }
    }

    @Override
    protected void breadthFirstTraversal(SceneGraphVisitor visitor2, Queue<Spatial> queue) {
        queue.addAll(this.children);
    }
}

