/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.asset.AssetNotFoundException;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.renderer.Camera;
import com.jme3.scene.GeometryGroupNode;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.MorphTarget;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.IdentityCloneFunction;
import java.io.IOException;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Geometry
extends Spatial {
    public static final int SAVABLE_VERSION = 1;
    private static final Logger logger = Logger.getLogger(Geometry.class.getName());
    protected Mesh mesh;
    protected transient int lodLevel = 0;
    protected Material material;
    protected boolean ignoreTransform = false;
    protected transient Matrix4f cachedWorldMat = new Matrix4f();
    protected GeometryGroupNode groupNode;
    protected int startIndex = -1;
    private float[] morphState;
    private boolean dirtyMorph = true;
    private MorphTarget fallbackMorphTarget;
    private int nbSimultaneousGPUMorph = -1;

    public Geometry() {
        this(null);
    }

    public Geometry(String name) {
        super(name);
        this.setRequiresUpdates(Geometry.class != this.getClass());
    }

    public Geometry(String name, Mesh mesh) {
        this(name);
        if (mesh == null) {
            throw new IllegalArgumentException("mesh cannot be null");
        }
        this.mesh = mesh;
    }

    @Override
    public boolean checkCulling(Camera cam) {
        if (this.isGrouped()) {
            this.setLastFrustumIntersection(Camera.FrustumIntersect.Outside);
            return false;
        }
        return super.checkCulling(cam);
    }

    public boolean isIgnoreTransform() {
        return this.ignoreTransform;
    }

    public void setIgnoreTransform(boolean ignoreTransform) {
        this.ignoreTransform = ignoreTransform;
    }

    @Override
    public void setLodLevel(int lod) {
        if (this.mesh.getNumLodLevels() == 0) {
            throw new IllegalStateException("LOD levels are not set on this mesh");
        }
        if (lod < 0 || lod >= this.mesh.getNumLodLevels()) {
            throw new IllegalArgumentException("LOD level is out of range: " + lod);
        }
        this.lodLevel = lod;
        if (this.isGrouped()) {
            this.groupNode.onMeshChange(this);
        }
    }

    public int getLodLevel() {
        return this.lodLevel;
    }

    @Override
    public int getVertexCount() {
        return this.mesh.getVertexCount();
    }

    @Override
    public int getTriangleCount() {
        return this.mesh.getTriangleCount();
    }

    public void setMesh(Mesh mesh) {
        if (mesh == null) {
            throw new IllegalArgumentException();
        }
        this.mesh = mesh;
        this.setBoundRefresh();
        if (this.isGrouped()) {
            this.groupNode.onMeshChange(this);
        }
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    @Override
    public void setMaterial(Material material) {
        this.material = material;
        this.nbSimultaneousGPUMorph = -1;
        if (this.isGrouped()) {
            this.groupNode.onMaterialChange(this);
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public BoundingVolume getModelBound() {
        return this.mesh.getBound();
    }

    @Override
    public void updateModelBound() {
        this.mesh.updateBound();
        this.setBoundRefresh();
    }

    @Override
    protected void updateWorldBound() {
        super.updateWorldBound();
        if (this.mesh == null) {
            throw new IllegalStateException("Geometry \"" + this.getName() + "\" has null mesh.");
        }
        if (this.mesh.getBound() != null) {
            this.worldBound = this.ignoreTransform ? this.mesh.getBound().clone(this.worldBound) : this.mesh.getBound().transform(this.worldTransform, this.worldBound);
        }
    }

    @Override
    protected void updateWorldTransforms() {
        super.updateWorldTransforms();
        this.computeWorldMatrix();
        if (this.isGrouped()) {
            this.groupNode.onTransformChange(this);
        }
        this.worldLights.sort(true);
    }

    @Override
    protected void updateWorldLightList() {
        super.updateWorldLightList();
        this.worldLights.sort(true);
    }

    public void associateWithGroupNode(GeometryGroupNode node2, int startIndex) {
        if (this.isGrouped()) {
            this.unassociateFromGroupNode();
        }
        this.groupNode = node2;
        this.startIndex = startIndex;
    }

    public void unassociateFromGroupNode() {
        if (this.groupNode != null) {
            this.groupNode.onGeometryUnassociated(this);
            this.groupNode = null;
            this.startIndex = -1;
        }
    }

    @Override
    public boolean removeFromParent() {
        return super.removeFromParent();
    }

    @Override
    protected void setParent(Node parent2) {
        super.setParent(parent2);
        if (parent2 == null && this.isGrouped()) {
            this.unassociateFromGroupNode();
        }
    }

    public void computeWorldMatrix() {
        this.checkDoTransformUpdate();
        this.cachedWorldMat.loadIdentity();
        if (this.ignoreTransform) {
            return;
        }
        this.cachedWorldMat.setRotationQuaternion(this.worldTransform.getRotation());
        this.cachedWorldMat.setTranslation(this.worldTransform.getTranslation());
        TempVars vars = TempVars.get();
        Matrix4f scaleMat = vars.tempMat4;
        scaleMat.loadIdentity();
        scaleMat.scale(this.worldTransform.getScale());
        this.cachedWorldMat.multLocal(scaleMat);
        vars.release();
    }

    public Matrix4f getWorldMatrix() {
        return this.cachedWorldMat;
    }

    @Override
    public void setModelBound(BoundingVolume modelBound) {
        this.worldBound = null;
        this.mesh.setBound(modelBound);
        this.setBoundRefresh();
    }

    @Override
    public int collideWith(Collidable other, CollisionResults results) {
        this.checkDoBoundUpdate();
        this.computeWorldMatrix();
        assert ((this.refreshFlags & 3) == 0);
        if (this.mesh != null) {
            int prevSize = results.size();
            int added = this.mesh.collideWith(other, this.cachedWorldMat, this.worldBound, results);
            int newSize = results.size();
            for (int i = prevSize; i < newSize; ++i) {
                results.getCollisionDirect(i).setGeometry(this);
            }
            return added;
        }
        return 0;
    }

    @Override
    public void depthFirstTraversal(SceneGraphVisitor visitor2, Spatial.DFSMode mode) {
        visitor2.visit(this);
    }

    @Override
    protected void breadthFirstTraversal(SceneGraphVisitor visitor2, Queue<Spatial> queue) {
    }

    public boolean isGrouped() {
        return this.groupNode != null;
    }

    @Deprecated
    public boolean isBatched() {
        return this.isGrouped();
    }

    @Override
    public Geometry clone(boolean cloneMaterial) {
        return (Geometry)super.clone(cloneMaterial);
    }

    @Override
    public Geometry clone() {
        return this.clone(true);
    }

    @Override
    public Spatial deepClone() {
        return super.deepClone();
    }

    public Spatial oldDeepClone() {
        Geometry geomClone = this.clone(true);
        geomClone.mesh = this.mesh.deepClone();
        return geomClone;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        if (this.groupNode != null) {
            if (cloner.isCloned(this.groupNode)) {
                this.groupNode = cloner.clone(this.groupNode);
            } else {
                this.groupNode = null;
                this.startIndex = -1;
            }
        }
        this.cachedWorldMat = cloner.clone(this.cachedWorldMat);
        boolean shallowClone = cloner.getCloneFunction(Mesh.class) instanceof IdentityCloneFunction;
        this.mesh = shallowClone && this.mesh != null && this.mesh.getBuffer(VertexBuffer.Type.BindPosePosition) != null ? this.mesh.cloneForAnim() : cloner.clone(this.mesh);
        this.material = cloner.clone(this.material);
    }

    public void setMorphState(float[] state2) {
        if (this.mesh == null || this.mesh.getMorphTargets().length == 0) {
            return;
        }
        int nbMorphTargets = this.mesh.getMorphTargets().length;
        if (this.morphState == null) {
            this.morphState = new float[nbMorphTargets];
        }
        System.arraycopy(state2, 0, this.morphState, 0, this.morphState.length);
        this.dirtyMorph = true;
    }

    public void setMorphState(String morphTarget, float state2) {
        int index2 = this.mesh.getMorphIndex(morphTarget);
        if (index2 >= 0) {
            this.morphState[index2] = state2;
            this.dirtyMorph = true;
        }
    }

    public boolean isDirtyMorph() {
        return this.dirtyMorph;
    }

    public void setDirtyMorph(boolean dirtyMorph) {
        this.dirtyMorph = dirtyMorph;
    }

    public float[] getMorphState() {
        if (this.morphState == null) {
            this.morphState = new float[this.mesh.getMorphTargets().length];
        }
        return this.morphState;
    }

    public float getMorphState(String morphTarget) {
        int index2 = this.mesh.getMorphIndex(morphTarget);
        if (index2 < 0) {
            return -1.0f;
        }
        return this.morphState[index2];
    }

    public int getNbSimultaneousGPUMorph() {
        return this.nbSimultaneousGPUMorph;
    }

    public void setNbSimultaneousGPUMorph(int nbSimultaneousGPUMorph) {
        this.nbSimultaneousGPUMorph = nbSimultaneousGPUMorph;
    }

    public MorphTarget getFallbackMorphTarget() {
        return this.fallbackMorphTarget;
    }

    public void setFallbackMorphTarget(MorphTarget fallbackMorphTarget) {
        this.fallbackMorphTarget = fallbackMorphTarget;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.mesh, "mesh", null);
        if (this.material != null) {
            oc.write(this.material.getAssetName(), "materialName", null);
        }
        oc.write(this.material, "material", null);
        oc.write(this.ignoreTransform, "ignoreTransform", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        Mesh sharedMesh;
        InputCapsule ic;
        block5: {
            super.read(im);
            ic = im.getCapsule(this);
            this.mesh = (Mesh)ic.readSavable("mesh", null);
            this.material = null;
            String matName = ic.readString("materialName", null);
            if (matName != null) {
                try {
                    this.material = im.getAssetManager().loadMaterial(matName);
                }
                catch (AssetNotFoundException ex) {
                    if (!logger.isLoggable(Level.FINE)) break block5;
                    logger.log(Level.FINE, "Cannot locate {0} for geometry {1}", new Object[]{matName, this.key});
                }
            }
        }
        if (this.material == null) {
            this.material = (Material)ic.readSavable("material", null);
        }
        this.ignoreTransform = ic.readBoolean("ignoreTransform", false);
        if (ic.getSavableVersion(Geometry.class) == 0 && (sharedMesh = (Mesh)this.getUserData("JmeSharedMesh")) != null) {
            this.getMesh().extractVertexData(sharedMesh);
            this.setUserData("JmeSharedMesh", null);
        }
    }
}

