/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene;

import com.jme3.asset.AssetManager;
import com.jme3.asset.ModelKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AssetLinkNode
extends Node {
    protected ArrayList<ModelKey> assetLoaderKeys = new ArrayList();
    protected Map<ModelKey, Spatial> assetChildren = new HashMap<ModelKey, Spatial>();

    public AssetLinkNode() {
    }

    public AssetLinkNode(ModelKey key) {
        this(key.getName(), key);
    }

    public AssetLinkNode(String name, ModelKey key) {
        super(name);
        this.assetLoaderKeys.add(key);
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.assetLoaderKeys = cloner.clone(this.assetLoaderKeys);
        this.assetChildren = new HashMap<ModelKey, Spatial>();
    }

    public void addLinkedChild(ModelKey key) {
        if (this.assetLoaderKeys.contains(key)) {
            return;
        }
        this.assetLoaderKeys.add(key);
    }

    public void removeLinkedChild(ModelKey key) {
        this.assetLoaderKeys.remove(key);
    }

    public ArrayList<ModelKey> getAssetLoaderKeys() {
        return this.assetLoaderKeys;
    }

    public void attachLinkedChild(AssetManager manager, ModelKey key) {
        this.addLinkedChild(key);
        Spatial child2 = manager.loadAsset(key);
        this.assetChildren.put(key, child2);
        this.attachChild(child2);
    }

    public void attachLinkedChild(Spatial spat, ModelKey key) {
        this.addLinkedChild(key);
        this.assetChildren.put(key, spat);
        this.attachChild(spat);
    }

    public void detachLinkedChild(ModelKey key) {
        Spatial spatial = this.assetChildren.get(key);
        if (spatial != null) {
            this.detachChild(spatial);
        }
        this.removeLinkedChild(key);
        this.assetChildren.remove(key);
    }

    public void detachLinkedChild(Spatial child2, ModelKey key) {
        this.removeLinkedChild(key);
        this.assetChildren.remove(key);
        this.detachChild(child2);
    }

    public void attachLinkedChildren(AssetManager manager) {
        this.detachLinkedChildren();
        for (ModelKey assetKey : this.assetLoaderKeys) {
            Spatial curChild = this.assetChildren.get(assetKey);
            if (curChild != null) {
                curChild.removeFromParent();
            }
            Spatial child2 = manager.loadAsset(assetKey);
            this.attachChild(child2);
            this.assetChildren.put(assetKey, child2);
        }
    }

    public void detachLinkedChildren() {
        Set<Map.Entry<ModelKey, Spatial>> set = this.assetChildren.entrySet();
        Iterator<Map.Entry<ModelKey, Spatial>> it = set.iterator();
        while (it.hasNext()) {
            Map.Entry<ModelKey, Spatial> entry = it.next();
            entry.getValue().removeFromParent();
            it.remove();
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        AssetManager assetManager2 = importer.getAssetManager();
        this.assetLoaderKeys = capsule.readSavableArrayList("assetLoaderKeyList", new ArrayList());
        for (ModelKey modelKey : this.assetLoaderKeys) {
            Spatial child2 = assetManager2.loadAsset(modelKey);
            if (child2 != null) {
                child2.parent = this;
                this.children.add(child2);
                this.assetChildren.put(modelKey, child2);
                continue;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot locate {0} for asset link node {1}", new Object[]{modelKey, this.key});
        }
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        SafeArrayList childList = this.children;
        this.children = new SafeArrayList<Spatial>(Spatial.class);
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.writeSavableArrayList(this.assetLoaderKeys, "assetLoaderKeyList", null);
        this.children = childList;
    }
}

