/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.queue;

import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryComparator;
import com.jme3.scene.Geometry;
import com.jme3.util.ListSort;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GeometryList
implements Iterable<Geometry> {
    private static final int DEFAULT_SIZE = 32;
    private Geometry[] geometries = new Geometry[32];
    private final ListSort listSort;
    private int size = 0;
    private GeometryComparator comparator;

    public GeometryList(GeometryComparator comparator) {
        this.comparator = comparator;
        this.listSort = new ListSort();
    }

    public void setComparator(GeometryComparator comparator) {
        this.comparator = comparator;
    }

    public GeometryComparator getComparator() {
        return this.comparator;
    }

    public void setCamera(Camera cam) {
        this.comparator.setCamera(cam);
    }

    public int size() {
        return this.size;
    }

    public void set(int index2, Geometry value) {
        this.geometries[index2] = value;
    }

    public Geometry get(int index2) {
        return this.geometries[index2];
    }

    public void add(Geometry g) {
        if (this.size == this.geometries.length) {
            Geometry[] temp = new Geometry[this.size * 2];
            System.arraycopy(this.geometries, 0, temp, 0, this.size);
            this.geometries = temp;
        }
        this.geometries[this.size++] = g;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.geometries[i] = null;
        }
        this.size = 0;
    }

    public void sort() {
        if (this.size > 1) {
            if (this.listSort.getLength() != this.size) {
                this.listSort.allocateStack(this.size);
            }
            this.listSort.sort(this.geometries, this.comparator);
        }
    }

    @Override
    public Iterator<Geometry> iterator() {
        return new Iterator<Geometry>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < GeometryList.this.size();
            }

            @Override
            public Geometry next() {
                if (this.index >= GeometryList.this.size()) {
                    throw new NoSuchElementException("Geometry list has only " + GeometryList.this.size() + " elements");
                }
                return GeometryList.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Geometry list doesn't support iterator removal");
            }
        };
    }
}

