/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.opengl;

import com.jme3.renderer.opengl.GLTimingState;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public class GLTiming
implements InvocationHandler {
    private final Object obj;
    private final GLTimingState state;

    public GLTiming(Object obj, GLTimingState state2) {
        this.obj = obj;
        this.state = state2;
    }

    public static Object createGLTiming(Object glInterface, GLTimingState state2, Class<?> ... glInterfaceClasses) {
        return Proxy.newProxyInstance(glInterface.getClass().getClassLoader(), glInterfaceClasses, (InvocationHandler)new GLTiming(glInterface, state2));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("resetStats")) {
            if (this.state.lastPrintOutTime + 1000000000L <= System.nanoTime() && this.state.sampleCount > 0) {
                this.state.timeSpentInGL /= (long)this.state.sampleCount;
                System.out.println("--- TOTAL TIME SPENT IN GL CALLS: " + this.state.timeSpentInGL / 1000L + "us");
                Map.Entry[] callTimes = new Map.Entry[this.state.callTiming.size()];
                int i = 0;
                for (Map.Entry<String, Long> entry : this.state.callTiming.entrySet()) {
                    callTimes[i++] = entry;
                }
                Arrays.sort(callTimes, new CallTimingComparator());
                int limit = 10;
                for (Map.Entry callTime : callTimes) {
                    long val = (Long)callTime.getValue() / (long)this.state.sampleCount;
                    String name = (String)callTime.getKey();
                    String pad = "                                     ".substring(0, 30 - name.length());
                    System.out.println("\t" + (String)callTime.getKey() + pad + val / 1000L + "us");
                    if (limit-- == 0) break;
                }
                for (Map.Entry callTime : callTimes) {
                    this.state.callTiming.put((String)callTime.getKey(), 0L);
                }
                this.state.sampleCount = 0;
                this.state.timeSpentInGL = 0L;
                this.state.lastPrintOutTime = System.nanoTime();
            } else {
                ++this.state.sampleCount;
            }
            return null;
        }
        Long currentTimeObj = this.state.callTiming.get(methodName);
        long currentTime = 0L;
        if (currentTimeObj != null) {
            currentTime = currentTimeObj;
        }
        long l = System.nanoTime();
        Object result2 = method.invoke(this.obj, args2);
        long delta = System.nanoTime() - l;
        this.state.timeSpentInGL += delta;
        this.state.callTiming.put(methodName, currentTime += delta);
        if (delta > 1000000L && !methodName.equals("glClear")) {
            System.out.println("GL call " + methodName + " took " + delta / 1000L + "us to execute!");
        }
        return result2;
    }

    private static class CallTimingComparator
    implements Comparator<Map.Entry<String, Long>> {
        private CallTimingComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
            return (int)(o2.getValue() - o1.getValue());
        }
    }
}

