/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.opengl;

import com.jme3.renderer.Caps;
import com.jme3.renderer.opengl.GLImageFormat;
import com.jme3.texture.Image;
import java.util.EnumSet;

public final class GLImageFormats {
    private GLImageFormats() {
    }

    private static void format(GLImageFormat[][] formatToGL, Image.Format format2, int glInternalFormat, int glFormat, int glDataType) {
        formatToGL[0][format2.ordinal()] = new GLImageFormat(glInternalFormat, glFormat, glDataType);
    }

    private static void formatSwiz(GLImageFormat[][] formatToGL, Image.Format format2, int glInternalFormat, int glFormat, int glDataType) {
        formatToGL[0][format2.ordinal()] = new GLImageFormat(glInternalFormat, glFormat, glDataType, false, true);
    }

    private static void formatSrgb(GLImageFormat[][] formatToGL, Image.Format format2, int glInternalFormat, int glFormat, int glDataType) {
        formatToGL[1][format2.ordinal()] = new GLImageFormat(glInternalFormat, glFormat, glDataType);
    }

    private static void formatSrgbSwiz(GLImageFormat[][] formatToGL, Image.Format format2, int glInternalFormat, int glFormat, int glDataType) {
        formatToGL[1][format2.ordinal()] = new GLImageFormat(glInternalFormat, glFormat, glDataType, false, true);
    }

    private static void formatComp(GLImageFormat[][] formatToGL, Image.Format format2, int glCompressedFormat, int glFormat, int glDataType) {
        formatToGL[0][format2.ordinal()] = new GLImageFormat(glCompressedFormat, glFormat, glDataType, true);
    }

    private static void formatCompSrgb(GLImageFormat[][] formatToGL, Image.Format format2, int glCompressedFormat, int glFormat, int glDataType) {
        formatToGL[1][format2.ordinal()] = new GLImageFormat(glCompressedFormat, glFormat, glDataType, true);
    }

    public static GLImageFormat[][] getFormatsForCaps(EnumSet<Caps> caps) {
        GLImageFormat[][] formatToGL = new GLImageFormat[2][Image.Format.values().length];
        int halfFloatFormat = 5131;
        if (caps.contains((Object)Caps.OpenGLES20)) {
            halfFloatFormat = 36193;
        }
        if (caps.contains((Object)Caps.CoreProfile)) {
            GLImageFormats.formatSwiz(formatToGL, Image.Format.Alpha8, 33321, 6403, 5121);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.Luminance8, 33321, 6403, 5121);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.Luminance8Alpha8, 33323, 33319, 5121);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.Luminance16F, 33325, 6403, halfFloatFormat);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.Luminance32F, 33326, 6403, 5126);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.Luminance16FAlpha16F, 33327, 33319, halfFloatFormat);
            GLImageFormats.formatSrgbSwiz(formatToGL, Image.Format.Luminance8, 35905, 6403, 5121);
            GLImageFormats.formatSrgbSwiz(formatToGL, Image.Format.Luminance8Alpha8, 35907, 33319, 5121);
        }
        if (caps.contains((Object)Caps.OpenGL20)) {
            if (!caps.contains((Object)Caps.CoreProfile)) {
                GLImageFormats.format(formatToGL, Image.Format.Alpha8, 32828, 6406, 5121);
                GLImageFormats.format(formatToGL, Image.Format.Luminance8, 32832, 6409, 5121);
                GLImageFormats.format(formatToGL, Image.Format.Luminance8Alpha8, 32837, 6410, 5121);
            }
            GLImageFormats.format(formatToGL, Image.Format.RGB8, 32849, 6407, 5121);
            GLImageFormats.format(formatToGL, Image.Format.RGBA8, 32856, 6408, 5121);
            GLImageFormats.format(formatToGL, Image.Format.RGB565, 32849, 6407, 33635);
            GLImageFormats.format(formatToGL, Image.Format.BGR8, 32849, 32992, 5121);
            GLImageFormats.format(formatToGL, Image.Format.ARGB8, 32856, 32993, 32821);
            GLImageFormats.format(formatToGL, Image.Format.BGRA8, 32856, 32993, 5121);
            GLImageFormats.format(formatToGL, Image.Format.ABGR8, 32856, 6408, 32821);
            if (caps.contains((Object)Caps.Srgb)) {
                GLImageFormats.formatSrgb(formatToGL, Image.Format.RGB8, 35905, 6407, 5121);
                GLImageFormats.formatSrgb(formatToGL, Image.Format.RGB565, 35905, 6407, 33635);
                GLImageFormats.formatSrgb(formatToGL, Image.Format.RGB5A1, 35907, 6408, 32820);
                GLImageFormats.formatSrgb(formatToGL, Image.Format.RGBA8, 35907, 6408, 5121);
                if (!caps.contains((Object)Caps.CoreProfile)) {
                    GLImageFormats.formatSrgb(formatToGL, Image.Format.Luminance8, 35911, 6409, 5121);
                    GLImageFormats.formatSrgb(formatToGL, Image.Format.Luminance8Alpha8, 35909, 6410, 5121);
                }
                GLImageFormats.formatSrgb(formatToGL, Image.Format.BGR8, 35905, 32992, 5121);
                GLImageFormats.formatSrgb(formatToGL, Image.Format.ABGR8, 35907, 6408, 32821);
                GLImageFormats.formatSrgb(formatToGL, Image.Format.ARGB8, 35907, 32993, 32821);
                GLImageFormats.formatSrgb(formatToGL, Image.Format.BGRA8, 35907, 32993, 5121);
                if (caps.contains((Object)Caps.TextureCompressionS3TC)) {
                    GLImageFormats.formatCompSrgb(formatToGL, Image.Format.DXT1, 35916, 6407, 5121);
                    GLImageFormats.formatCompSrgb(formatToGL, Image.Format.DXT1A, 35917, 6408, 5121);
                    GLImageFormats.formatCompSrgb(formatToGL, Image.Format.DXT3, 35918, 6408, 5121);
                    GLImageFormats.formatCompSrgb(formatToGL, Image.Format.DXT5, 35919, 6408, 5121);
                }
            }
        } else if (caps.contains((Object)Caps.Rgba8)) {
            if (!caps.contains((Object)Caps.CoreProfile)) {
                GLImageFormats.format(formatToGL, Image.Format.Alpha8, 32856, 6406, 5121);
                GLImageFormats.format(formatToGL, Image.Format.Luminance8, 32856, 6409, 5121);
                GLImageFormats.format(formatToGL, Image.Format.Luminance8Alpha8, 32856, 6410, 5121);
            }
            GLImageFormats.format(formatToGL, Image.Format.RGB8, 32849, 6407, 5121);
            GLImageFormats.format(formatToGL, Image.Format.RGBA8, 32856, 6408, 5121);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.BGR8, 32849, 6407, 5121);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.ARGB8, 32856, 6408, 5121);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.BGRA8, 32856, 6408, 5121);
            GLImageFormats.formatSwiz(formatToGL, Image.Format.ABGR8, 32856, 6408, 5121);
        } else {
            if (!caps.contains((Object)Caps.CoreProfile)) {
                GLImageFormats.format(formatToGL, Image.Format.Alpha8, 32854, 6406, 5121);
                GLImageFormats.format(formatToGL, Image.Format.Luminance8, 36194, 6409, 5121);
                GLImageFormats.format(formatToGL, Image.Format.Luminance8Alpha8, 32854, 6410, 5121);
            }
            GLImageFormats.format(formatToGL, Image.Format.RGB8, 36194, 6407, 5121);
            GLImageFormats.format(formatToGL, Image.Format.RGBA8, 32854, 6408, 5121);
        }
        if (caps.contains((Object)Caps.OpenGLES20)) {
            GLImageFormats.format(formatToGL, Image.Format.RGB565, 36194, 6407, 33635);
        }
        GLImageFormats.format(formatToGL, Image.Format.RGB5A1, 32855, 6408, 32820);
        if (caps.contains((Object)Caps.FloatTexture)) {
            if (!caps.contains((Object)Caps.CoreProfile)) {
                GLImageFormats.format(formatToGL, Image.Format.Luminance16F, 34846, 6409, halfFloatFormat);
                GLImageFormats.format(formatToGL, Image.Format.Luminance32F, 34840, 6409, 5126);
                GLImageFormats.format(formatToGL, Image.Format.Luminance16FAlpha16F, 34847, 6410, halfFloatFormat);
            }
            GLImageFormats.format(formatToGL, Image.Format.R16F, 33325, 6403, halfFloatFormat);
            GLImageFormats.format(formatToGL, Image.Format.R32F, 33326, 6403, 5126);
            GLImageFormats.format(formatToGL, Image.Format.RG16F, 33327, 33319, halfFloatFormat);
            GLImageFormats.format(formatToGL, Image.Format.RG32F, 33328, 33319, 5126);
            GLImageFormats.format(formatToGL, Image.Format.RGB16F, 34843, 6407, halfFloatFormat);
            GLImageFormats.format(formatToGL, Image.Format.RGB32F, 34837, 6407, 5126);
            GLImageFormats.format(formatToGL, Image.Format.RGBA16F, 34842, 6408, halfFloatFormat);
            GLImageFormats.format(formatToGL, Image.Format.RGBA32F, 34836, 6408, 5126);
        }
        if (caps.contains((Object)Caps.PackedFloatTexture)) {
            GLImageFormats.format(formatToGL, Image.Format.RGB111110F, 35898, 6407, 35899);
            if (caps.contains((Object)Caps.FloatTexture)) {
                GLImageFormats.format(formatToGL, Image.Format.RGB16F_to_RGB111110F, 35898, 6407, halfFloatFormat);
            }
        }
        if (caps.contains((Object)Caps.SharedExponentTexture)) {
            GLImageFormats.format(formatToGL, Image.Format.RGB9E5, 35901, 6407, 35902);
            if (caps.contains((Object)Caps.FloatTexture)) {
                GLImageFormats.format(formatToGL, Image.Format.RGB16F_to_RGB9E5, 35901, 6407, halfFloatFormat);
            }
        }
        if (caps.contains((Object)Caps.OpenGLES30)) {
            GLImageFormats.format(formatToGL, Image.Format.RGB10A2, 32857, 6408, 33640);
            GLImageFormats.format(formatToGL, Image.Format.Alpha8, 32828, 6406, 5121);
            GLImageFormats.format(formatToGL, Image.Format.Luminance8, 6409, 6409, 5121);
            GLImageFormats.format(formatToGL, Image.Format.Luminance8Alpha8, 6410, 6410, 5121);
            GLImageFormats.formatSrgb(formatToGL, Image.Format.RGB8, 35905, 6407, 5121);
            GLImageFormats.formatSrgb(formatToGL, Image.Format.RGBA8, 35907, 6408, 5121);
            GLImageFormats.format(formatToGL, Image.Format.RGB16F, 34843, 6407, 5131);
            GLImageFormats.format(formatToGL, Image.Format.RGB32F, 34837, 6407, 5126);
            GLImageFormats.format(formatToGL, Image.Format.RGBA16F, 34842, 6408, 5131);
            GLImageFormats.format(formatToGL, Image.Format.RGBA32F, 34836, 6408, 5126);
            GLImageFormats.format(formatToGL, Image.Format.RGB111110F, 35898, 6407, 35899);
        }
        GLImageFormats.format(formatToGL, Image.Format.Depth16, 33189, 6402, 5123);
        if (caps.contains((Object)Caps.OpenGLES20)) {
            GLImageFormats.format(formatToGL, Image.Format.Depth, 33189, 6402, 5123);
        } else {
            GLImageFormats.format(formatToGL, Image.Format.Depth, 6402, 6402, 5121);
        }
        if (caps.contains((Object)Caps.OpenGL20) || caps.contains((Object)Caps.Depth24)) {
            GLImageFormats.format(formatToGL, Image.Format.Depth24, 33190, 6402, 5125);
        }
        if (caps.contains((Object)Caps.FloatDepthBuffer)) {
            GLImageFormats.format(formatToGL, Image.Format.Depth32F, 36012, 6402, 5126);
        }
        if (caps.contains((Object)Caps.PackedDepthStencilBuffer)) {
            GLImageFormats.format(formatToGL, Image.Format.Depth24Stencil8, 35056, 34041, 34042);
        }
        if (caps.contains((Object)Caps.TextureCompressionS3TC)) {
            GLImageFormats.formatComp(formatToGL, Image.Format.DXT1, 33776, 6407, 5121);
            GLImageFormats.formatComp(formatToGL, Image.Format.DXT1A, 33777, 6408, 5121);
            GLImageFormats.formatComp(formatToGL, Image.Format.DXT3, 33778, 6408, 5121);
            GLImageFormats.formatComp(formatToGL, Image.Format.DXT5, 33779, 6408, 5121);
        }
        if (caps.contains((Object)Caps.OpenGL30) || caps.contains((Object)Caps.TextureCompressionRGTC)) {
            GLImageFormats.formatComp(formatToGL, Image.Format.RGTC2, 36285, 33319, 5121);
            GLImageFormats.formatComp(formatToGL, Image.Format.SIGNED_RGTC2, 36286, 33319, 5120);
            GLImageFormats.formatComp(formatToGL, Image.Format.RGTC1, 36283, 6403, 5121);
            GLImageFormats.formatComp(formatToGL, Image.Format.SIGNED_RGTC1, 36284, 6403, 5120);
        }
        if (caps.contains((Object)Caps.TextureCompressionETC2)) {
            GLImageFormats.formatComp(formatToGL, Image.Format.ETC1, 37492, 6407, 5121);
        } else if (caps.contains((Object)Caps.TextureCompressionETC1)) {
            GLImageFormats.formatComp(formatToGL, Image.Format.ETC1, 36196, 6407, 5121);
        }
        if (caps.contains((Object)Caps.OpenGL42) || caps.contains((Object)Caps.TextureCompressionBPTC)) {
            GLImageFormats.formatComp(formatToGL, Image.Format.BC6H_SF16, 36494, 6407, 5121);
            GLImageFormats.formatComp(formatToGL, Image.Format.BC6H_UF16, 36495, 6407, 5121);
            GLImageFormats.formatComp(formatToGL, Image.Format.BC7_UNORM, 36492, 6408, 5125);
            GLImageFormats.formatComp(formatToGL, Image.Format.BC7_UNORM_SRGB, 36493, 6408, 5125);
        }
        if (caps.contains((Object)Caps.IntegerTexture)) {
            GLImageFormats.format(formatToGL, Image.Format.R8I, 33329, 36244, 5120);
            GLImageFormats.format(formatToGL, Image.Format.R8UI, 33330, 36244, 5121);
            GLImageFormats.format(formatToGL, Image.Format.R16I, 33331, 36244, 5122);
            GLImageFormats.format(formatToGL, Image.Format.R16UI, 33332, 36244, 5123);
            GLImageFormats.format(formatToGL, Image.Format.R32I, 33333, 36244, 5124);
            GLImageFormats.format(formatToGL, Image.Format.R32UI, 33334, 36244, 5125);
            GLImageFormats.format(formatToGL, Image.Format.RG8I, 33335, 33320, 5120);
            GLImageFormats.format(formatToGL, Image.Format.RG8UI, 33336, 33320, 5121);
            GLImageFormats.format(formatToGL, Image.Format.RG16I, 33337, 33320, 5122);
            GLImageFormats.format(formatToGL, Image.Format.RG16UI, 33338, 33320, 5123);
            GLImageFormats.format(formatToGL, Image.Format.RG32I, 33339, 33320, 5124);
            GLImageFormats.format(formatToGL, Image.Format.RG32UI, 33340, 33320, 5125);
            GLImageFormats.format(formatToGL, Image.Format.RGB8I, 36239, 36248, 5120);
            GLImageFormats.format(formatToGL, Image.Format.RGB8UI, 36221, 36248, 5121);
            GLImageFormats.format(formatToGL, Image.Format.RGB16I, 36233, 36248, 5122);
            GLImageFormats.format(formatToGL, Image.Format.RGB16UI, 36215, 36248, 5123);
            GLImageFormats.format(formatToGL, Image.Format.RGB32I, 36227, 36248, 5124);
            GLImageFormats.format(formatToGL, Image.Format.RGB32UI, 36209, 36248, 5125);
            GLImageFormats.format(formatToGL, Image.Format.RGBA8I, 36238, 36249, 5120);
            GLImageFormats.format(formatToGL, Image.Format.RGBA8UI, 36220, 36249, 5121);
            GLImageFormats.format(formatToGL, Image.Format.RGBA16I, 36232, 36249, 5122);
            GLImageFormats.format(formatToGL, Image.Format.RGBA16UI, 36214, 36249, 5123);
            GLImageFormats.format(formatToGL, Image.Format.RGBA32I, 36226, 36249, 5124);
            GLImageFormats.format(formatToGL, Image.Format.RGBA32UI, 36208, 36249, 5125);
        }
        return formatToGL;
    }
}

