/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.scene.Mesh;
import com.jme3.shader.Shader;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.util.IntMap;

public class Statistics {
    protected boolean enabled = false;
    protected int numObjects;
    protected int numTriangles;
    protected int numVertices;
    protected int numShaderSwitches;
    protected int numTextureBinds;
    protected int numFboSwitches;
    protected int numUniformsSet;
    protected int memoryShaders;
    protected int memoryFrameBuffers;
    protected int memoryTextures;
    protected IntMap<Void> shadersUsed = new IntMap();
    protected IntMap<Void> texturesUsed = new IntMap();
    protected IntMap<Void> fbosUsed = new IntMap();
    protected int lastShader = -1;

    public String[] getLabels() {
        return new String[]{"Vertices", "Triangles", "Uniforms", "Objects", "Shaders (S)", "Shaders (F)", "Shaders (M)", "Textures (S)", "Textures (F)", "Textures (M)", "FrameBuffers (S)", "FrameBuffers (F)", "FrameBuffers (M)"};
    }

    public void getData(int[] data2) {
        data2[0] = this.numVertices;
        data2[1] = this.numTriangles;
        data2[2] = this.numUniformsSet;
        data2[3] = this.numObjects;
        data2[4] = this.numShaderSwitches;
        data2[5] = this.shadersUsed.size();
        data2[6] = this.memoryShaders;
        data2[7] = this.numTextureBinds;
        data2[8] = this.texturesUsed.size();
        data2[9] = this.memoryTextures;
        data2[10] = this.numFboSwitches;
        data2[11] = this.fbosUsed.size();
        data2[12] = this.memoryFrameBuffers;
    }

    public void onMeshDrawn(Mesh mesh, int lod, int count2) {
        if (!this.enabled) {
            return;
        }
        ++this.numObjects;
        this.numTriangles += mesh.getTriangleCount(lod) * count2;
        this.numVertices += mesh.getVertexCount() * count2;
    }

    public void onMeshDrawn(Mesh mesh, int lod) {
        this.onMeshDrawn(mesh, lod, 1);
    }

    public void onShaderUse(Shader shader, boolean wasSwitched) {
        assert (shader.getId() >= 1);
        if (!this.enabled) {
            return;
        }
        if (this.lastShader != shader.getId()) {
            this.lastShader = shader.getId();
            if (!this.shadersUsed.containsKey(shader.getId())) {
                this.shadersUsed.put(shader.getId(), null);
            }
        }
        if (wasSwitched) {
            ++this.numShaderSwitches;
        }
    }

    public void onUniformSet() {
        if (!this.enabled) {
            return;
        }
        ++this.numUniformsSet;
    }

    public void onTextureUse(Image image, boolean wasSwitched) {
        assert (image.getId() >= 1);
        if (!this.enabled) {
            return;
        }
        if (!this.texturesUsed.containsKey(image.getId())) {
            this.texturesUsed.put(image.getId(), null);
        }
        if (wasSwitched) {
            ++this.numTextureBinds;
        }
    }

    public void onFrameBufferUse(FrameBuffer fb, boolean wasSwitched) {
        if (!this.enabled) {
            return;
        }
        if (fb != null) {
            assert (fb.getId() >= 1);
            if (!this.fbosUsed.containsKey(fb.getId())) {
                this.fbosUsed.put(fb.getId(), null);
            }
        }
        if (wasSwitched) {
            ++this.numFboSwitches;
        }
    }

    public void clearFrame() {
        this.shadersUsed.clear();
        this.texturesUsed.clear();
        this.fbosUsed.clear();
        this.numObjects = 0;
        this.numTriangles = 0;
        this.numVertices = 0;
        this.numShaderSwitches = 0;
        this.numTextureBinds = 0;
        this.numFboSwitches = 0;
        this.numUniformsSet = 0;
        this.lastShader = -1;
    }

    public void onNewShader() {
        if (!this.enabled) {
            return;
        }
        ++this.memoryShaders;
    }

    public void onNewTexture() {
        if (!this.enabled) {
            return;
        }
        ++this.memoryTextures;
    }

    public void onNewFrameBuffer() {
        if (!this.enabled) {
            return;
        }
        ++this.memoryFrameBuffers;
    }

    public void onDeleteShader() {
        if (!this.enabled) {
            return;
        }
        --this.memoryShaders;
    }

    public void onDeleteTexture() {
        if (!this.enabled) {
            return;
        }
        --this.memoryTextures;
    }

    public void onDeleteFrameBuffer() {
        if (!this.enabled) {
            return;
        }
        --this.memoryFrameBuffers;
    }

    public void clearMemory() {
        this.memoryFrameBuffers = 0;
        this.memoryShaders = 0;
        this.memoryTextures = 0;
    }

    public void setEnabled(boolean f) {
        this.enabled = f;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

