/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.effect.ParticleEmitter;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TranslucentBucketFilter
extends Filter {
    private static final Logger logger = Logger.getLogger(TranslucentBucketFilter.class.getName());
    private RenderManager renderManager;
    private boolean enabledSoftParticles = false;
    private Texture depthTexture;
    private ViewPort viewPort;

    public TranslucentBucketFilter() {
        super("TranslucentBucketFilter");
    }

    public TranslucentBucketFilter(boolean enabledSoftParticles) {
        this();
        this.enabledSoftParticles = enabledSoftParticles;
    }

    @Override
    protected void initFilter(AssetManager manager, RenderManager rm, ViewPort vp, int w, int h) {
        this.renderManager = rm;
        this.viewPort = vp;
        this.material = new Material(manager, "Common/MatDefs/Post/Overlay.j3md");
        this.material.setColor("Color", ColorRGBA.White);
        Texture2D tex = this.processor.getFilterTexture();
        this.material.setTexture("Texture", tex);
        if (tex.getImage().getMultiSamples() > 1) {
            this.material.setInt("NumSamples", tex.getImage().getMultiSamples());
        } else {
            this.material.clearParam("NumSamples");
        }
        this.renderManager.setHandleTranslucentBucket(false);
        if (this.enabledSoftParticles && this.depthTexture != null) {
            this.initSoftParticles(vp, true);
        }
    }

    private void initSoftParticles(ViewPort vp, boolean enabledSP) {
        if (this.depthTexture != null) {
            for (Spatial scene2 : vp.getScenes()) {
                this.makeSoftParticleEmitter(scene2, enabledSP && this.enabled);
            }
        }
    }

    @Override
    protected void setDepthTexture(Texture depthTexture) {
        this.depthTexture = depthTexture;
        if (this.enabledSoftParticles && depthTexture != null) {
            this.initSoftParticles(this.viewPort, true);
        }
    }

    @Override
    protected boolean isRequiresSceneTexture() {
        return false;
    }

    @Override
    protected boolean isRequiresDepthTexture() {
        return this.enabledSoftParticles;
    }

    @Override
    protected void postFrame(RenderManager renderManager, ViewPort viewPort, FrameBuffer prevFilterBuffer, FrameBuffer sceneBuffer) {
        renderManager.setCamera(viewPort.getCamera(), false);
        if (prevFilterBuffer != sceneBuffer) {
            renderManager.getRenderer().copyFrameBuffer(prevFilterBuffer, sceneBuffer, true, false);
        }
        renderManager.getRenderer().setFrameBuffer(sceneBuffer);
        viewPort.getQueue().renderQueue(RenderQueue.Bucket.Translucent, renderManager, viewPort.getCamera());
    }

    @Override
    protected void cleanUpFilter(Renderer r) {
        if (this.renderManager != null) {
            this.renderManager.setHandleTranslucentBucket(true);
        }
        this.initSoftParticles(this.viewPort, false);
    }

    @Override
    protected Material getMaterial() {
        return this.material;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.renderManager != null) {
            this.renderManager.setHandleTranslucentBucket(!enabled);
        }
        this.initSoftParticles(this.viewPort, this.enabledSoftParticles);
    }

    private void makeSoftParticleEmitter(Spatial scene2, boolean enabled) {
        if (scene2 instanceof Node) {
            Node n = (Node)scene2;
            for (Spatial child2 : n.getChildren()) {
                this.makeSoftParticleEmitter(child2, enabled);
            }
        }
        if (scene2 instanceof ParticleEmitter) {
            ParticleEmitter emitter = (ParticleEmitter)scene2;
            if (enabled) {
                this.enabledSoftParticles = enabled;
                emitter.getMaterial().selectTechnique("SoftParticles", this.renderManager);
                if (this.processor.getNumSamples() > 1) {
                    emitter.getMaterial().setInt("NumSamplesDepth", this.processor.getNumSamples());
                }
                emitter.getMaterial().setTexture("DepthTexture", this.processor.getDepthTexture());
                emitter.setQueueBucket(RenderQueue.Bucket.Translucent);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Made particle Emitter {0} soft.", emitter.getName());
                }
            } else {
                emitter.getMaterial().clearParam("DepthTexture");
                emitter.getMaterial().selectTechnique("Default", this.renderManager);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Particle Emitter {0} is not soft anymore.", emitter.getName());
                }
            }
        }
    }
}

