/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.Material;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.io.IOException;

public class DepthOfFieldFilter
extends Filter {
    private float focusDistance = 50.0f;
    private float focusRange = 10.0f;
    private float blurScale = 1.0f;
    private float blurThreshold = 0.2f;
    private float xScale;
    private float yScale;
    private boolean debugUnfocus;

    public DepthOfFieldFilter() {
        super("Depth Of Field");
    }

    @Override
    protected boolean isRequiresDepthTexture() {
        return true;
    }

    @Override
    protected Material getMaterial() {
        return this.material;
    }

    @Override
    protected void initFilter(AssetManager assets, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(assets, "Common/MatDefs/Post/DepthOfField.j3md");
        this.material.setFloat("FocusDistance", this.focusDistance);
        this.material.setFloat("FocusRange", this.focusRange);
        this.material.setFloat("BlurThreshold", this.blurThreshold);
        this.material.setBoolean("DebugUnfocus", this.debugUnfocus);
        this.xScale = 1.0f / (float)w;
        this.yScale = 1.0f / (float)h;
        this.material.setFloat("XScale", this.blurScale * this.xScale);
        this.material.setFloat("YScale", this.blurScale * this.yScale);
    }

    public void setFocusDistance(float f) {
        this.focusDistance = f;
        if (this.material != null) {
            this.material.setFloat("FocusDistance", this.focusDistance);
        }
    }

    public float getFocusDistance() {
        return this.focusDistance;
    }

    public void setFocusRange(float f) {
        this.focusRange = f;
        if (this.material != null) {
            this.material.setFloat("FocusRange", this.focusRange);
        }
    }

    public float getFocusRange() {
        return this.focusRange;
    }

    public void setBlurScale(float f) {
        this.blurScale = f;
        if (this.material != null) {
            this.material.setFloat("XScale", this.blurScale * this.xScale);
            this.material.setFloat("YScale", this.blurScale * this.yScale);
        }
    }

    public float getBlurScale() {
        return this.blurScale;
    }

    public void setBlurThreshold(float f) {
        this.blurThreshold = f;
        if (this.material != null) {
            this.material.setFloat("BlurThreshold", this.blurThreshold);
        }
    }

    public float getBlurThreshold() {
        return this.blurThreshold;
    }

    public void setDebugUnfocus(boolean b) {
        this.debugUnfocus = b;
        if (this.material != null) {
            this.material.setBoolean("DebugUnfocus", this.debugUnfocus);
        }
    }

    public boolean getDebugUnfocus() {
        return this.debugUnfocus;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.blurScale, "blurScale", 1.0f);
        oc.write(this.blurScale, "blurThreshold", 0.2f);
        oc.write(this.focusDistance, "focusDistance", 50.0f);
        oc.write(this.focusRange, "focusRange", 10.0f);
        oc.write(this.debugUnfocus, "debugUnfocus", false);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.blurScale = ic.readFloat("blurScale", 1.0f);
        this.blurThreshold = ic.readFloat("blurThreshold", 0.2f);
        this.focusDistance = ic.readFloat("focusDistance", 50.0f);
        this.focusRange = ic.readFloat("focusRange", 10.0f);
        this.debugUnfocus = ic.readBoolean("debugUnfocus", false);
    }
}

