/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl.info;

import com.jme3.opencl.OpenCLException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CL20;
import org.lwjgl.opencl.INTELAccelerator;
import org.lwjgl.opencl.KHRICD;
import org.lwjgl.system.APIUtil;

public final class CLUtil {
    private static final Map<Integer, String> CL_ERROR_TOKENS = APIUtil.apiClassTokens(new BiPredicate<Field, Integer>(){
        private final List<String> EXCLUDE = Arrays.asList("CL_DEVICE_TYPE_ALL", "CL_BUILD_NONE", "CL_BUILD_ERROR", "CL_BUILD_IN_PROGRESS");

        @Override
        public boolean test(Field field, Integer value) {
            return value < 0 && !this.EXCLUDE.contains(field.getName());
        }
    }, null, CL10.class, com.jme3.lwjgl3.utils.APIUtil.apiOptionalClass("org.lwjgl.opencl.CL10GL"), CL11.class, CL12.class, CL20.class, com.jme3.lwjgl3.utils.APIUtil.apiOptionalClass("org.lwjgl.opencl.APPLEGLSharing"), INTELAccelerator.class, com.jme3.lwjgl3.utils.APIUtil.apiOptionalClass("org.lwjgl.opencl.KHRGLSharing"), com.jme3.lwjgl3.utils.APIUtil.apiOptionalClass("org.lwjgl.opencl.KHREGLEvent"), com.jme3.lwjgl3.utils.APIUtil.apiOptionalClass("org.lwjgl.opencl.KHREGLImage"), KHRICD.class);

    private CLUtil() {
    }

    public static void checkCLError(ByteBuffer errorCodeBuffer) {
        CLUtil.checkCLError(errorCodeBuffer.getInt(errorCodeBuffer.position()));
    }

    public static void checkCLError(IntBuffer errorCodeBuffer) {
        CLUtil.checkCLError(errorCodeBuffer.get(errorCodeBuffer.position()));
    }

    public static void checkCLError(int errcode) {
        if (errcode != 0) {
            throw new OpenCLException(CLUtil.getErrcodeName(errcode));
        }
    }

    public static String getErrcodeName(int errcode) {
        String errname = CL_ERROR_TOKENS.get(errcode);
        if (errname == null) {
            errname = APIUtil.apiUnknownToken(errcode);
        }
        return errname;
    }
}

