/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Device;
import com.jme3.opencl.Kernel;
import com.jme3.opencl.KernelCompilationException;
import com.jme3.opencl.OpenCLException;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.Program;
import com.jme3.opencl.lwjgl.LwjglContext;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglKernel;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.system.MemoryUtil;

public class LwjglProgram
extends Program {
    private static final Logger LOG = Logger.getLogger(LwjglProgram.class.getName());
    private final long program;
    private final LwjglContext context;

    public LwjglProgram(long program, LwjglContext context2) {
        super(new ReleaserImpl(program));
        this.program = program;
        this.context = context2;
    }

    public long getProgram() {
        return this.program;
    }

    @Override
    public void build(String args2, Device ... devices) throws KernelCompilationException {
        int ret;
        PointerBuffer deviceList = null;
        if (devices != null) {
            deviceList = PointerBuffer.allocateDirect(devices.length);
            deviceList.rewind();
            for (Device d : devices) {
                deviceList.put(((LwjglDevice)d).getDevice());
            }
            deviceList.flip();
        }
        if ((ret = CL10.clBuildProgram(this.program, deviceList, (CharSequence)args2, null, 0L)) != 0) {
            String log = this.Log();
            LOG.log(Level.WARNING, "Unable to compile program:\n{0}", log);
            if (ret == -11) {
                throw new KernelCompilationException("Failed to build program", ret, log);
            }
            Utils.checkError(ret, "clBuildProgram");
        } else {
            LOG.log(Level.INFO, "Program compiled:\n{0}", this.Log());
        }
    }

    private String Log(long device2) {
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clGetProgramBuildInfo(this.program, device2, 4483, (ByteBuffer)null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clGetProgramBuildInfo");
        int count2 = (int)Utils.pointerBuffers[0].get(0);
        ByteBuffer buffer = BufferUtils.createByteBuffer(count2);
        ret = CL10.clGetProgramBuildInfo(this.program, device2, 4483, buffer, null);
        Utils.checkError(ret, "clGetProgramBuildInfo");
        return MemoryUtil.memASCII(buffer);
    }

    private String Log() {
        StringBuilder str = new StringBuilder();
        for (LwjglDevice device2 : this.context.getDevices()) {
            long d = device2.getDevice();
            str.append(device2.getName()).append(":\n");
            str.append(this.Log(d));
            str.append('\n');
        }
        return str.toString();
    }

    @Override
    public Kernel createKernel(String name) {
        long kernel = CL10.clCreateKernel(this.program, (CharSequence)name, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateKernel");
        return new LwjglKernel(kernel);
    }

    @Override
    public Kernel[] createAllKernels() {
        Utils.tempBuffers[0].b16i.rewind();
        int ret = CL10.clCreateKernelsInProgram(this.program, null, Utils.tempBuffers[0].b16i);
        Utils.checkError(ret, "clCreateKernelsInProgram");
        int count2 = Utils.tempBuffers[0].b16i.get(0);
        PointerBuffer buf = PointerBuffer.allocateDirect(count2);
        ret = CL10.clCreateKernelsInProgram(this.program, buf, (IntBuffer)null);
        Utils.checkError(ret, "clCreateKernelsInProgram");
        Kernel[] kx = new Kernel[count2];
        for (int i = 0; i < count2; ++i) {
            kx[i] = new LwjglKernel(buf.get());
        }
        return kx;
    }

    @Override
    public ByteBuffer getBinary(Device d) {
        LwjglDevice device2 = (LwjglDevice)d;
        int numDevices = Info.clGetProgramInfoInt(this.program, 4450);
        PointerBuffer devices = PointerBuffer.allocateDirect(numDevices);
        int ret = CL10.clGetProgramInfo(this.program, 4451, devices, null);
        Utils.checkError(ret, "clGetProgramInfo: CL_PROGRAM_DEVICES");
        int index2 = -1;
        for (int i = 0; i < numDevices; ++i) {
            if (devices.get(i) != device2.getDevice()) continue;
            index2 = i;
        }
        if (index2 == -1) {
            throw new OpenCLException("Program was not built against the specified device " + device2);
        }
        PointerBuffer sizes = PointerBuffer.allocateDirect(numDevices);
        ret = CL10.clGetProgramInfo(this.program, 4453, sizes, null);
        Utils.checkError(ret, "clGetProgramInfo: CL_PROGRAM_BINARY_SIZES");
        int size2 = (int)sizes.get(index2);
        PointerBuffer binaryPointers = PointerBuffer.allocateDirect(numDevices);
        for (int i = 0; i < binaryPointers.capacity(); ++i) {
            binaryPointers.put(0L);
        }
        binaryPointers.rewind();
        ByteBuffer binaries = ByteBuffer.allocateDirect(size2);
        binaryPointers.put(index2, binaries);
        ret = CL10.clGetProgramInfo(this.program, 4454, binaryPointers, null);
        Utils.checkError(ret, "clGetProgramInfo: CL_PROGRAM_BINARIES");
        return binaries;
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long program;

        private ReleaserImpl(long program) {
            this.program = program;
        }

        @Override
        public void release() {
            if (this.program != 0L) {
                int ret = CL10.clReleaseProgram(this.program);
                this.program = 0L;
                Utils.reportError(ret, "clReleaseProgram");
            }
        }
    }
}

