/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector4f;
import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Device;
import com.jme3.opencl.Event;
import com.jme3.opencl.Image;
import com.jme3.opencl.Kernel;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.LwjglBuffer;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglEvent;
import com.jme3.opencl.lwjgl.LwjglImage;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;

public class LwjglKernel
extends Kernel {
    private final long kernel;

    public LwjglKernel(long kernel) {
        super(new ReleaserImpl(kernel));
        this.kernel = kernel;
    }

    public long getKernel() {
        return this.kernel;
    }

    @Override
    public String getName() {
        return Info.clGetKernelInfoStringASCII(this.kernel, 4496);
    }

    @Override
    public int getArgCount() {
        return Info.clGetKernelInfoInt(this.kernel, 4497);
    }

    @Override
    public long getMaxWorkGroupSize(Device device2) {
        long d = ((LwjglDevice)device2).getDevice();
        return Info.clGetKernelWorkGroupInfoPointer(this.kernel, d, 4528);
    }

    @Override
    public void setArg(int index2, Kernel.LocalMemPerElement t) {
        int ret = CL10.clSetKernelArg(this.kernel, index2, (long)t.getSize() * this.workGroupSize.getSizes()[0] * this.workGroupSize.getSizes()[1] * this.workGroupSize.getSizes()[2]);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, Kernel.LocalMem t) {
        int ret = CL10.clSetKernelArg(this.kernel, index2, t.getSize());
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, Buffer t) {
        int ret = CL10.clSetKernelArg1p(this.kernel, index2, ((LwjglBuffer)t).getBuffer());
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, Image i) {
        int ret = CL10.clSetKernelArg1p(this.kernel, index2, ((LwjglImage)i).getImage());
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, byte b) {
        int ret = CL10.clSetKernelArg1b(this.kernel, index2, b);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, short s) {
        int ret = CL10.clSetKernelArg1s(this.kernel, index2, s);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, int i) {
        int ret = CL10.clSetKernelArg1i(this.kernel, index2, i);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, long l) {
        int ret = CL10.clSetKernelArg1l(this.kernel, index2, l);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, float f) {
        int ret = CL10.clSetKernelArg1f(this.kernel, index2, f);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, double d) {
        int ret = CL10.clSetKernelArg1d(this.kernel, index2, d);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, Vector2f v) {
        int ret = CL10.clSetKernelArg2f(this.kernel, index2, v.x, v.y);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, Vector4f v) {
        int ret = CL10.clSetKernelArg4f(this.kernel, index2, v.x, v.y, v.z, v.w);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, Quaternion q) {
        int ret = CL10.clSetKernelArg4f(this.kernel, index2, q.getX(), q.getY(), q.getZ(), q.getW());
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, Matrix4f m) {
        FloatBuffer buf = Utils.b80f;
        buf.position(0);
        buf.limit(16);
        buf.put(m.m00).put(m.m01).put(m.m02).put(m.m03);
        buf.put(m.m10).put(m.m11).put(m.m12).put(m.m13);
        buf.put(m.m20).put(m.m21).put(m.m22).put(m.m23);
        buf.put(m.m30).put(m.m31).put(m.m32).put(m.m33);
        buf.position(0);
        int ret = CL10.clSetKernelArg(this.kernel, index2, buf);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public void setArg(int index2, ByteBuffer buffer, long size2) {
        buffer.limit((int)((long)buffer.position() + size2));
        int ret = CL10.clSetKernelArg(this.kernel, index2, buffer);
        Utils.checkError(ret, "clSetKernelArg");
    }

    @Override
    public Event Run(CommandQueue queue) {
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[1].put(this.globalWorkSize.getSizes());
        Utils.pointerBuffers[1].position(0);
        PointerBuffer p2 = null;
        if (this.workGroupSize.getSizes()[0] > 0L) {
            p2 = (PointerBuffer)Utils.pointerBuffers[2].rewind();
            p2.put(this.workGroupSize.getSizes());
            p2.position(0);
        }
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueNDRangeKernel(q, this.kernel, this.globalWorkSize.getDimension(), null, Utils.pointerBuffers[1], p2, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueNDRangeKernel");
        return new LwjglEvent(Utils.pointerBuffers[0].get(0));
    }

    @Override
    public void RunNoEvent(CommandQueue queue) {
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[1].put(this.globalWorkSize.getSizes());
        Utils.pointerBuffers[1].position(0);
        PointerBuffer p2 = null;
        if (this.workGroupSize.getSizes()[0] > 0L) {
            p2 = (PointerBuffer)Utils.pointerBuffers[2].rewind();
            p2.put(this.workGroupSize.getSizes());
            p2.position(0);
        }
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueNDRangeKernel(q, this.kernel, this.globalWorkSize.getDimension(), null, Utils.pointerBuffers[1], p2, null, null);
        Utils.checkError(ret, "clEnqueueNDRangeKernel");
    }

    @Override
    public OpenCLObject.ObjectReleaser getReleaser() {
        return new ReleaserImpl(this.kernel);
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long kernel;

        private ReleaserImpl(long kernel) {
            this.kernel = kernel;
        }

        @Override
        public void release() {
            if (this.kernel != 0L) {
                int ret = CL10.clReleaseKernel(this.kernel);
                this.kernel = 0L;
                Utils.reportError(ret, "clReleaseKernel");
            }
        }
    }
}

