/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.math.ColorRGBA;
import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Event;
import com.jme3.opencl.Image;
import com.jme3.opencl.MappingAccess;
import com.jme3.opencl.OpenCLException;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.LwjglBuffer;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglEvent;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CLImageFormat;

public class LwjglImage
extends Image {
    private static final Logger LOG = Logger.getLogger(LwjglImage.class.getName());
    private final long image;

    public LwjglImage(long image) {
        super(new ReleaserImpl(image));
        this.image = image;
    }

    public long getImage() {
        return this.image;
    }

    public static int decodeImageChannelOrder(Image.ImageChannelOrder order) {
        switch (order) {
            case A: {
                return 4273;
            }
            case ARGB: {
                return 4279;
            }
            case BGRA: {
                return 4278;
            }
            case INTENSITY: {
                return 4280;
            }
            case LUMINANCE: {
                return 4281;
            }
            case R: {
                return 4272;
            }
            case RA: {
                return 4275;
            }
            case RG: {
                return 4274;
            }
            case RGB: {
                return 4276;
            }
            case RGBA: {
                return 4277;
            }
            case RGBx: {
                return 4284;
            }
            case RGx: {
                return 4283;
            }
            case Rx: {
                return 4282;
            }
        }
        throw new IllegalArgumentException("unknown image channel order: " + (Object)((Object)order));
    }

    public static Image.ImageChannelOrder encodeImageChannelOrder(int order) {
        switch (order) {
            case 4273: {
                return Image.ImageChannelOrder.A;
            }
            case 4279: {
                return Image.ImageChannelOrder.ARGB;
            }
            case 4278: {
                return Image.ImageChannelOrder.BGRA;
            }
            case 4280: {
                return Image.ImageChannelOrder.INTENSITY;
            }
            case 4281: {
                return Image.ImageChannelOrder.LUMINANCE;
            }
            case 4272: {
                return Image.ImageChannelOrder.R;
            }
            case 4275: {
                return Image.ImageChannelOrder.RA;
            }
            case 4274: {
                return Image.ImageChannelOrder.RG;
            }
            case 4276: {
                return Image.ImageChannelOrder.RGB;
            }
            case 4277: {
                return Image.ImageChannelOrder.RGBA;
            }
            case 4284: {
                return Image.ImageChannelOrder.RGBx;
            }
            case 4283: {
                return Image.ImageChannelOrder.RGx;
            }
            case 4282: {
                return Image.ImageChannelOrder.Rx;
            }
        }
        LOG.log(Level.WARNING, "Unknown image channel order id: {0}", order);
        return null;
    }

    public static int decodeImageChannelType(Image.ImageChannelType type2) {
        switch (type2) {
            case FLOAT: {
                return 4318;
            }
            case HALF_FLOAT: {
                return 4317;
            }
            case SIGNED_INT16: {
                return 4312;
            }
            case SIGNED_INT32: {
                return 4313;
            }
            case SIGNED_INT8: {
                return 4311;
            }
            case SNORM_INT16: {
                return 4305;
            }
            case SNORM_INT8: {
                return 4304;
            }
            case UNORM_INT8: {
                return 4306;
            }
            case UNORM_INT_101010: {
                return 4310;
            }
            case UNORM_INT16: {
                return 4307;
            }
            case UNORM_SHORT_565: {
                return 4308;
            }
            case UNORM_SHORT_555: {
                return 4309;
            }
            case UNSIGNED_INT16: {
                return 4315;
            }
            case UNSIGNED_INT32: {
                return 4316;
            }
            case UNSIGNED_INT8: {
                return 4314;
            }
        }
        throw new IllegalArgumentException("Unknown image channel type: " + (Object)((Object)type2));
    }

    public static Image.ImageChannelType encodeImageChannelType(int type2) {
        switch (type2) {
            case 4318: {
                return Image.ImageChannelType.FLOAT;
            }
            case 4317: {
                return Image.ImageChannelType.HALF_FLOAT;
            }
            case 4312: {
                return Image.ImageChannelType.SIGNED_INT16;
            }
            case 4313: {
                return Image.ImageChannelType.SIGNED_INT32;
            }
            case 4311: {
                return Image.ImageChannelType.SIGNED_INT8;
            }
            case 4305: {
                return Image.ImageChannelType.SNORM_INT16;
            }
            case 4304: {
                return Image.ImageChannelType.SNORM_INT8;
            }
            case 4306: {
                return Image.ImageChannelType.UNORM_INT8;
            }
            case 4307: {
                return Image.ImageChannelType.UNORM_INT16;
            }
            case 4310: {
                return Image.ImageChannelType.UNORM_INT_101010;
            }
            case 4309: {
                return Image.ImageChannelType.UNORM_SHORT_555;
            }
            case 4308: {
                return Image.ImageChannelType.UNORM_SHORT_565;
            }
            case 4315: {
                return Image.ImageChannelType.UNSIGNED_INT16;
            }
            case 4316: {
                return Image.ImageChannelType.UNSIGNED_INT32;
            }
            case 4314: {
                return Image.ImageChannelType.UNSIGNED_INT8;
            }
        }
        LOG.log(Level.WARNING, "Unknown image channel type id: {0}", type2);
        return null;
    }

    public static int decodeImageType(Image.ImageType type2) {
        switch (type2) {
            case IMAGE_1D: {
                return 4340;
            }
            case IMAGE_1D_ARRAY: {
                return 4341;
            }
            case IMAGE_1D_BUFFER: {
                return 4342;
            }
            case IMAGE_2D: {
                return 4337;
            }
            case IMAGE_2D_ARRAY: {
                return 4339;
            }
            case IMAGE_3D: {
                return 4338;
            }
        }
        throw new IllegalArgumentException("Unknown image type: " + (Object)((Object)type2));
    }

    public static Image.ImageType encodeImageType(int type2) {
        switch (type2) {
            case 4340: {
                return Image.ImageType.IMAGE_1D;
            }
            case 4341: {
                return Image.ImageType.IMAGE_1D_ARRAY;
            }
            case 4342: {
                return Image.ImageType.IMAGE_1D_BUFFER;
            }
            case 4337: {
                return Image.ImageType.IMAGE_2D;
            }
            case 4339: {
                return Image.ImageType.IMAGE_2D_ARRAY;
            }
            case 4338: {
                return Image.ImageType.IMAGE_3D;
            }
        }
        throw new OpenCLException("Unknown image type id: " + type2);
    }

    @Override
    public long getWidth() {
        return Info.clGetImageInfoPointer(this.image, 4372);
    }

    @Override
    public long getHeight() {
        return Info.clGetImageInfoPointer(this.image, 4373);
    }

    @Override
    public long getDepth() {
        return Info.clGetImageInfoPointer(this.image, 4374);
    }

    @Override
    public long getRowPitch() {
        return Info.clGetImageInfoPointer(this.image, 4370);
    }

    @Override
    public long getSlicePitch() {
        return Info.clGetImageInfoPointer(this.image, 4371);
    }

    @Override
    public long getArraySize() {
        return Info.clGetImageInfoPointer(this.image, 4375);
    }

    @Override
    public Image.ImageFormat getImageFormat() {
        Utils.b80.rewind();
        CLImageFormat format2 = new CLImageFormat(Utils.b80);
        int limit = Utils.b80.limit();
        Utils.b80.limit(format2.sizeof());
        int ret = CL10.clGetImageInfo(this.image, 4368, Utils.b80, null);
        Utils.b80.limit(limit);
        Utils.checkError(ret, "clGetImageInfo");
        return new Image.ImageFormat(LwjglImage.encodeImageChannelOrder(format2.image_channel_order()), LwjglImage.encodeImageChannelType(format2.image_channel_data_type()));
    }

    @Override
    public Image.ImageType getImageType() {
        int type2 = Info.clGetMemObjectInfoInt(this.image, 4352);
        return LwjglImage.encodeImageType(type2);
    }

    @Override
    public int getElementSize() {
        return Info.clGetImageInfoInt(this.image, 4369);
    }

    @Override
    public void readImage(CommandQueue queue, ByteBuffer dest, long[] origin2, long[] region, long rowPitch, long slicePitch) {
        if (origin2.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(origin2).position(0);
        Utils.pointerBuffers[2].put(region).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueReadImage(q, this.image, true, Utils.pointerBuffers[1], Utils.pointerBuffers[2], rowPitch, slicePitch, dest, null, null);
        Utils.checkError(ret, "clEnqueueReadImage");
    }

    @Override
    public Event readImageAsync(CommandQueue queue, ByteBuffer dest, long[] origin2, long[] region, long rowPitch, long slicePitch) {
        if (origin2.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(origin2).position(0);
        Utils.pointerBuffers[2].put(region).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueReadImage(q, this.image, false, Utils.pointerBuffers[1], Utils.pointerBuffers[2], rowPitch, slicePitch, dest, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueReadImage");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public void writeImage(CommandQueue queue, ByteBuffer dest, long[] origin2, long[] region, long rowPitch, long slicePitch) {
        if (origin2.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(origin2).position(0);
        Utils.pointerBuffers[2].put(region).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueWriteImage(q, this.image, true, Utils.pointerBuffers[1], Utils.pointerBuffers[2], rowPitch, slicePitch, dest, null, null);
        Utils.checkError(ret, "clEnqueueWriteImage");
    }

    @Override
    public Event writeImageAsync(CommandQueue queue, ByteBuffer dest, long[] origin2, long[] region, long rowPitch, long slicePitch) {
        if (origin2.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(origin2).position(0);
        Utils.pointerBuffers[2].put(region).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueWriteImage(q, this.image, false, Utils.pointerBuffers[1], Utils.pointerBuffers[2], rowPitch, slicePitch, dest, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueWriteImage");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public void copyTo(CommandQueue queue, Image dest, long[] srcOrigin, long[] destOrigin, long[] region) {
        if (srcOrigin.length != 3 || destOrigin.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[3].rewind();
        Utils.pointerBuffers[1].put(srcOrigin).position(0);
        Utils.pointerBuffers[2].put(destOrigin).position(0);
        Utils.pointerBuffers[3].put(region).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueCopyImage(q, this.image, ((LwjglImage)dest).getImage(), Utils.pointerBuffers[1], Utils.pointerBuffers[2], Utils.pointerBuffers[3], null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyImage");
        long event = Utils.pointerBuffers[0].get(0);
        ret = CL10.clWaitForEvents(event);
        Utils.checkError(ret, "clWaitForEvents");
    }

    @Override
    public Event copyToAsync(CommandQueue queue, Image dest, long[] srcOrigin, long[] destOrigin, long[] region) {
        if (srcOrigin.length != 3 || destOrigin.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[3].rewind();
        Utils.pointerBuffers[1].put(srcOrigin).position(0);
        Utils.pointerBuffers[2].put(destOrigin).position(0);
        Utils.pointerBuffers[3].put(region).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueCopyImage(q, this.image, ((LwjglImage)dest).getImage(), Utils.pointerBuffers[1], Utils.pointerBuffers[2], Utils.pointerBuffers[3], null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyImage");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public Image.ImageMapping map(CommandQueue queue, long[] origin2, long[] region, MappingAccess access) {
        if (origin2.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[3].rewind();
        Utils.pointerBuffers[4].rewind();
        Utils.pointerBuffers[1].put(origin2).position(0);
        Utils.pointerBuffers[2].put(region).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        long flags = Utils.getMappingAccessFlags(access);
        Utils.errorBuffer.rewind();
        ByteBuffer buf = CL10.clEnqueueMapImage(q, this.image, true, flags, Utils.pointerBuffers[1], Utils.pointerBuffers[2], Utils.pointerBuffers[3], Utils.pointerBuffers[4], null, null, Utils.errorBuffer, null);
        Utils.checkError(Utils.errorBuffer, "clEnqueueMapBuffer");
        return new Image.ImageMapping(buf, Utils.pointerBuffers[3].get(0), Utils.pointerBuffers[4].get(0));
    }

    @Override
    public Image.ImageMapping mapAsync(CommandQueue queue, long[] origin2, long[] region, MappingAccess access) {
        if (origin2.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[3].rewind();
        Utils.pointerBuffers[4].rewind();
        Utils.pointerBuffers[1].put(origin2).position(0);
        Utils.pointerBuffers[2].put(region).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        long flags = Utils.getMappingAccessFlags(access);
        Utils.errorBuffer.rewind();
        ByteBuffer buf = CL10.clEnqueueMapImage(q, this.image, false, flags, Utils.pointerBuffers[1], Utils.pointerBuffers[2], Utils.pointerBuffers[3], Utils.pointerBuffers[4], null, Utils.pointerBuffers[0], Utils.errorBuffer, null);
        Utils.checkError(Utils.errorBuffer, "clEnqueueMapBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new Image.ImageMapping(buf, Utils.pointerBuffers[3].get(0), Utils.pointerBuffers[4].get(0), new LwjglEvent(event));
    }

    @Override
    public void unmap(CommandQueue queue, Image.ImageMapping mapping) {
        mapping.buffer.position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clEnqueueUnmapMemObject(q, this.image, mapping.buffer, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueUnmapMemObject");
        long event = Utils.pointerBuffers[0].get(0);
        ret = CL10.clWaitForEvents(event);
        Utils.checkError(ret, "clWaitForEvents");
    }

    @Override
    public Event fillAsync(CommandQueue queue, long[] origin2, long[] region, ColorRGBA color2) {
        if (origin2.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(origin2).position(0);
        Utils.pointerBuffers[2].put(region).position(0);
        Utils.tempBuffers[0].b16f.rewind();
        Utils.tempBuffers[0].b16f.limit(4);
        Utils.tempBuffers[0].b16f.put(color2.r).put(color2.g).put(color2.b).put(color2.a);
        Utils.tempBuffers[0].b16.rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL12.clEnqueueFillImage(q, this.image, Utils.tempBuffers[0].b16, Utils.pointerBuffers[1], Utils.pointerBuffers[2], null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueFillImage");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public Event fillAsync(CommandQueue queue, long[] origin2, long[] region, int[] color2) {
        if (color2.length != 4) {
            throw new IllegalArgumentException("the passed color array must have length 4");
        }
        if (origin2.length != 3 || region.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(origin2).position(0);
        Utils.pointerBuffers[2].put(region).position(0);
        Utils.tempBuffers[0].b16i.rewind();
        Utils.tempBuffers[0].b16i.limit(4);
        Utils.tempBuffers[0].b16i.put(color2);
        Utils.tempBuffers[0].b16.rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL12.clEnqueueFillImage(q, this.image, Utils.tempBuffers[0].b16, Utils.pointerBuffers[1], Utils.pointerBuffers[2], null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueFillImage");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public Event copyToBufferAsync(CommandQueue queue, Buffer dest, long[] srcOrigin, long[] srcRegion, long destOffset) {
        if (srcOrigin.length != 3 || srcRegion.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(srcOrigin).position(0);
        Utils.pointerBuffers[2].put(srcRegion).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueCopyImageToBuffer(q, this.image, ((LwjglBuffer)dest).getBuffer(), Utils.pointerBuffers[1], Utils.pointerBuffers[2], destOffset, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyImageToBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public Event acquireImageForSharingAsync(CommandQueue queue) {
        Utils.pointerBuffers[0].rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueAcquireGLObjects(q, this.image, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueAcquireGLObjects");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public void acquireImageForSharingNoEvent(CommandQueue queue) {
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueAcquireGLObjects(q, this.image, null, null);
        Utils.checkError(ret, "clEnqueueAcquireGLObjects");
    }

    @Override
    public Event releaseImageForSharingAsync(CommandQueue queue) {
        Utils.assertSharingPossible();
        Utils.pointerBuffers[0].rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueReleaseGLObjects(q, this.image, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueReleaseGLObjects");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public void releaseImageForSharingNoEvent(CommandQueue queue) {
        Utils.assertSharingPossible();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueReleaseGLObjects(q, this.image, null, null);
        Utils.checkError(ret, "clEnqueueReleaseGLObjects");
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long mem;

        private ReleaserImpl(long mem) {
            this.mem = mem;
        }

        @Override
        public void release() {
            if (this.mem != 0L) {
                int ret = CL10.clReleaseMemObject(this.mem);
                this.mem = 0L;
                Utils.reportError(ret, "clReleaseMemObject");
            }
        }
    }
}

