/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Device;
import com.jme3.opencl.lwjgl.LwjglPlatform;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.util.Arrays;
import java.util.Collection;
import org.lwjgl.PointerBuffer;

public final class LwjglDevice
implements Device {
    final long device;
    final LwjglPlatform platform;

    public LwjglDevice(long device2, LwjglPlatform platform) {
        this.device = device2;
        this.platform = platform;
    }

    public long getDevice() {
        return this.device;
    }

    @Override
    public LwjglPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public Device.DeviceType getDeviceType() {
        int type2 = Info.clGetDeviceInfoInt(this.device, 4096);
        switch (type2) {
            case 8: {
                return Device.DeviceType.ACCELEARTOR;
            }
            case 2: {
                return Device.DeviceType.CPU;
            }
            case 4: {
                return Device.DeviceType.GPU;
            }
        }
        return Device.DeviceType.DEFAULT;
    }

    @Override
    public int getVendorId() {
        return Info.clGetDeviceInfoInt(this.device, 4097);
    }

    @Override
    public boolean isAvailable() {
        return Info.clGetDeviceInfoBoolean(this.device, 4135);
    }

    @Override
    public boolean hasCompiler() {
        return Info.clGetDeviceInfoBoolean(this.device, 4136);
    }

    @Override
    public boolean hasDouble() {
        return this.hasExtension("cl_khr_fp64");
    }

    @Override
    public boolean hasHalfFloat() {
        return this.hasExtension("cl_khr_fp16");
    }

    @Override
    public boolean hasErrorCorrectingMemory() {
        return Info.clGetDeviceInfoBoolean(this.device, 4132);
    }

    @Override
    public boolean hasUnifiedMemory() {
        return Info.clGetDeviceInfoBoolean(this.device, 4149);
    }

    @Override
    public boolean hasImageSupport() {
        return Info.clGetDeviceInfoBoolean(this.device, 4118);
    }

    @Override
    public boolean hasWritableImage3D() {
        return this.hasExtension("cl_khr_3d_image_writes");
    }

    @Override
    public boolean hasOpenGLInterop() {
        return this.hasExtension("cl_khr_gl_sharing");
    }

    @Override
    public boolean hasExtension(String extension) {
        return this.getExtensions().contains(extension);
    }

    @Override
    public Collection<? extends String> getExtensions() {
        return Arrays.asList(Info.clGetDeviceInfoStringASCII(this.device, 4144).split(" "));
    }

    @Override
    public int getComputeUnits() {
        return Info.clGetDeviceInfoInt(this.device, 4098);
    }

    @Override
    public int getClockFrequency() {
        return Info.clGetDeviceInfoInt(this.device, 4108);
    }

    @Override
    public int getAddressBits() {
        return Info.clGetDeviceInfoInt(this.device, 4109);
    }

    @Override
    public boolean isLittleEndian() {
        return Info.clGetDeviceInfoBoolean(this.device, 4134);
    }

    @Override
    public long getMaximumWorkItemDimensions() {
        return Info.clGetDeviceInfoInt(this.device, 4099);
    }

    @Override
    public long[] getMaximumWorkItemSizes() {
        int dim = (int)this.getMaximumWorkItemDimensions();
        PointerBuffer sizes = PointerBuffer.allocateDirect(dim);
        Info.clGetDeviceInfoPointers(this.device, 4101, sizes);
        long[] sx = new long[dim];
        sizes.get(sx);
        return sx;
    }

    @Override
    public long getMaxiumWorkItemsPerGroup() {
        return Info.clGetDeviceInfoPointer(this.device, 4100);
    }

    @Override
    public int getMaximumSamplers() {
        return Info.clGetDeviceInfoInt(this.device, 4120);
    }

    @Override
    public int getMaximumReadImages() {
        return Info.clGetDeviceInfoInt(this.device, 4110);
    }

    @Override
    public int getMaximumWriteImages() {
        return Info.clGetDeviceInfoInt(this.device, 4111);
    }

    @Override
    public long[] getMaximumImage2DSize() {
        return new long[]{Info.clGetDeviceInfoPointer(this.device, 4113), Info.clGetDeviceInfoPointer(this.device, 4114)};
    }

    @Override
    public long[] getMaximumImage3DSize() {
        return new long[]{Info.clGetDeviceInfoPointer(this.device, 4115), Info.clGetDeviceInfoPointer(this.device, 4116), Info.clGetDeviceInfoPointer(this.device, 4117)};
    }

    @Override
    public long getMaximumAllocationSize() {
        return Info.clGetDeviceInfoLong(this.device, 4112);
    }

    @Override
    public long getGlobalMemorySize() {
        return Info.clGetDeviceInfoLong(this.device, 4127);
    }

    @Override
    public long getLocalMemorySize() {
        return Info.clGetDeviceInfoLong(this.device, 4131);
    }

    @Override
    public long getMaximumConstantBufferSize() {
        return Info.clGetDeviceInfoLong(this.device, 4128);
    }

    @Override
    public int getMaximumConstantArguments() {
        return Info.clGetDeviceInfoInt(this.device, 4129);
    }

    @Override
    public String getProfile() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4142);
    }

    @Override
    public String getVersion() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4143);
    }

    @Override
    public int getVersionMajor() {
        return Utils.getMajorVersion(this.getVersion(), "OpenCL ");
    }

    @Override
    public int getVersionMinor() {
        return Utils.getMinorVersion(this.getVersion(), "OpenCL ");
    }

    @Override
    public String getCompilerVersion() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4157);
    }

    @Override
    public int getCompilerVersionMajor() {
        return Utils.getMajorVersion(this.getCompilerVersion(), "OpenCL C ");
    }

    @Override
    public int getCompilerVersionMinor() {
        return Utils.getMinorVersion(this.getCompilerVersion(), "OpenCL C ");
    }

    @Override
    public String getDriverVersion() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4141);
    }

    @Override
    public int getDriverVersionMajor() {
        return Utils.getMajorVersion(this.getDriverVersion(), "");
    }

    @Override
    public int getDriverVersionMinor() {
        return Utils.getMinorVersion(this.getDriverVersion(), "");
    }

    @Override
    public String getName() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4139);
    }

    @Override
    public String getVendor() {
        return Info.clGetDeviceInfoStringASCII(this.device, 4140);
    }

    public String toString() {
        return this.getName();
    }
}

