/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Context;
import com.jme3.opencl.Device;
import com.jme3.opencl.Image;
import com.jme3.opencl.MemoryAccess;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.Program;
import com.jme3.opencl.lwjgl.LwjglBuffer;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.LwjglImage;
import com.jme3.opencl.lwjgl.LwjglProgram;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CL12GL;
import org.lwjgl.opencl.CLImageDesc;
import org.lwjgl.opencl.CLImageFormat;

public class LwjglContext
extends Context {
    private static final Logger LOG = Logger.getLogger(LwjglContext.class.getName());
    private final long context;
    private final List<LwjglDevice> devices;

    public LwjglContext(long context2, List<LwjglDevice> devices) {
        super(new ReleaserImpl(context2, devices));
        this.context = context2;
        this.devices = devices;
    }

    public long getContext() {
        return this.context;
    }

    public List<LwjglDevice> getDevices() {
        return this.devices;
    }

    @Override
    public CommandQueue createQueue(Device device2) {
        assert (this.devices.contains(device2));
        long d = ((LwjglDevice)device2).getDevice();
        long properties2 = 0L;
        long q = CL10.clCreateCommandQueue(this.context, d, properties2, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateCommandQueue");
        return new LwjglCommandQueue(q, device2);
    }

    @Override
    public Buffer createBuffer(long size2, MemoryAccess access) {
        long flags = Utils.getMemoryAccessFlags(access);
        long mem = CL10.clCreateBuffer(this.context, flags, size2, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateBuffer");
        return new LwjglBuffer(mem);
    }

    @Override
    public Buffer createBufferFromHost(ByteBuffer data2, MemoryAccess access) {
        long flags = Utils.getMemoryAccessFlags(access);
        long mem = CL10.clCreateBuffer(this.context, flags |= 8L, data2, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateBuffer");
        return new LwjglBuffer(mem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image createImage(MemoryAccess access, Image.ImageFormat format2, Image.ImageDescriptor descr) {
        long memFlags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        CLImageFormat f = null;
        CLImageDesc d = null;
        try {
            f = CLImageFormat.malloc();
            d = CLImageDesc.calloc();
            f.image_channel_data_type(LwjglImage.decodeImageChannelType(format2.channelType));
            f.image_channel_order(LwjglImage.decodeImageChannelOrder(format2.channelOrder));
            d.image_type(LwjglImage.decodeImageType(descr.type));
            d.image_width(descr.width);
            d.image_height(descr.height);
            d.image_depth(descr.depth);
            d.image_array_size(descr.arraySize);
            d.image_row_pitch(descr.rowPitch);
            d.image_slice_pitch(descr.slicePitch);
            long mem = CL12.clCreateImage(this.context, memFlags, f, d, descr.hostPtr, Utils.errorBuffer);
            Utils.checkError(Utils.errorBuffer, "clCreateImage");
            LwjglImage lwjglImage = new LwjglImage(mem);
            return lwjglImage;
        }
        finally {
            if (f != null) {
                f.free();
            }
            if (d != null) {
                d.free();
            }
        }
    }

    @Override
    public Image.ImageFormat[] querySupportedFormats(MemoryAccess access, Image.ImageType type2) {
        long memFlags = Utils.getMemoryAccessFlags(access);
        int typeFlag = LwjglImage.decodeImageType(type2);
        Utils.tempBuffers[0].b16i.rewind();
        int ret = CL10.clGetSupportedImageFormats(this.context, memFlags, typeFlag, null, Utils.tempBuffers[0].b16i);
        Utils.checkError(ret, "clGetSupportedImageFormats");
        int count2 = Utils.tempBuffers[0].b16i.get(0);
        if (count2 == 0) {
            return new Image.ImageFormat[0];
        }
        CLImageFormat.Buffer formatsB = new CLImageFormat.Buffer(BufferUtils.createByteBuffer(count2 * CLImageFormat.SIZEOF));
        ret = CL10.clGetSupportedImageFormats(this.context, memFlags, typeFlag, formatsB, (IntBuffer)null);
        Utils.checkError(ret, "clGetSupportedImageFormats");
        Image.ImageFormat[] formats = new Image.ImageFormat[count2];
        for (int i = 0; i < count2; ++i) {
            CLImageFormat f = (CLImageFormat)formatsB.get();
            Image.ImageChannelOrder channelOrder = LwjglImage.encodeImageChannelOrder(f.image_channel_order());
            Image.ImageChannelType channelType = LwjglImage.encodeImageChannelType(f.image_channel_data_type());
            formats[i] = new Image.ImageFormat(channelOrder, channelType);
        }
        return formats;
    }

    @Override
    public Buffer bindVertexBuffer(VertexBuffer vb, MemoryAccess access) {
        Utils.assertSharingPossible();
        int id = vb.getId();
        if (id == -1) {
            throw new IllegalArgumentException("vertex buffer was not yet uploaded to the GPU or is CPU only");
        }
        long flags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        long mem = CL10GL.clCreateFromGLBuffer(this.context, flags, id, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLBuffer");
        return new LwjglBuffer(mem);
    }

    @Override
    public Image bindImage(com.jme3.texture.Image image, Texture.Type textureType, int mipLevel, MemoryAccess access) {
        Utils.assertSharingPossible();
        int imageID = image.getId();
        if (imageID == -1) {
            throw new IllegalArgumentException("image was not yet uploaded to the GPU");
        }
        long memFlags = Utils.getMemoryAccessFlags(access);
        int textureTarget = this.convertTextureType(textureType);
        Utils.errorBuffer.rewind();
        long mem = CL12GL.clCreateFromGLTexture(this.context, memFlags, textureTarget, mipLevel, imageID, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLTexture");
        return new LwjglImage(mem);
    }

    @Override
    protected Image bindPureRenderBuffer(FrameBuffer.RenderBuffer buffer, MemoryAccess access) {
        Utils.assertSharingPossible();
        int renderbuffer = buffer.getId();
        if (renderbuffer == -1) {
            throw new IllegalArgumentException("renderbuffer was not yet uploaded to the GPU");
        }
        long memFlags = Utils.getMemoryAccessFlags(access);
        Utils.errorBuffer.rewind();
        long mem = CL10GL.clCreateFromGLRenderbuffer(this.context, memFlags, renderbuffer, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateFromGLRenderbuffer");
        return new LwjglImage(mem);
    }

    private int convertTextureType(Texture.Type textureType) {
        switch (textureType) {
            case TwoDimensional: {
                return 3553;
            }
            case TwoDimensionalArray: {
                return 35866;
            }
            case ThreeDimensional: {
                return 32879;
            }
            case CubeMap: {
                return 34067;
            }
        }
        throw new IllegalArgumentException("unknown texture type " + (Object)((Object)textureType));
    }

    @Override
    public Program createProgramFromSourceCode(String sourceCode) {
        LOG.log(Level.FINE, "Create program from source:\n{0}", sourceCode);
        Utils.errorBuffer.rewind();
        long p = CL10.clCreateProgramWithSource(this.context, sourceCode, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateProgramWithSource");
        return new LwjglProgram(p, this);
    }

    @Override
    public Program createProgramFromBinary(ByteBuffer binaries, Device device2) {
        Utils.errorBuffer.rewind();
        Utils.tempBuffers[0].b16i.rewind();
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[0].put(0, ((LwjglDevice)device2).getDevice());
        long p = CL10.clCreateProgramWithBinary(this.context, Utils.pointerBuffers[0], binaries, Utils.tempBuffers[0].b16i, Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clCreateProgramWithBinary");
        Utils.checkError(Utils.tempBuffers[0].b16i, "clCreateProgramWithBinary");
        return new LwjglProgram(p, this);
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long context;
        private final List<LwjglDevice> devices;

        private ReleaserImpl(long mem, List<LwjglDevice> devices) {
            this.context = mem;
            this.devices = devices;
        }

        @Override
        public void release() {
            if (this.context != 0L) {
                int ret = CL10.clReleaseContext(this.context);
                this.context = 0L;
                this.devices.clear();
                Utils.reportError(ret, "clReleaseMemObject");
            }
        }
    }
}

