/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Device;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.Utils;
import org.lwjgl.opencl.CL10;

public class LwjglCommandQueue
extends CommandQueue {
    private final long queue;

    public LwjglCommandQueue(long queue, Device device2) {
        super(new ReleaserImpl(queue), device2);
        this.queue = queue;
    }

    public long getQueue() {
        return this.queue;
    }

    @Override
    public void flush() {
        int ret = CL10.clFlush(this.queue);
        Utils.checkError(ret, "clFlush");
    }

    @Override
    public void finish() {
        int ret = CL10.clFinish(this.queue);
        Utils.checkError(ret, "clFinish");
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long queue;

        private ReleaserImpl(long queue) {
            this.queue = queue;
        }

        @Override
        public void release() {
            if (this.queue != 0L) {
                int ret = CL10.clReleaseCommandQueue(this.queue);
                this.queue = 0L;
                Utils.reportError(ret, "clReleaseCommandQueue");
            }
        }
    }
}

