/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Event;
import com.jme3.opencl.Image;
import com.jme3.opencl.MappingAccess;
import com.jme3.opencl.MemoryAccess;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglEvent;
import com.jme3.opencl.lwjgl.LwjglImage;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.nio.ByteBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL12;

public class LwjglBuffer
extends Buffer {
    private final long buffer;

    public LwjglBuffer(long buffer) {
        super(new ReleaserImpl(buffer));
        this.buffer = buffer;
    }

    public long getBuffer() {
        return this.buffer;
    }

    @Override
    public long getSize() {
        return Info.clGetMemObjectInfoLong(this.buffer, 4354);
    }

    @Override
    public MemoryAccess getMemoryAccessFlags() {
        return Utils.getMemoryAccessFromFlag(Info.clGetMemObjectInfoLong(this.buffer, 4353));
    }

    @Override
    public void read(CommandQueue queue, ByteBuffer dest, long size2, long offset2) {
        dest.limit((int)((long)dest.position() + size2));
        int ret = CL10.clEnqueueReadBuffer(((LwjglCommandQueue)queue).getQueue(), this.buffer, true, offset2, dest, null, null);
        Utils.checkError(ret, "clEnqueueReadBuffer");
    }

    @Override
    public Event readAsync(CommandQueue queue, ByteBuffer dest, long size2, long offset2) {
        dest.limit((int)((long)dest.position() + size2));
        Utils.pointerBuffers[0].rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueReadBuffer(q, this.buffer, false, offset2, dest, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueReadBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public void write(CommandQueue queue, ByteBuffer src, long size2, long offset2) {
        src.limit((int)((long)src.position() + size2));
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueWriteBuffer(q, this.buffer, true, offset2, src, null, null);
        Utils.checkError(ret, "clEnqueueWriteBuffer");
    }

    @Override
    public Event writeAsync(CommandQueue queue, ByteBuffer src, long size2, long offset2) {
        src.limit((int)((long)src.position() + size2));
        Utils.pointerBuffers[0].rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueWriteBuffer(q, this.buffer, false, offset2, src, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueWriteBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public void copyTo(CommandQueue queue, Buffer dest, long size2, long srcOffset, long destOffset) {
        long q = ((LwjglCommandQueue)queue).getQueue();
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clEnqueueCopyBuffer(q, this.buffer, ((LwjglBuffer)dest).buffer, srcOffset, destOffset, size2, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        ret = CL10.clWaitForEvents(event);
        Utils.checkError(ret, "clWaitForEvents");
    }

    @Override
    public Event copyToAsync(CommandQueue queue, Buffer dest, long size2, long srcOffset, long destOffset) {
        long q = ((LwjglCommandQueue)queue).getQueue();
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clEnqueueCopyBuffer(q, this.buffer, ((LwjglBuffer)dest).buffer, srcOffset, destOffset, size2, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public ByteBuffer map(CommandQueue queue, long size2, long offset2, MappingAccess access) {
        long q = ((LwjglCommandQueue)queue).getQueue();
        long flags = Utils.getMappingAccessFlags(access);
        Utils.errorBuffer.rewind();
        ByteBuffer b = CL10.clEnqueueMapBuffer(q, this.buffer, true, flags, offset2, size2, null, null, Utils.errorBuffer, null);
        Utils.checkError(Utils.errorBuffer, "clEnqueueMapBuffer");
        return b;
    }

    @Override
    public void unmap(CommandQueue queue, ByteBuffer ptr) {
        ptr.position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clEnqueueUnmapMemObject(q, this.buffer, ptr, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueUnmapMemObject");
        long event = Utils.pointerBuffers[0].get(0);
        ret = CL10.clWaitForEvents(event);
        Utils.checkError(ret, "clWaitForEvents");
    }

    @Override
    public Buffer.AsyncMapping mapAsync(CommandQueue queue, long size2, long offset2, MappingAccess access) {
        Utils.pointerBuffers[0].rewind();
        Utils.errorBuffer.rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        long flags = Utils.getMappingAccessFlags(access);
        ByteBuffer buf = CL10.clEnqueueMapBuffer(q, this.buffer, false, flags, offset2, size2, null, Utils.pointerBuffers[0], Utils.errorBuffer, null);
        Utils.checkError(Utils.errorBuffer, "clEnqueueMapBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new Buffer.AsyncMapping(new LwjglEvent(event), buf);
    }

    @Override
    public Event fillAsync(CommandQueue queue, ByteBuffer pattern, long size2, long offset2) {
        Utils.pointerBuffers[0].rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL12.clEnqueueFillBuffer(q, this.buffer, pattern, offset2, size2, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueFillBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public Event copyToImageAsync(CommandQueue queue, Image dest, long srcOffset, long[] destOrigin, long[] destRegion) {
        if (destOrigin.length != 3 || destRegion.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(destOrigin).position(0);
        Utils.pointerBuffers[2].put(destRegion).position(0);
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueCopyBufferToImage(q, this.buffer, ((LwjglImage)dest).getImage(), srcOffset, Utils.pointerBuffers[1], Utils.pointerBuffers[2], null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyBufferToImage");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public Event acquireBufferForSharingAsync(CommandQueue queue) {
        Utils.pointerBuffers[0].rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueAcquireGLObjects(q, this.buffer, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueAcquireGLObjects");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public void acquireBufferForSharingNoEvent(CommandQueue queue) {
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueAcquireGLObjects(q, this.buffer, null, null);
        Utils.checkError(ret, "clEnqueueAcquireGLObjects");
    }

    @Override
    public Event releaseBufferForSharingAsync(CommandQueue queue) {
        Utils.assertSharingPossible();
        Utils.pointerBuffers[0].rewind();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueReleaseGLObjects(q, this.buffer, null, Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueReleaseGLObjects");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(event);
    }

    @Override
    public void releaseBufferForSharingNoEvent(CommandQueue queue) {
        Utils.assertSharingPossible();
        long q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueReleaseGLObjects(q, this.buffer, null, null);
        Utils.checkError(ret, "clEnqueueReleaseGLObjects");
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private long mem;

        private ReleaserImpl(long mem) {
            this.mem = mem;
        }

        @Override
        public void release() {
            if (this.mem != 0L) {
                int ret = CL10.clReleaseMemObject(this.mem);
                this.mem = 0L;
                Utils.reportError(ret, "clReleaseMemObject");
            }
        }
    }
}

