/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl;

import com.jme3.opencl.Context;
import com.jme3.opencl.Device;
import com.jme3.opencl.OpenCLException;
import com.jme3.opencl.Program;
import com.jme3.system.JmeSystem;
import com.jme3.util.BufferUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProgramCache {
    private static final Logger LOG = Logger.getLogger(ProgramCache.class.getName());
    private static final String FILE_EXTENSION = ".clbin";
    private final Context context;
    private final Device device;
    private final File tmpFolder;

    public ProgramCache() {
        this.context = null;
        this.device = null;
        this.tmpFolder = null;
    }

    public ProgramCache(Context context2, Device device2) {
        this.context = context2;
        this.device = device2;
        this.tmpFolder = JmeSystem.isLowPermissions() ? null : JmeSystem.getStorageFolder();
    }

    protected String getCleanFileName(String id) {
        return id.replaceAll("[^a-zA-Z0-9.-]", "") + FILE_EXTENSION;
    }

    public ProgramCache(Context context2) {
        this(context2, context2.getDevices().get(0));
    }

    public Program loadFromCache(String id, String buildArgs) {
        Program program;
        ByteBuffer bb;
        if (this.tmpFolder == null) {
            return null;
        }
        File file = new File(this.tmpFolder, this.getCleanFileName(id));
        if (!file.exists()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Cache file {0} does not exist", file.getAbsolutePath());
            }
            return null;
        }
        try {
            byte[] bytes = Files.readAllBytes(file.toPath());
            bb = BufferUtils.createByteBuffer(bytes);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "Unable to read cache file", ex);
            return null;
        }
        try {
            program = this.context.createProgramFromBinary(bb, this.device);
        }
        catch (OpenCLException ex) {
            LOG.log(Level.FINE, "Unable to create program from binary", ex);
            return null;
        }
        try {
            program.build(buildArgs, this.device);
        }
        catch (OpenCLException ex) {
            LOG.log(Level.FINE, "Unable to build program", ex);
            return null;
        }
        return program;
    }

    public Program loadFromCache(String id) {
        return this.loadFromCache(id, "");
    }

    public void saveToCache(String id, Program program) {
        ByteBuffer bb;
        if (this.tmpFolder == null) {
            return;
        }
        File file = new File(this.tmpFolder, this.getCleanFileName(id));
        try {
            bb = program.getBinary(this.device);
        }
        catch (OpenCLException | UnsupportedOperationException ex) {
            LOG.log(Level.WARNING, "Unable to retrieve the program binaries", ex);
            return;
        }
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        try {
            Files.write(file.toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Unable to save program binaries to the cache", ex);
        }
    }

    public void clearCache() {
        if (this.tmpFolder == null) {
            return;
        }
        for (File file : this.tmpFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(FILE_EXTENSION)) continue;
            file.delete();
        }
    }
}

