/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl;

import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector4f;
import com.jme3.opencl.AbstractOpenCLObject;
import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Device;
import com.jme3.opencl.Event;
import com.jme3.opencl.Image;
import com.jme3.opencl.OpenCLObject;
import com.jme3.util.TempVars;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class Kernel
extends AbstractOpenCLObject {
    protected final WorkSize globalWorkSize = new WorkSize(0L);
    protected final WorkSize workGroupSize = new WorkSize(0L);

    protected Kernel(OpenCLObject.ObjectReleaser releaser) {
        super(releaser);
    }

    @Override
    public Kernel register() {
        super.register();
        return this;
    }

    public abstract String getName();

    public abstract int getArgCount();

    public WorkSize getGlobalWorkSize() {
        return this.globalWorkSize;
    }

    public void setGlobalWorkSize(WorkSize ws) {
        this.globalWorkSize.set(ws);
    }

    public void setGlobalWorkSize(int size2) {
        this.globalWorkSize.set(1, size2);
    }

    public void setGlobalWorkSize(int width2, int height2) {
        this.globalWorkSize.set(2, width2, height2);
    }

    public void setGlobalWorkSize(int width2, int height2, int depth) {
        this.globalWorkSize.set(3, width2, height2, depth);
    }

    public WorkSize getWorkGroupSize() {
        return this.workGroupSize;
    }

    public void setWorkGroupSize(WorkSize ws) {
        this.workGroupSize.set(ws);
    }

    public void setWorkGroupSize(int size2) {
        this.workGroupSize.set(1, size2);
    }

    public void setWorkGroupSize(int width2, int height2) {
        this.workGroupSize.set(2, width2, height2);
    }

    public void setWorkGroupSdize(int width2, int height2, int depth) {
        this.workGroupSize.set(3, width2, height2, depth);
    }

    public void setWorkGroupSizeToNull() {
        this.workGroupSize.set(1, 0L, 0L, 0L);
    }

    public abstract long getMaxWorkGroupSize(Device var1);

    public abstract void setArg(int var1, LocalMemPerElement var2);

    public abstract void setArg(int var1, LocalMem var2);

    public abstract void setArg(int var1, Buffer var2);

    public abstract void setArg(int var1, Image var2);

    public abstract void setArg(int var1, byte var2);

    public abstract void setArg(int var1, short var2);

    public abstract void setArg(int var1, int var2);

    public abstract void setArg(int var1, long var2);

    public abstract void setArg(int var1, float var2);

    public abstract void setArg(int var1, double var2);

    public abstract void setArg(int var1, Vector2f var2);

    public abstract void setArg(int var1, Vector4f var2);

    public abstract void setArg(int var1, Quaternion var2);

    public abstract void setArg(int var1, Matrix4f var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArg(int index2, Matrix3f mat) {
        TempVars vars = TempVars.get();
        try {
            Matrix4f m = vars.tempMat4;
            m.zero();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    m.set(i, j, mat.get(i, j));
                }
            }
            this.setArg(index2, m);
        }
        finally {
            vars.release();
        }
    }

    public abstract void setArg(int var1, ByteBuffer var2, long var3);

    public void setArg(int index2, Object arg) {
        if (arg instanceof Byte) {
            this.setArg(index2, (Byte)arg);
        } else if (arg instanceof Short) {
            this.setArg(index2, (Short)arg);
        } else if (arg instanceof Integer) {
            this.setArg(index2, (Integer)arg);
        } else if (arg instanceof Long) {
            this.setArg(index2, (Long)arg);
        } else if (arg instanceof Float) {
            this.setArg(index2, ((Float)arg).floatValue());
        } else if (arg instanceof Double) {
            this.setArg(index2, (Double)arg);
        } else if (arg instanceof Vector2f) {
            this.setArg(index2, (Vector2f)arg);
        } else if (arg instanceof Vector4f) {
            this.setArg(index2, (Vector4f)arg);
        } else if (arg instanceof Quaternion) {
            this.setArg(index2, (Quaternion)arg);
        } else if (arg instanceof Matrix3f) {
            this.setArg(index2, (Matrix3f)arg);
        } else if (arg instanceof Matrix4f) {
            this.setArg(index2, (Matrix4f)arg);
        } else if (arg instanceof LocalMemPerElement) {
            this.setArg(index2, (LocalMemPerElement)arg);
        } else if (arg instanceof LocalMem) {
            this.setArg(index2, (LocalMem)arg);
        } else if (arg instanceof Buffer) {
            this.setArg(index2, (Buffer)arg);
        } else if (arg instanceof Image) {
            this.setArg(index2, (Image)arg);
        } else {
            throw new IllegalArgumentException("unknown kernel argument type: " + arg);
        }
    }

    private void setArgs(Object ... args2) {
        for (int i = 0; i < args2.length; ++i) {
            this.setArg(i, args2[i]);
        }
    }

    public abstract Event Run(CommandQueue var1);

    public void RunNoEvent(CommandQueue queue) {
        this.Run(queue).release();
    }

    public Event Run1(CommandQueue queue, WorkSize globalWorkSize, Object ... args2) {
        this.setGlobalWorkSize(globalWorkSize);
        this.setWorkGroupSizeToNull();
        this.setArgs(args2);
        return this.Run(queue);
    }

    public void Run1NoEvent(CommandQueue queue, WorkSize globalWorkSize, Object ... args2) {
        this.setGlobalWorkSize(globalWorkSize);
        this.setWorkGroupSizeToNull();
        this.setArgs(args2);
        this.RunNoEvent(queue);
    }

    public Event Run2(CommandQueue queue, WorkSize globalWorkSize, WorkSize workGroupSize, Object ... args2) {
        this.setGlobalWorkSize(globalWorkSize);
        this.setWorkGroupSize(workGroupSize);
        this.setArgs(args2);
        return this.Run(queue);
    }

    public void Run2NoEvent(CommandQueue queue, WorkSize globalWorkSize, WorkSize workGroupSize, Object ... args2) {
        this.setGlobalWorkSize(globalWorkSize);
        this.setWorkGroupSize(workGroupSize);
        this.setArgs(args2);
        this.RunNoEvent(queue);
    }

    public String toString() {
        return "Kernel (" + this.getName() + ")";
    }

    public static final class WorkSize {
        private int dimension;
        private long[] sizes;

        public WorkSize(int dimension, long ... sizes) {
            this.set(dimension, sizes);
        }

        public WorkSize() {
            this(1, 1L, 1L, 1L);
        }

        public WorkSize(long size2) {
            this(1, size2, 1L, 1L);
        }

        public WorkSize(long width2, long height2) {
            this(2, width2, height2, 1L);
        }

        public WorkSize(long width2, long height2, long depth) {
            this(3, width2, height2, depth);
        }

        public int getDimension() {
            return this.dimension;
        }

        public long[] getSizes() {
            return this.sizes;
        }

        public void set(int dimension, long ... sizes) {
            if (sizes == null || sizes.length != 3) {
                throw new IllegalArgumentException("sizes must be an array of length 3");
            }
            if (dimension <= 0 || dimension > 3) {
                throw new IllegalArgumentException("dimension must be between 1 and 3");
            }
            this.dimension = dimension;
            this.sizes = sizes;
        }

        public void set(WorkSize ws) {
            this.dimension = ws.dimension;
            this.sizes = ws.sizes;
        }

        public int hashCode() {
            int hash = 5;
            hash = 47 * hash + this.dimension;
            hash = 47 * hash + Arrays.hashCode(this.sizes);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WorkSize other = (WorkSize)obj;
            if (this.dimension != other.dimension) {
                return false;
            }
            return Arrays.equals(this.sizes, other.sizes);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("WorkSize[");
            for (int i = 0; i < this.dimension; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(this.sizes[i]);
            }
            str.append(']');
            return str.toString();
        }
    }

    public static final class LocalMemPerElement {
        private int size;

        public LocalMemPerElement(int size2) {
            this.size = size2;
        }

        public int getSize() {
            return this.size;
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + this.size;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalMemPerElement other = (LocalMemPerElement)obj;
            return this.size == other.size;
        }

        public String toString() {
            return "LocalMemPerElement (" + this.size + "B)";
        }
    }

    public static final class LocalMem {
        private int size;

        public LocalMem(int size2) {
            this.size = size2;
        }

        public int getSize() {
            return this.size;
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + this.size;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalMem other = (LocalMem)obj;
            return this.size == other.size;
        }

        public String toString() {
            return "LocalMem (" + this.size + "B)";
        }
    }
}

